/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.runtime.options.Options;

class SpecializedMethodChooser {
    private static final boolean DISABLE_SPECIALIZATION = Options.getBooleanProperty("nashorn.scriptfunction.specialization.disable");

    SpecializedMethodChooser() {
    }

    static MethodHandle candidateWithLowestWeight(MethodType descType, MethodHandle initialCandidate, MethodHandle[] specs) {
        if (DISABLE_SPECIALIZATION || specs == null) {
            return initialCandidate;
        }
        int minimumWeight = Integer.MAX_VALUE;
        MethodHandle candidate = initialCandidate;
        for (MethodHandle spec : specs) {
            int specWeight;
            MethodType specType = spec.type();
            if (!SpecializedMethodChooser.typeCompatible(descType, specType) || (specWeight = SpecializedMethodChooser.weigh(specType)) >= minimumWeight) continue;
            candidate = spec;
            minimumWeight = specWeight;
        }
        return candidate;
    }

    private static boolean typeCompatible(MethodType desc, MethodType spec) {
        Class<?>[] sparray;
        Class<?>[] dparray = desc.parameterArray();
        if (dparray.length != (sparray = spec.parameterArray()).length) {
            return false;
        }
        for (int i = 0; i < dparray.length; ++i) {
            Type dp = Type.typeFor(dparray[i]);
            Type sp = Type.typeFor(sparray[i]);
            if (dp.isBoolean()) {
                return false;
            }
            if (Type.widest(dp, sp) == sp) continue;
            return false;
        }
        return true;
    }

    private static int weigh(MethodType t) {
        int weight = Type.typeFor(t.returnType()).getWeight();
        for (Class<?> paramType : t.parameterArray()) {
            int pweight = Type.typeFor(paramType).getWeight();
            weight += pweight;
        }
        return weight;
    }
}

