/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.linker;

import java.lang.invoke.MethodHandle;
import jdk.internal.dynalink.CallSiteDescriptor;
import jdk.internal.dynalink.beans.BeansLinker;
import jdk.internal.dynalink.linker.GuardedInvocation;
import jdk.internal.dynalink.linker.GuardingDynamicLinker;
import jdk.internal.dynalink.linker.LinkRequest;
import jdk.internal.dynalink.linker.LinkerServices;
import jdk.internal.dynalink.support.Guards;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.linker.Bootstrap;
import jdk.nashorn.internal.runtime.linker.Lookup;
import jdk.nashorn.internal.runtime.linker.NashornCallSiteDescriptor;
import jdk.nashorn.internal.runtime.linker.NashornLinker;

class NashornBottomLinker
implements GuardingDynamicLinker {
    private static final MethodHandle EMPTY_PROP_GETTER = Lookup.MH.dropArguments(Lookup.MH.constant(Object.class, ScriptRuntime.UNDEFINED), 0, Object.class);
    private static final MethodHandle EMPTY_ELEM_GETTER = Lookup.MH.dropArguments(EMPTY_PROP_GETTER, 0, Object.class);
    private static final MethodHandle EMPTY_PROP_SETTER = Lookup.MH.asType(EMPTY_ELEM_GETTER, EMPTY_ELEM_GETTER.type().changeReturnType(Void.TYPE));
    private static final MethodHandle EMPTY_ELEM_SETTER = Lookup.MH.dropArguments(EMPTY_PROP_SETTER, 0, Object.class);

    NashornBottomLinker() {
    }

    @Override
    public GuardedInvocation getGuardedInvocation(LinkRequest linkRequest, LinkerServices linkerServices) throws Exception {
        Object self = linkRequest.getReceiver();
        if (self == null) {
            return NashornBottomLinker.linkNull(linkRequest);
        }
        assert (NashornBottomLinker.isExpectedObject(self)) : "Couldn't link " + linkRequest.getCallSiteDescriptor() + " for " + self.getClass().getName();
        return NashornBottomLinker.linkBean(linkRequest, linkerServices);
    }

    private static GuardedInvocation linkBean(LinkRequest linkRequest, LinkerServices linkerServices) {
        String operator;
        NashornCallSiteDescriptor desc = (NashornCallSiteDescriptor)linkRequest.getCallSiteDescriptor();
        Object self = linkRequest.getReceiver();
        switch (operator = desc.getFirstOperator()) {
            case "new": {
                if (BeansLinker.isDynamicMethod(self)) {
                    throw ECMAErrors.typeError("method.not.constructor", ScriptRuntime.safeToString(self));
                }
                throw ECMAErrors.typeError("not.a.function", ScriptRuntime.safeToString(self));
            }
            case "call": {
                if (BeansLinker.isDynamicMethod(self)) {
                    throw ECMAErrors.typeError("no.method.matches.args", ScriptRuntime.safeToString(self));
                }
                throw ECMAErrors.typeError("not.a.function", ScriptRuntime.safeToString(self));
            }
            case "callMethod": 
            case "getMethod": {
                throw ECMAErrors.typeError("no.such.function", NashornBottomLinker.getArgument(linkRequest), ScriptRuntime.safeToString(self));
            }
            case "getProp": 
            case "getElem": {
                if (desc.getOperand() != null) {
                    return NashornBottomLinker.getInvocation(EMPTY_PROP_GETTER, self, linkerServices, desc);
                }
                return NashornBottomLinker.getInvocation(EMPTY_ELEM_GETTER, self, linkerServices, desc);
            }
            case "setProp": 
            case "setElem": {
                if (desc.getOperand() != null) {
                    return NashornBottomLinker.getInvocation(EMPTY_PROP_SETTER, self, linkerServices, desc);
                }
                return NashornBottomLinker.getInvocation(EMPTY_ELEM_SETTER, self, linkerServices, desc);
            }
        }
        throw new AssertionError((Object)("unknown call type " + desc));
    }

    private static GuardedInvocation getInvocation(MethodHandle handle, Object self, LinkerServices linkerServices, CallSiteDescriptor desc) {
        return Bootstrap.asType(new GuardedInvocation(handle, Guards.getClassGuard(self.getClass())), linkerServices, desc);
    }

    private static boolean isExpectedObject(Object obj) {
        return !NashornLinker.canLinkTypeStatic(obj.getClass());
    }

    private static GuardedInvocation linkNull(LinkRequest linkRequest) {
        String operator;
        NashornCallSiteDescriptor desc = (NashornCallSiteDescriptor)linkRequest.getCallSiteDescriptor();
        switch (operator = desc.getFirstOperator()) {
            case "new": 
            case "call": {
                throw ECMAErrors.typeError("not.a.function", "null");
            }
            case "callMethod": 
            case "getMethod": {
                throw ECMAErrors.typeError("no.such.function", NashornBottomLinker.getArgument(linkRequest), "null");
            }
            case "getProp": 
            case "getElem": {
                throw ECMAErrors.typeError("cant.get.property", NashornBottomLinker.getArgument(linkRequest), "null");
            }
            case "setProp": 
            case "setElem": {
                throw ECMAErrors.typeError("cant.set.property", NashornBottomLinker.getArgument(linkRequest), "null");
            }
        }
        throw new AssertionError((Object)("unknown call type " + desc));
    }

    private static String getArgument(LinkRequest linkRequest) {
        CallSiteDescriptor desc = linkRequest.getCallSiteDescriptor();
        if (desc.getNameTokenCount() > 2) {
            return desc.getNameToken(2);
        }
        return ScriptRuntime.safeToString(linkRequest.getArguments()[1]);
    }
}

