/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.regexp;

import jdk.nashorn.internal.parser.Lexer;
import jdk.nashorn.internal.runtime.ParserException;
import jdk.nashorn.internal.runtime.options.Options;
import jdk.nashorn.internal.runtime.regexp.DefaultRegExp;
import jdk.nashorn.internal.runtime.regexp.JoniRegExp;
import jdk.nashorn.internal.runtime.regexp.RegExp;

public class RegExpFactory {
    private static final RegExpFactory instance;
    private static final String JDK = "jdk";
    private static final String JONI = "joni";

    protected RegExp compile(String pattern, String flags) throws ParserException {
        return new DefaultRegExp(pattern, flags);
    }

    protected String replaceToken(String str) {
        switch (str) {
            case "\\s": {
                return "[" + Lexer.getWhitespaceRegExp() + "]";
            }
            case "\\S": {
                return "[^" + Lexer.getWhitespaceRegExp() + "]";
            }
            case "[^]": {
                return "[\\s\\S]";
            }
        }
        return str;
    }

    public static RegExp create(String pattern, String flags) {
        return instance.compile(pattern, flags);
    }

    public static String replace(String token) {
        return instance.replaceToken(token);
    }

    public static void validate(String pattern, String flags) throws ParserException {
        instance.compile(pattern, flags);
    }

    static {
        String impl;
        switch (impl = Options.getStringProperty("nashorn.regexp.impl", JDK)) {
            case "joni": {
                instance = new JoniRegExp.Factory();
                break;
            }
            case "jdk": {
                instance = new RegExpFactory();
                break;
            }
            default: {
                instance = null;
                throw new InternalError("Unsupported RegExp factory: " + impl);
            }
        }
    }
}

