/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.dynalink.beans;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import jdk.internal.dynalink.beans.SandboxClassLoader;
import jdk.internal.dynalink.beans.sandbox.Unreflector;

final class SafeUnreflector {
    private static final String UNREFLECTOR_IMPL_CLASS_NAME = "jdk.internal.dynalink.beans.SafeUnreflectorImpl";
    private static final Unreflector impl = SafeUnreflector.createImpl();

    private SafeUnreflector() {
    }

    static MethodHandle unreflect(Method m) {
        return impl.unreflect(m);
    }

    static MethodHandle unreflectGetter(Field f) {
        return impl.unreflectGetter(f);
    }

    static MethodHandle unreflectSetter(Field f) {
        return impl.unreflectSetter(f);
    }

    static MethodHandle unreflectConstructor(Constructor<?> c) {
        return impl.unreflectConstructor(c);
    }

    private static Unreflector createImpl() {
        Class unreflectorImplClass = (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                return SandboxClassLoader.loadClass(SafeUnreflector.UNREFLECTOR_IMPL_CLASS_NAME);
            }
        });
        try {
            return (Unreflector)unreflectorImplClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

