/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.api.scripting;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.NashornException;
import jdk.nashorn.api.scripting.NashornScriptEngineFactory;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import jdk.nashorn.api.scripting.URLReader;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.GlobalObject;
import jdk.nashorn.internal.runtime.Property;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.Source;
import jdk.nashorn.internal.runtime.linker.JavaAdapterFactory;
import jdk.nashorn.internal.runtime.options.Options;

public final class NashornScriptEngine
extends AbstractScriptEngine
implements Compilable,
Invocable {
    private final ScriptEngineFactory factory;
    private final Context nashornContext;
    private final ScriptObject global;
    private Property contextProperty;
    private static final String[] DEFAULT_OPTIONS = new String[]{"-scripting", "-doe"};

    NashornScriptEngine(NashornScriptEngineFactory factory, ClassLoader appLoader) {
        this(factory, DEFAULT_OPTIONS, appLoader);
    }

    NashornScriptEngine(NashornScriptEngineFactory factory, String[] args, final ClassLoader appLoader) {
        this.factory = factory;
        final Options options = new Options("nashorn");
        options.process(args);
        final Context.ThrowErrorManager errMgr = new Context.ThrowErrorManager();
        this.nashornContext = AccessController.doPrivileged(new PrivilegedAction<Context>(){

            @Override
            public Context run() {
                try {
                    return new Context(options, errMgr, appLoader);
                }
                catch (RuntimeException e) {
                    if (Context.DEBUG) {
                        e.printStackTrace();
                    }
                    throw e;
                }
            }
        });
        this.global = this.createNashornGlobal();
        this.context.setBindings(new ScriptObjectMirror(this.global, this.global), 100);
        try {
            this.evalEngineScript();
        }
        catch (ScriptException e) {
            if (Context.DEBUG) {
                e.printStackTrace();
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object eval(Reader reader, ScriptContext ctxt) throws ScriptException {
        try {
            if (reader instanceof URLReader) {
                URL url = ((URLReader)reader).getURL();
                Charset cs = ((URLReader)reader).getCharset();
                return this.evalImpl(this.compileImpl(new Source(url.toString(), url, cs), ctxt), ctxt);
            }
            return this.evalImpl(Source.readFully(reader), ctxt);
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public Object eval(String script, ScriptContext ctxt) throws ScriptException {
        return this.evalImpl(script.toCharArray(), ctxt);
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    @Override
    public Bindings createBindings() {
        ScriptObject newGlobal = this.createNashornGlobal();
        return new ScriptObjectMirror(newGlobal, newGlobal);
    }

    @Override
    public CompiledScript compile(Reader reader) throws ScriptException {
        try {
            return this.asCompiledScript(this.compileImpl(Source.readFully(reader), this.context));
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public CompiledScript compile(String str) throws ScriptException {
        return this.asCompiledScript(this.compileImpl(str.toCharArray(), this.context));
    }

    @Override
    public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        return this.invokeImpl(null, name, args);
    }

    @Override
    public Object invokeMethod(Object self, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        if (self == null) {
            throw new IllegalArgumentException("script object can not be null");
        }
        return this.invokeImpl(self, name, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T getInterfaceInner(Object self, Class<T> clazz) {
        ScriptObject ctxtGlobal = this.getNashornGlobalFrom(this.context);
        ScriptObject realSelf = self == null ? ctxtGlobal : (!(self instanceof ScriptObject) ? (ScriptObject)ScriptObjectMirror.unwrap(self, ctxtGlobal) : (ScriptObject)self);
        try {
            ScriptObject oldGlobal = NashornScriptEngine.getNashornGlobal();
            try {
                if (oldGlobal != ctxtGlobal) {
                    NashornScriptEngine.setNashornGlobal(ctxtGlobal);
                }
                if (!NashornScriptEngine.isInterfaceImplemented(clazz, realSelf)) {
                    T t = null;
                    return t;
                }
                T t = clazz.cast(JavaAdapterFactory.getConstructor(realSelf.getClass(), clazz).invoke(realSelf));
                return t;
            }
            finally {
                if (oldGlobal != ctxtGlobal) {
                    NashornScriptEngine.setNashornGlobal(oldGlobal);
                }
            }
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public <T> T getInterface(Class<T> clazz) {
        return this.getInterfaceInner(null, clazz);
    }

    @Override
    public <T> T getInterface(Object self, Class<T> clazz) {
        if (self == null) {
            throw new IllegalArgumentException("script object can not be null");
        }
        return this.getInterfaceInner(self, clazz);
    }

    public Object __noSuchProperty__(Object self, ScriptContext ctxt, String name) {
        int scope = ctxt.getAttributesScope(name);
        ScriptObject ctxtGlobal = this.getNashornGlobalFrom(ctxt);
        if (scope != -1) {
            return ScriptObjectMirror.unwrap(ctxt.getAttribute(name, scope), ctxtGlobal);
        }
        if (self == ScriptRuntime.UNDEFINED) {
            throw ECMAErrors.referenceError(ctxtGlobal, "not.defined", name);
        }
        return ScriptRuntime.UNDEFINED;
    }

    private ScriptObject getNashornGlobalFrom(ScriptContext ctxt) {
        ScriptObject sobj;
        Bindings bindings = ctxt.getBindings(100);
        if (bindings instanceof ScriptObjectMirror && (sobj = ((ScriptObjectMirror)bindings).getScriptObject()) instanceof GlobalObject) {
            return sobj;
        }
        return this.global;
    }

    private ScriptObject createNashornGlobal() {
        ScriptObject newGlobal = AccessController.doPrivileged(new PrivilegedAction<ScriptObject>(){

            @Override
            public ScriptObject run() {
                try {
                    return NashornScriptEngine.this.nashornContext.newGlobal();
                }
                catch (RuntimeException e) {
                    if (Context.DEBUG) {
                        e.printStackTrace();
                    }
                    throw e;
                }
            }
        });
        this.nashornContext.initGlobal(newGlobal);
        int NON_ENUMERABLE_CONSTANT = 7;
        this.contextProperty = newGlobal.addOwnProperty("context", 7, ScriptRuntime.UNDEFINED);
        newGlobal.addOwnProperty("engine", 7, this);
        newGlobal.addOwnProperty("arguments", 2, ScriptRuntime.UNDEFINED);
        newGlobal.addOwnProperty("javax.script.filename", 2, null);
        return newGlobal;
    }

    private void evalEngineScript() throws ScriptException {
        this.evalSupportScript("resources/engine.js", "nashorn:engine/resources/engine.js");
    }

    private void evalSupportScript(final String script, String name) throws ScriptException {
        try {
            InputStream is = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws Exception {
                    URL url = NashornScriptEngine.class.getResource(script);
                    return url.openStream();
                }
            });
            this.put("javax.script.filename", name);
            try (InputStreamReader isr = new InputStreamReader(is);){
                this.eval(isr);
            }
        }
        catch (IOException | PrivilegedActionException e) {
            throw new ScriptException(e);
        }
        finally {
            this.put("javax.script.filename", null);
        }
    }

    private void setContextVariables(ScriptContext ctxt) {
        ScriptObject ctxtGlobal = this.getNashornGlobalFrom(ctxt);
        this.contextProperty.setObjectValue(ctxtGlobal, ctxtGlobal, ctxt, false);
        Object args = ScriptObjectMirror.unwrap(ctxt.getAttribute("arguments"), ctxtGlobal);
        if (args == null || args == ScriptRuntime.UNDEFINED) {
            args = ScriptRuntime.EMPTY_ARRAY;
        }
        args = ((GlobalObject)((Object)ctxtGlobal)).wrapAsObject(args);
        ctxtGlobal.set((Object)"arguments", args, false);
    }

    private Object invokeImpl(Object selfObject, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        ScriptObject ctxtGlobal;
        ScriptObject oldGlobal = NashornScriptEngine.getNashornGlobal();
        boolean globalChanged = oldGlobal != (ctxtGlobal = this.getNashornGlobalFrom(this.context));
        Object self = globalChanged ? ScriptObjectMirror.wrap(selfObject, oldGlobal) : selfObject;
        try {
            if (globalChanged) {
                NashornScriptEngine.setNashornGlobal(ctxtGlobal);
            }
            Object value = null;
            if ((self = ScriptObjectMirror.unwrap(self, ctxtGlobal)) instanceof ScriptObject) {
                ScriptObject sobj = (ScriptObject)self;
                value = sobj.get(name);
            } else if (self == null) {
                self = ctxtGlobal;
                ScriptObject sobj = ctxtGlobal;
                value = sobj.get(name);
            }
            if (value instanceof ScriptFunction) {
                Object res;
                try {
                    Object[] modArgs = globalChanged ? ScriptObjectMirror.wrapArray(args, oldGlobal) : args;
                    res = ScriptRuntime.checkAndApply((ScriptFunction)value, self, ScriptObjectMirror.unwrapArray(modArgs, ctxtGlobal));
                }
                catch (Exception e) {
                    NashornScriptEngine.throwAsScriptException(e);
                    throw new AssertionError((Object)"should not reach here");
                }
                Object object = ScriptObjectMirror.translateUndefined(ScriptObjectMirror.wrap(res, ctxtGlobal));
                return object;
            }
            throw new NoSuchMethodException(name);
        }
        finally {
            if (globalChanged) {
                NashornScriptEngine.setNashornGlobal(oldGlobal);
            }
        }
    }

    private Object evalImpl(char[] buf, ScriptContext ctxt) throws ScriptException {
        return this.evalImpl(this.compileImpl(buf, ctxt), ctxt);
    }

    private Object evalImpl(ScriptFunction script, ScriptContext ctxt) throws ScriptException {
        ScriptObject ctxtGlobal;
        if (script == null) {
            return null;
        }
        ScriptObject oldGlobal = NashornScriptEngine.getNashornGlobal();
        boolean globalChanged = oldGlobal != (ctxtGlobal = this.getNashornGlobalFrom(ctxt));
        try {
            if (globalChanged) {
                NashornScriptEngine.setNashornGlobal(ctxtGlobal);
            }
            this.setContextVariables(ctxt);
            Object object = ScriptObjectMirror.translateUndefined(ScriptObjectMirror.wrap(ScriptRuntime.apply(script, ctxtGlobal, new Object[0]), ctxtGlobal));
            return object;
        }
        catch (Exception e) {
            NashornScriptEngine.throwAsScriptException(e);
            throw new AssertionError((Object)"should not reach here");
        }
        finally {
            if (globalChanged) {
                NashornScriptEngine.setNashornGlobal(oldGlobal);
            }
        }
    }

    private static void throwAsScriptException(Exception e) throws ScriptException {
        if (e instanceof ScriptException) {
            throw (ScriptException)e;
        }
        if (e instanceof NashornException) {
            NashornException ne = (NashornException)e;
            ScriptException se = new ScriptException(ne.getMessage(), ne.getFileName(), ne.getLineNumber(), ne.getColumnNumber());
            se.initCause(e);
            throw se;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new ScriptException(e);
    }

    private CompiledScript asCompiledScript(final ScriptFunction script) {
        return new CompiledScript(){

            @Override
            public Object eval(ScriptContext ctxt) throws ScriptException {
                return NashornScriptEngine.this.evalImpl(script, ctxt);
            }

            @Override
            public ScriptEngine getEngine() {
                return NashornScriptEngine.this;
            }
        };
    }

    private ScriptFunction compileImpl(char[] buf, ScriptContext ctxt) throws ScriptException {
        Object val = ctxt.getAttribute("javax.script.filename");
        String fileName = val != null ? val.toString() : "<eval>";
        return this.compileImpl(new Source(fileName, buf), ctxt);
    }

    private ScriptFunction compileImpl(Source source, ScriptContext ctxt) throws ScriptException {
        ScriptObject ctxtGlobal;
        ScriptObject oldGlobal = NashornScriptEngine.getNashornGlobal();
        boolean globalChanged = oldGlobal != (ctxtGlobal = this.getNashornGlobalFrom(ctxt));
        try {
            if (globalChanged) {
                NashornScriptEngine.setNashornGlobal(ctxtGlobal);
            }
            ScriptFunction scriptFunction = this.nashornContext.compileScript(source, ctxtGlobal);
            return scriptFunction;
        }
        catch (Exception e) {
            NashornScriptEngine.throwAsScriptException(e);
            throw new AssertionError((Object)"should not reach here");
        }
        finally {
            if (globalChanged) {
                NashornScriptEngine.setNashornGlobal(oldGlobal);
            }
        }
    }

    private static boolean isInterfaceImplemented(Class<?> iface, ScriptObject sobj) {
        for (Method method : iface.getMethods()) {
            Object obj;
            if (method.getDeclaringClass() == Object.class || (obj = sobj.get(method.getName())) instanceof ScriptFunction) continue;
            return false;
        }
        return true;
    }

    static ScriptObject getNashornGlobal() {
        return Context.getGlobal();
    }

    static void setNashornGlobal(final ScriptObject newGlobal) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Context.setGlobal(newGlobal);
                return null;
            }
        });
    }
}

