/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import java.util.Iterator;
import java.util.List;
import jdk.nashorn.internal.codegen.CodeGenerator;
import jdk.nashorn.internal.codegen.Compiler;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.MethodEmitter;
import jdk.nashorn.internal.codegen.ObjectClassGenerator;
import jdk.nashorn.internal.codegen.ObjectCreator;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.arrays.ArrayIndex;

public abstract class FieldObjectCreator<T>
extends ObjectCreator {
    private String fieldObjectClassName;
    private Class<?> fieldObjectClass;
    private int fieldCount;
    private int paddedFieldCount;
    private int paramCount;
    private final List<T> values;
    private final int callSiteFlags;

    FieldObjectCreator(CodeGenerator codegen, List<String> keys, List<Symbol> symbols, List<T> values) {
        this(codegen, keys, symbols, values, false, false);
    }

    FieldObjectCreator(CodeGenerator codegen, List<String> keys, List<Symbol> symbols, List<T> values, boolean isScope, boolean hasArguments) {
        super(codegen, keys, symbols, isScope, hasArguments);
        this.values = values;
        this.callSiteFlags = codegen.getCallSiteFlags();
        this.countFields();
        this.findClass();
    }

    @Override
    protected void makeObject(MethodEmitter method) {
        this.makeMap();
        method._new(this.getClassName()).dup();
        this.loadMap(method);
        if (this.isScope()) {
            this.loadScope(method);
            if (this.hasArguments()) {
                method.loadCompilerConstant(CompilerConstants.ARGUMENTS);
                method.invoke(CompilerConstants.constructorNoLookup(this.getClassName(), PropertyMap.class, ScriptObject.class, CompilerConstants.ARGUMENTS.type()));
            } else {
                method.invoke(CompilerConstants.constructorNoLookup(this.getClassName(), PropertyMap.class, ScriptObject.class));
            }
        } else {
            method.invoke(CompilerConstants.constructorNoLookup(this.getClassName(), PropertyMap.class));
        }
        Iterator symbolIter = this.symbols.iterator();
        Iterator keyIter = this.keys.iterator();
        Iterator<T> valueIter = this.values.iterator();
        while (symbolIter.hasNext()) {
            Symbol symbol = (Symbol)symbolIter.next();
            String key = (String)keyIter.next();
            T value = valueIter.next();
            if (symbol == null || value == null) continue;
            int index = ArrayIndex.getArrayIndex(key);
            if (index < 0) {
                this.putField(method, key, symbol.getFieldIndex(), value);
                continue;
            }
            this.putSlot(method, index, value);
        }
    }

    @Override
    protected PropertyMap makeMap() {
        assert (this.propertyMap == null) : "property map already initialized";
        this.propertyMap = this.newMapCreator(this.fieldObjectClass).makeFieldMap(this.hasArguments(), this.fieldCount, this.paddedFieldCount);
        return this.propertyMap;
    }

    protected abstract void loadValue(T var1);

    private void putField(MethodEmitter method, String key, int fieldIndex, T value) {
        method.dup();
        this.loadValue(value);
        method.convert(Type.OBJECT);
        method.putField(this.getClassName(), ObjectClassGenerator.getFieldName(fieldIndex, Type.OBJECT), CompilerConstants.typeDescriptor(Object.class));
    }

    private void putSlot(MethodEmitter method, int index, T value) {
        method.dup();
        method.load(index);
        this.loadValue(value);
        method.dynamicSetIndex(this.callSiteFlags);
    }

    private void findClass() {
        this.fieldObjectClassName = this.isScope() ? ObjectClassGenerator.getClassName(this.fieldCount, this.paramCount) : ObjectClassGenerator.getClassName(this.paddedFieldCount);
        try {
            this.fieldObjectClass = Context.forStructureClass(Compiler.binaryName(this.fieldObjectClassName));
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)"Nashorn has encountered an internal error.  Structure can not be created.");
        }
    }

    String getClassName() {
        return this.fieldObjectClassName;
    }

    private void countFields() {
        for (Symbol symbol : this.symbols) {
            if (symbol == null) continue;
            if (this.hasArguments() && symbol.isParam()) {
                symbol.setFieldIndex(this.paramCount++);
                continue;
            }
            symbol.setFieldIndex(this.fieldCount++);
        }
        this.paddedFieldCount = ObjectClassGenerator.getPaddedFieldCount(this.fieldCount);
    }
}

