/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.ir.BaseNode;
import jdk.nashorn.internal.ir.BinaryNode;
import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.BlockLexicalContext;
import jdk.nashorn.internal.ir.BreakNode;
import jdk.nashorn.internal.ir.CallNode;
import jdk.nashorn.internal.ir.CatchNode;
import jdk.nashorn.internal.ir.ContinueNode;
import jdk.nashorn.internal.ir.EmptyNode;
import jdk.nashorn.internal.ir.ExecuteNode;
import jdk.nashorn.internal.ir.ForNode;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.IdentNode;
import jdk.nashorn.internal.ir.IfNode;
import jdk.nashorn.internal.ir.LabelNode;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.LiteralNode;
import jdk.nashorn.internal.ir.LoopNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.ReturnNode;
import jdk.nashorn.internal.ir.Statement;
import jdk.nashorn.internal.ir.SwitchNode;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.ir.ThrowNode;
import jdk.nashorn.internal.ir.TryNode;
import jdk.nashorn.internal.ir.VarNode;
import jdk.nashorn.internal.ir.WhileNode;
import jdk.nashorn.internal.ir.WithNode;
import jdk.nashorn.internal.ir.visitor.NodeOperatorVisitor;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.parser.Token;
import jdk.nashorn.internal.parser.TokenType;
import jdk.nashorn.internal.runtime.DebugLogger;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.Source;

final class Lower
extends NodeOperatorVisitor<BlockLexicalContext> {
    private static final DebugLogger LOG = new DebugLogger("lower");

    Lower() {
        super(new BlockLexicalContext(){

            @Override
            public List<Statement> popStatements() {
                final ArrayList<Statement> newStatements = new ArrayList<Statement>();
                boolean terminated = false;
                List<Statement> statements = super.popStatements();
                for (Statement statement : statements) {
                    if (!terminated) {
                        newStatements.add(statement);
                        if (!statement.isTerminal() && !(statement instanceof BreakNode) && !(statement instanceof ContinueNode)) continue;
                        terminated = true;
                        continue;
                    }
                    statement.accept((NodeVisitor<? extends LexicalContext>)new NodeVisitor<LexicalContext>(new LexicalContext()){

                        @Override
                        public boolean enterVarNode(VarNode varNode) {
                            newStatements.add(varNode.setInit(null));
                            return false;
                        }
                    });
                }
                return newStatements;
            }

            @Override
            protected Block afterSetStatements(Block block) {
                List<Statement> stmts = block.getStatements();
                ListIterator<Statement> li = stmts.listIterator(stmts.size());
                while (li.hasPrevious()) {
                    Statement stmt = li.previous();
                    if (stmt instanceof VarNode && ((VarNode)stmt).getInit() == null) continue;
                    return block.setIsTerminal(this, stmt.isTerminal());
                }
                return block.setIsTerminal(this, false);
            }
        });
    }

    @Override
    public boolean enterBlock(Block block) {
        FunctionNode function = ((BlockLexicalContext)this.lc).getCurrentFunction();
        if (((BlockLexicalContext)this.lc).isFunctionBody() && function.isProgram() && !function.hasDeclaredFunctions()) {
            new ExecuteNode(block.getLineNumber(), block.getToken(), block.getFinish(), LiteralNode.newInstance((Node)block, ScriptRuntime.UNDEFINED)).accept(this);
        }
        return true;
    }

    @Override
    public Node leaveBlock(Block block) {
        if (((BlockLexicalContext)this.lc).isFunctionBody()) {
            FunctionNode currentFunction = ((BlockLexicalContext)this.lc).getCurrentFunction();
            boolean isProgram = currentFunction.isProgram();
            Statement last = ((BlockLexicalContext)this.lc).getLastStatement();
            ReturnNode returnNode = new ReturnNode(last == null ? block.getLineNumber() : last.getLineNumber(), currentFunction.getToken(), currentFunction.getFinish(), isProgram ? this.compilerConstant(CompilerConstants.RETURN) : LiteralNode.newInstance((Node)block, ScriptRuntime.UNDEFINED));
            returnNode.accept(this);
        }
        return block;
    }

    @Override
    public boolean enterBreakNode(BreakNode breakNode) {
        this.addStatement(breakNode);
        return false;
    }

    @Override
    public Node leaveCallNode(CallNode callNode) {
        return this.checkEval(callNode.setFunction(Lower.markerFunction(callNode.getFunction())));
    }

    @Override
    public Node leaveCatchNode(CatchNode catchNode) {
        return this.addStatement(catchNode);
    }

    @Override
    public boolean enterContinueNode(ContinueNode continueNode) {
        this.addStatement(continueNode);
        return false;
    }

    @Override
    public boolean enterEmptyNode(EmptyNode emptyNode) {
        return false;
    }

    @Override
    public Node leaveExecuteNode(ExecuteNode executeNode) {
        Node expr = executeNode.getExpression();
        ExecuteNode node = executeNode;
        FunctionNode currentFunction = ((BlockLexicalContext)this.lc).getCurrentFunction();
        if (!(!currentFunction.isProgram() || expr instanceof Block && !(expr instanceof FunctionNode) || Lower.isInternalExpression(expr) || Lower.isEvalResultAssignment(expr))) {
            node = executeNode.setExpression(new BinaryNode(Token.recast(executeNode.getToken(), TokenType.ASSIGN), (Node)this.compilerConstant(CompilerConstants.RETURN), expr));
        }
        return this.addStatement(node);
    }

    @Override
    public Node leaveForNode(ForNode forNode) {
        ForNode newForNode = forNode;
        Node test = forNode.getTest();
        if (!forNode.isForIn() && Lower.conservativeAlwaysTrue(test)) {
            newForNode = forNode.setTest(this.lc, null);
        }
        return this.addStatement(this.checkEscape(newForNode));
    }

    @Override
    public boolean enterFunctionNode(FunctionNode functionNode) {
        return !functionNode.isLazy();
    }

    @Override
    public Node leaveFunctionNode(FunctionNode functionNode) {
        LOG.info("END FunctionNode: ", functionNode.getName());
        return functionNode.setState(this.lc, FunctionNode.CompilationState.LOWERED);
    }

    @Override
    public Node leaveIfNode(IfNode ifNode) {
        return this.addStatement(ifNode);
    }

    @Override
    public Node leaveLabelNode(LabelNode labelNode) {
        return this.addStatement(labelNode);
    }

    @Override
    public Node leaveReturnNode(ReturnNode returnNode) {
        this.addStatement(returnNode);
        return returnNode;
    }

    @Override
    public Node leaveSwitchNode(SwitchNode switchNode) {
        return this.addStatement(switchNode);
    }

    @Override
    public Node leaveThrowNode(ThrowNode throwNode) {
        this.addStatement(throwNode);
        return throwNode;
    }

    private static Node ensureUniqueNamesIn(Node node) {
        return node.accept((NodeVisitor<? extends LexicalContext>)new NodeVisitor<LexicalContext>(new LexicalContext()){

            @Override
            public Node leaveFunctionNode(FunctionNode functionNode) {
                String name = functionNode.getName();
                return functionNode.setName(this.lc, this.lc.getCurrentFunction().uniqueName(name));
            }

            @Override
            public Node leaveDefault(Node labelledNode) {
                return labelledNode.ensureUniqueLabels(this.lc);
            }
        });
    }

    private static List<Statement> copyFinally(Block finallyBody) {
        ArrayList<Statement> newStatements = new ArrayList<Statement>();
        for (Statement statement : finallyBody.getStatements()) {
            newStatements.add((Statement)Lower.ensureUniqueNamesIn(statement));
            if (!statement.hasTerminalFlags()) continue;
            return newStatements;
        }
        return newStatements;
    }

    private Block catchAllBlock(TryNode tryNode) {
        int lineNumber = tryNode.getLineNumber();
        long token = tryNode.getToken();
        int finish = tryNode.getFinish();
        IdentNode exception = new IdentNode(token, finish, ((BlockLexicalContext)this.lc).getCurrentFunction().uniqueName("catch_all"));
        Block catchBody = new Block(lineNumber, token, finish, new ThrowNode(lineNumber, token, finish, new IdentNode(exception), 1)).setIsTerminal(this.lc, true);
        CatchNode catchAllNode = new CatchNode(lineNumber, token, finish, new IdentNode(exception), null, catchBody, 1);
        Block catchAllBlock = new Block(lineNumber, token, finish, catchAllNode);
        return (Block)catchAllBlock.accept(this);
    }

    private IdentNode compilerConstant(CompilerConstants cc) {
        FunctionNode functionNode = ((BlockLexicalContext)this.lc).getCurrentFunction();
        return new IdentNode(functionNode.getToken(), functionNode.getFinish(), cc.symbolName());
    }

    private static boolean isTerminal(List<Statement> statements) {
        return !statements.isEmpty() && statements.get(statements.size() - 1).hasTerminalFlags();
    }

    private Node spliceFinally(TryNode tryNode, final List<ThrowNode> rethrows, final Block finallyBody) {
        assert (tryNode.getFinallyBody() == null);
        final int finish = tryNode.getFinish();
        TryNode newTryNode = (TryNode)tryNode.accept((NodeVisitor<? extends LexicalContext>)new NodeVisitor<LexicalContext>(new LexicalContext()){
            final List<Node> insideTry;
            {
                super(lc);
                this.insideTry = new ArrayList<Node>();
            }

            @Override
            public boolean enterDefault(Node node) {
                this.insideTry.add(node);
                return true;
            }

            @Override
            public boolean enterFunctionNode(FunctionNode functionNode) {
                return false;
            }

            @Override
            public Node leaveThrowNode(ThrowNode throwNode) {
                if (rethrows.contains(throwNode)) {
                    List newStatements = Lower.copyFinally(finallyBody);
                    if (!Lower.isTerminal(newStatements)) {
                        newStatements.add(throwNode);
                    }
                    return new Block(throwNode.getLineNumber(), throwNode.getToken(), throwNode.getFinish(), newStatements);
                }
                return throwNode;
            }

            @Override
            public Node leaveBreakNode(BreakNode breakNode) {
                return this.copy(breakNode, ((BlockLexicalContext)Lower.this.lc).getBreakable(breakNode.getLabel()));
            }

            @Override
            public Node leaveContinueNode(ContinueNode continueNode) {
                return this.copy(continueNode, ((BlockLexicalContext)Lower.this.lc).getContinueTo(continueNode.getLabel()));
            }

            @Override
            public Node leaveReturnNode(ReturnNode returnNode) {
                IdentNode resultNode;
                Node expr = returnNode.getExpression();
                ArrayList<Statement> newStatements = new ArrayList<Statement>();
                if (expr != null) {
                    resultNode = new IdentNode(Lower.this.compilerConstant(CompilerConstants.RETURN));
                    newStatements.add(new ExecuteNode(returnNode.getLineNumber(), returnNode.getToken(), returnNode.getFinish(), new BinaryNode(Token.recast(returnNode.getToken(), TokenType.ASSIGN), (Node)resultNode, expr)));
                } else {
                    resultNode = null;
                }
                newStatements.addAll(Lower.copyFinally(finallyBody));
                if (!Lower.isTerminal(newStatements)) {
                    newStatements.add(expr == null ? returnNode : returnNode.setExpression(resultNode));
                }
                return new ExecuteNode(returnNode.getLineNumber(), returnNode.getToken(), returnNode.getFinish(), new Block(returnNode.getLineNumber(), returnNode.getToken(), this.lc.getCurrentBlock().getFinish(), newStatements));
            }

            private Node copy(Statement endpoint, Node targetNode) {
                if (!this.insideTry.contains(targetNode)) {
                    List newStatements = Lower.copyFinally(finallyBody);
                    if (!Lower.isTerminal(newStatements)) {
                        newStatements.add(endpoint);
                    }
                    return new ExecuteNode(endpoint.getLineNumber(), endpoint.getToken(), endpoint.getFinish(), new Block(endpoint.getLineNumber(), endpoint.getToken(), finish, newStatements));
                }
                return endpoint;
            }
        });
        this.addStatement(newTryNode);
        for (Node node : finallyBody.getStatements()) {
            this.addStatement((Statement)node);
        }
        return newTryNode;
    }

    @Override
    public Node leaveTryNode(TryNode tryNode) {
        TryNode newTryNode;
        Block finallyBody = tryNode.getFinallyBody();
        if (finallyBody == null) {
            return this.addStatement(tryNode);
        }
        Block catchAll = this.catchAllBlock(tryNode);
        final ArrayList<ThrowNode> rethrows = new ArrayList<ThrowNode>();
        catchAll.accept((NodeVisitor<? extends LexicalContext>)new NodeVisitor<LexicalContext>(new LexicalContext()){

            @Override
            public boolean enterThrowNode(ThrowNode throwNode) {
                rethrows.add(throwNode);
                return true;
            }
        });
        assert (rethrows.size() == 1);
        if (tryNode.getCatchBlocks().isEmpty()) {
            newTryNode = tryNode.setFinallyBody(null);
        } else {
            Block outerBody = new Block(tryNode.getLineNumber(), tryNode.getToken(), tryNode.getFinish(), new ArrayList<Statement>(Arrays.asList(tryNode.setFinallyBody(null))));
            newTryNode = tryNode.setBody(outerBody).setCatchBlocks(null);
        }
        newTryNode = newTryNode.setCatchBlocks(Arrays.asList(catchAll)).setFinallyBody(null);
        return this.spliceFinally(newTryNode, rethrows, finallyBody);
    }

    @Override
    public Node leaveVarNode(VarNode varNode) {
        this.addStatement(varNode);
        if (varNode.getFlag(2) && ((BlockLexicalContext)this.lc).getCurrentFunction().isProgram()) {
            new ExecuteNode(varNode.getLineNumber(), varNode.getToken(), varNode.getFinish(), new IdentNode(varNode.getName())).accept(this);
        }
        return varNode;
    }

    @Override
    public Node leaveWhileNode(WhileNode whileNode) {
        Node test = whileNode.getTest();
        Block body = whileNode.getBody();
        if (Lower.conservativeAlwaysTrue(test)) {
            ForNode forNode = (ForNode)new ForNode(whileNode.getLineNumber(), whileNode.getToken(), whileNode.getFinish(), null, null, body, null, 1).accept(this);
            ((BlockLexicalContext)this.lc).replace(whileNode, forNode);
            return forNode;
        }
        return this.addStatement(this.checkEscape(whileNode));
    }

    @Override
    public Node leaveWithNode(WithNode withNode) {
        return this.addStatement(withNode);
    }

    private static Node markerFunction(Node function) {
        if (function instanceof IdentNode) {
            return ((IdentNode)function).setIsFunction();
        }
        if (function instanceof BaseNode) {
            return ((BaseNode)function).setIsFunction();
        }
        return function;
    }

    private String evalLocation(IdentNode node) {
        Source source = ((BlockLexicalContext)this.lc).getCurrentFunction().getSource();
        return source.getName() + '#' + source.getLine(node.position()) + "<eval>";
    }

    private CallNode checkEval(CallNode callNode) {
        if (callNode.getFunction() instanceof IdentNode) {
            List<Node> args = callNode.getArgs();
            IdentNode callee = (IdentNode)callNode.getFunction();
            if (args.size() >= 1 && CompilerConstants.EVAL.symbolName().equals(callee.getName())) {
                FunctionNode currentFunction = ((BlockLexicalContext)this.lc).getCurrentFunction();
                return callNode.setEvalArgs(new CallNode.EvalArgs(Lower.ensureUniqueNamesIn(args.get(0)).accept(this), this.compilerConstant(CompilerConstants.THIS), this.evalLocation(callee), currentFunction.isStrict()));
            }
        }
        return callNode;
    }

    private static boolean conservativeAlwaysTrue(Node node) {
        return node == null || node instanceof LiteralNode && Boolean.TRUE.equals(((LiteralNode)node).getValue());
    }

    private static boolean controlFlowEscapes(final LexicalContext lex, Block loopBody) {
        final ArrayList escapes = new ArrayList();
        loopBody.accept((NodeVisitor<? extends LexicalContext>)new NodeVisitor<LexicalContext>(new LexicalContext()){

            @Override
            public Node leaveBreakNode(BreakNode node) {
                escapes.add(node);
                return node;
            }

            @Override
            public Node leaveContinueNode(ContinueNode node) {
                if (lex.contains(lex.getContinueTo(node.getLabel()))) {
                    escapes.add(node);
                }
                return node;
            }
        });
        return !escapes.isEmpty();
    }

    private LoopNode checkEscape(LoopNode loopNode) {
        boolean escapes = Lower.controlFlowEscapes(this.lc, loopNode.getBody());
        if (escapes) {
            return loopNode.setBody(this.lc, loopNode.getBody().setIsTerminal(this.lc, false)).setControlFlowEscapes(this.lc, escapes);
        }
        return loopNode;
    }

    private Node addStatement(Statement statement) {
        ((BlockLexicalContext)this.lc).appendStatement(statement);
        return statement;
    }

    private static boolean isInternalExpression(Node expression) {
        Symbol symbol = expression.getSymbol();
        return symbol != null && symbol.isInternal();
    }

    private static boolean isEvalResultAssignment(Node expression) {
        Node lhs;
        Node e = expression;
        assert (e.tokenType() != TokenType.DISCARD);
        if (e instanceof BinaryNode && (lhs = ((BinaryNode)e).lhs()) instanceof IdentNode) {
            return ((IdentNode)lhs).getName().equals(CompilerConstants.RETURN.symbolName());
        }
        return false;
    }
}

