/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdk.nashorn.internal.codegen.CompileUnit;
import jdk.nashorn.internal.codegen.Compiler;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.WeighNodes;
import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.LiteralNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.SplitNode;
import jdk.nashorn.internal.ir.Statement;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.runtime.DebugLogger;
import jdk.nashorn.internal.runtime.options.Options;

final class Splitter
extends NodeVisitor<LexicalContext> {
    private final Compiler compiler;
    private final FunctionNode outermost;
    private final CompileUnit outermostCompileUnit;
    private final Map<Node, Long> weightCache = new HashMap<Node, Long>();
    public static final long SPLIT_THRESHOLD = Options.getIntProperty("nashorn.compiler.splitter.threshold", 32768);
    private static final DebugLogger LOG = Compiler.LOG;

    public Splitter(Compiler compiler, FunctionNode functionNode, CompileUnit outermostCompileUnit) {
        super(new LexicalContext());
        this.compiler = compiler;
        this.outermost = functionNode;
        this.outermostCompileUnit = outermostCompileUnit;
    }

    FunctionNode split(FunctionNode fn) {
        FunctionNode functionNode = fn;
        if (functionNode.isLazy()) {
            LOG.finest("Postponing split of '", functionNode.getName(), "' as it's lazy");
            return functionNode;
        }
        LOG.finest("Initiating split of '", functionNode.getName(), "'");
        long weight = WeighNodes.weigh(functionNode);
        boolean top = fn.isProgram();
        if (weight >= SPLIT_THRESHOLD) {
            LOG.finest("Splitting '", functionNode.getName(), "' as its weight ", weight, " exceeds split threshold ", SPLIT_THRESHOLD);
            functionNode = (FunctionNode)functionNode.accept(this);
            if (functionNode.isSplit()) {
                weight = WeighNodes.weigh(functionNode, this.weightCache);
                functionNode = functionNode.setBody(this.lc, functionNode.getBody().setNeedsScope(this.lc));
            }
            if (weight >= SPLIT_THRESHOLD) {
                functionNode = functionNode.setBody(this.lc, this.splitBlock(functionNode.getBody(), functionNode));
                weight = WeighNodes.weigh(functionNode.getBody(), this.weightCache);
            }
        }
        assert (functionNode.getCompileUnit() == null) : "compile unit already set for " + functionNode.getName();
        if (top) {
            assert (this.outermostCompileUnit != null) : "outermost compile unit is null";
            functionNode = functionNode.setCompileUnit(this.lc, this.outermostCompileUnit);
            this.outermostCompileUnit.addWeight(weight + 40L);
        } else {
            functionNode = functionNode.setCompileUnit(this.lc, this.findUnit(weight));
        }
        Block body = functionNode.getBody();
        final List<FunctionNode> dc = Splitter.directChildren(functionNode);
        Block newBody = (Block)body.accept((NodeVisitor<? extends LexicalContext>)new NodeVisitor<LexicalContext>(new LexicalContext()){

            @Override
            public boolean enterFunctionNode(FunctionNode nestedFunction) {
                return dc.contains(nestedFunction);
            }

            @Override
            public Node leaveFunctionNode(FunctionNode nestedFunction) {
                FunctionNode split = new Splitter(Splitter.this.compiler, nestedFunction, Splitter.this.outermostCompileUnit).split(nestedFunction);
                this.lc.replace(nestedFunction, split);
                return split;
            }
        });
        functionNode = functionNode.setBody(this.lc, newBody);
        assert (functionNode.getCompileUnit() != null);
        return functionNode.setState(this.lc, FunctionNode.CompilationState.SPLIT);
    }

    private static List<FunctionNode> directChildren(final FunctionNode functionNode) {
        final ArrayList<FunctionNode> dc = new ArrayList<FunctionNode>();
        functionNode.accept((NodeVisitor<? extends LexicalContext>)new NodeVisitor<LexicalContext>(new LexicalContext()){

            @Override
            public boolean enterFunctionNode(FunctionNode child) {
                if (child == functionNode) {
                    return true;
                }
                if (this.lc.getParentFunction(child) == functionNode) {
                    dc.add(child);
                }
                return false;
            }
        });
        return dc;
    }

    protected CompileUnit findUnit(long weight) {
        return this.compiler.findUnit(weight);
    }

    private Block splitBlock(Block block, FunctionNode function) {
        this.lc.setFlag(this.lc.getCurrentFunction(), 16);
        ArrayList<Statement> splits = new ArrayList<Statement>();
        ArrayList<Statement> statements = new ArrayList<Statement>();
        long statementsWeight = 0L;
        for (Statement statement : block.getStatements()) {
            long weight = WeighNodes.weigh(statement, this.weightCache);
            if ((statementsWeight + weight >= SPLIT_THRESHOLD || statement.isTerminal()) && !statements.isEmpty()) {
                splits.add(this.createBlockSplitNode(block, function, statements, statementsWeight));
                statements = new ArrayList();
                statementsWeight = 0L;
            }
            if (statement.isTerminal()) {
                splits.add(statement);
                continue;
            }
            statements.add(statement);
            statementsWeight += weight;
        }
        if (!statements.isEmpty()) {
            splits.add(this.createBlockSplitNode(block, function, statements, statementsWeight));
        }
        return block.setStatements(this.lc, splits);
    }

    private SplitNode createBlockSplitNode(Block parent, FunctionNode function, List<Statement> statements, long weight) {
        int lineNumber = parent.getLineNumber();
        long token = parent.getToken();
        int finish = parent.getFinish();
        String name = function.uniqueName(CompilerConstants.SPLIT_PREFIX.symbolName());
        Block newBlock = new Block(lineNumber, token, finish, statements);
        return new SplitNode(lineNumber, name, newBlock, this.compiler.findUnit(weight + 40L));
    }

    @Override
    public boolean enterBlock(Block block) {
        if (block.isCatchBlock()) {
            return false;
        }
        long weight = WeighNodes.weigh(block, this.weightCache);
        if (weight < SPLIT_THRESHOLD) {
            this.weightCache.put(block, weight);
            return false;
        }
        return true;
    }

    @Override
    public Node leaveBlock(Block block) {
        assert (!block.isCatchBlock());
        Block newBlock = block;
        long weight = WeighNodes.weigh(block, this.weightCache);
        if (weight >= SPLIT_THRESHOLD) {
            newBlock = this.splitBlock(block, this.lc.getFunction(block));
            weight = WeighNodes.weigh(newBlock, this.weightCache);
        }
        this.weightCache.put(newBlock, weight);
        return newBlock;
    }

    @Override
    public Node leaveLiteralNode(LiteralNode literal) {
        long weight = WeighNodes.weigh(literal);
        if (weight < SPLIT_THRESHOLD) {
            return literal;
        }
        FunctionNode functionNode = this.lc.getCurrentFunction();
        this.lc.setFlag(functionNode, 16);
        if (literal instanceof LiteralNode.ArrayLiteralNode) {
            LiteralNode.ArrayLiteralNode arrayLiteralNode = (LiteralNode.ArrayLiteralNode)literal;
            Node[] value = (Node[])arrayLiteralNode.getValue();
            int[] postsets = arrayLiteralNode.getPostsets();
            ArrayList<LiteralNode.ArrayLiteralNode.ArrayUnit> units = new ArrayList<LiteralNode.ArrayLiteralNode.ArrayUnit>();
            long totalWeight = 0L;
            int lo = 0;
            for (int i = 0; i < postsets.length; ++i) {
                int postset = postsets[i];
                Node element = value[postset];
                weight = WeighNodes.weigh(element);
                if ((totalWeight += weight) < SPLIT_THRESHOLD) continue;
                CompileUnit unit = this.compiler.findUnit(totalWeight - weight);
                units.add(new LiteralNode.ArrayLiteralNode.ArrayUnit(unit, lo, i));
                lo = i;
                totalWeight = weight;
            }
            if (lo != postsets.length) {
                CompileUnit unit = this.compiler.findUnit(totalWeight);
                units.add(new LiteralNode.ArrayLiteralNode.ArrayUnit(unit, lo, postsets.length));
            }
            arrayLiteralNode.setUnits(units);
        }
        return literal;
    }

    @Override
    public boolean enterFunctionNode(FunctionNode node) {
        return node == this.outermost && !node.isLazy();
    }
}

