/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.IdentNode;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.Statement;
import jdk.nashorn.internal.ir.annotations.Immutable;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;

@Immutable
public final class CatchNode
extends Statement {
    private final IdentNode exception;
    private final Node exceptionCondition;
    private final Block body;
    private final int flags;
    public static final int IS_SYNTHETIC_RETHROW = 1;

    public CatchNode(int lineNumber, long token, int finish, IdentNode exception, Node exceptionCondition, Block body, int flags) {
        super(lineNumber, token, finish);
        this.exception = exception;
        this.exceptionCondition = exceptionCondition;
        this.body = body;
        this.flags = flags;
    }

    private CatchNode(CatchNode catchNode, IdentNode exception, Node exceptionCondition, Block body, int flags) {
        super(catchNode);
        this.exception = exception;
        this.exceptionCondition = exceptionCondition;
        this.body = body;
        this.flags = flags;
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterCatchNode(this)) {
            return visitor.leaveCatchNode(this.setException((IdentNode)this.exception.accept(visitor)).setExceptionCondition(this.exceptionCondition == null ? null : this.exceptionCondition.accept(visitor)).setBody((Block)this.body.accept(visitor)));
        }
        return this;
    }

    @Override
    public boolean isTerminal() {
        return this.body.isTerminal();
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(" catch (");
        this.exception.toString(sb);
        if (this.exceptionCondition != null) {
            sb.append(" if ");
            this.exceptionCondition.toString(sb);
        }
        sb.append(')');
    }

    public IdentNode getException() {
        return this.exception;
    }

    public Node getExceptionCondition() {
        return this.exceptionCondition;
    }

    public CatchNode setExceptionCondition(Node exceptionCondition) {
        if (this.exceptionCondition == exceptionCondition) {
            return this;
        }
        return new CatchNode(this, this.exception, exceptionCondition, this.body, this.flags);
    }

    public Block getBody() {
        return this.body;
    }

    public CatchNode setException(IdentNode exception) {
        if (this.exception == exception) {
            return this;
        }
        return new CatchNode(this, exception, this.exceptionCondition, this.body, this.flags);
    }

    private CatchNode setBody(Block body) {
        if (this.body == body) {
            return this;
        }
        return new CatchNode(this, this.exception, this.exceptionCondition, body, this.flags);
    }

    public boolean isSyntheticRethrow() {
        return (this.flags & 1) == 1;
    }
}

