/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.Statement;
import jdk.nashorn.internal.ir.annotations.Immutable;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;

@Immutable
public final class IfNode
extends Statement {
    private final Node test;
    private final Block pass;
    private final Block fail;

    public IfNode(int lineNumber, long token, int finish, Node test, Block pass, Block fail) {
        super(lineNumber, token, finish);
        this.test = test;
        this.pass = pass;
        this.fail = fail;
    }

    private IfNode(IfNode ifNode, Node test, Block pass, Block fail) {
        super(ifNode);
        this.test = test;
        this.pass = pass;
        this.fail = fail;
    }

    @Override
    public boolean isTerminal() {
        return this.pass.isTerminal() && this.fail != null && this.fail.isTerminal();
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterIfNode(this)) {
            return visitor.leaveIfNode(this.setTest(this.test.accept(visitor)).setPass((Block)this.pass.accept(visitor)).setFail(this.fail == null ? null : (Block)this.fail.accept(visitor)));
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append("if (");
        this.test.toString(sb);
        sb.append(')');
    }

    public Block getFail() {
        return this.fail;
    }

    private IfNode setFail(Block fail) {
        if (this.fail == fail) {
            return this;
        }
        return new IfNode(this, this.test, this.pass, fail);
    }

    public Block getPass() {
        return this.pass;
    }

    private IfNode setPass(Block pass) {
        if (this.pass == pass) {
            return this;
        }
        return new IfNode(this, this.test, pass, this.fail);
    }

    public Node getTest() {
        return this.test;
    }

    public IfNode setTest(Node test) {
        if (this.test == test) {
            return this;
        }
        return new IfNode(this, test, this.pass, this.fail);
    }
}

