/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.IdentNode;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.LexicalContextNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.annotations.Immutable;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;

@Immutable
public final class LabelNode
extends LexicalContextNode {
    private final IdentNode label;
    private final Block body;

    public LabelNode(int lineNumber, long token, int finish, IdentNode label, Block body) {
        super(lineNumber, token, finish);
        this.label = label;
        this.body = body;
    }

    private LabelNode(LabelNode labelNode, IdentNode label, Block body) {
        super(labelNode);
        this.label = label;
        this.body = body;
    }

    @Override
    public boolean isTerminal() {
        return this.body.isTerminal();
    }

    @Override
    public Node accept(LexicalContext lc, NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterLabelNode(this)) {
            return visitor.leaveLabelNode(this.setLabel(lc, (IdentNode)this.label.accept(visitor)).setBody(lc, (Block)this.body.accept(visitor)));
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        this.label.toString(sb);
        sb.append(':');
    }

    public Block getBody() {
        return this.body;
    }

    public LabelNode setBody(LexicalContext lc, Block body) {
        if (this.body == body) {
            return this;
        }
        return Node.replaceInLexicalContext(lc, this, new LabelNode(this, this.label, body));
    }

    public IdentNode getLabel() {
        return this.label;
    }

    private LabelNode setLabel(LexicalContext lc, IdentNode label) {
        if (this.label == label) {
            return this;
        }
        return Node.replaceInLexicalContext(lc, this, new LabelNode(this, label, this.body));
    }
}

