/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jdk.nashorn.internal.codegen.CompileUnit;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.PropertyKey;
import jdk.nashorn.internal.ir.UnaryNode;
import jdk.nashorn.internal.ir.annotations.Immutable;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.parser.Lexer;
import jdk.nashorn.internal.parser.Token;
import jdk.nashorn.internal.parser.TokenType;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.Undefined;

@Immutable
public abstract class LiteralNode<T>
extends Node
implements PropertyKey {
    protected final T value;
    public static final Object POSTSET_MARKER = new Object();

    protected LiteralNode(long token, int finish, T value) {
        super(token, finish);
        this.value = value;
    }

    protected LiteralNode(LiteralNode<T> literalNode) {
        this(literalNode, literalNode.value);
    }

    protected LiteralNode(LiteralNode<T> literalNode, T newValue) {
        super(literalNode);
        this.value = newValue;
    }

    @Override
    public boolean isAtom() {
        return true;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean isTrue() {
        return JSType.toBoolean(this.value);
    }

    @Override
    public Type getType() {
        return Type.typeFor(this.value.getClass());
    }

    @Override
    public String getPropertyName() {
        return JSType.toString(this.getObject());
    }

    public boolean getBoolean() {
        return JSType.toBoolean(this.value);
    }

    public int getInt32() {
        return JSType.toInt32(this.value);
    }

    public long getUint32() {
        return JSType.toUint32(this.value);
    }

    public long getLong() {
        return JSType.toLong(this.value);
    }

    public double getNumber() {
        return JSType.toNumber(this.value);
    }

    public Node[] getArray() {
        assert (false) : "not an array node";
        return null;
    }

    public String getString() {
        return JSType.toString(this.value);
    }

    public Object getObject() {
        return this.value;
    }

    public boolean isString() {
        return this.value instanceof String;
    }

    public boolean isNumeric() {
        return this.value instanceof Number;
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterLiteralNode(this)) {
            return visitor.leaveLiteralNode(this);
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        if (this.value == null) {
            sb.append("null");
        } else {
            sb.append(this.value.toString());
        }
    }

    public T getValue() {
        return this.value;
    }

    public static LiteralNode<Object> newInstance(long token, int finish) {
        return new NullLiteralNode(token, finish);
    }

    public static LiteralNode<Object> newInstance(Node parent) {
        return new NullLiteralNode(parent.getToken(), parent.getFinish());
    }

    public static LiteralNode<Boolean> newInstance(long token, int finish, boolean value) {
        return new BooleanLiteralNode(token, finish, value);
    }

    public static LiteralNode<?> newInstance(Node parent, boolean value) {
        return new BooleanLiteralNode(parent.getToken(), parent.getFinish(), value);
    }

    public static LiteralNode<Number> newInstance(long token, int finish, Number value) {
        return new NumberLiteralNode(token, finish, value);
    }

    public static LiteralNode<?> newInstance(Node parent, Number value) {
        return new NumberLiteralNode(parent.getToken(), parent.getFinish(), value);
    }

    public static LiteralNode<Undefined> newInstance(long token, int finish, Undefined value) {
        return new UndefinedLiteralNode(token, finish);
    }

    public static LiteralNode<?> newInstance(Node parent, Undefined value) {
        return new UndefinedLiteralNode(parent.getToken(), parent.getFinish());
    }

    public static LiteralNode<String> newInstance(long token, int finish, String value) {
        return new StringLiteralNode(token, finish, value);
    }

    public static LiteralNode<?> newInstance(Node parent, String value) {
        return new StringLiteralNode(parent.getToken(), parent.getFinish(), value);
    }

    public static LiteralNode<Lexer.LexerToken> newInstance(long token, int finish, Lexer.LexerToken value) {
        return new LexerTokenLiteralNode(token, finish, value);
    }

    public static LiteralNode<?> newInstance(Node parent, Lexer.LexerToken value) {
        return new LexerTokenLiteralNode(parent.getToken(), parent.getFinish(), value);
    }

    public static Object objectAsConstant(Object object) {
        UnaryNode unaryNode;
        if (object == null) {
            return null;
        }
        if (object instanceof Number || object instanceof String || object instanceof Boolean) {
            return object;
        }
        if (object instanceof LiteralNode) {
            return LiteralNode.objectAsConstant(((LiteralNode)object).getValue());
        }
        if (object instanceof UnaryNode && (unaryNode = (UnaryNode)object).isTokenType(TokenType.CONVERT) && unaryNode.getType().isObject()) {
            return LiteralNode.objectAsConstant(unaryNode.rhs());
        }
        return POSTSET_MARKER;
    }

    public static LiteralNode<Node[]> newInstance(long token, int finish, List<Node> value) {
        return new ArrayLiteralNode(token, finish, value.toArray(new Node[value.size()]));
    }

    public static LiteralNode<?> newInstance(Node parent, List<Node> value) {
        return new ArrayLiteralNode(parent.getToken(), parent.getFinish(), value.toArray(new Node[value.size()]));
    }

    public static LiteralNode<Node[]> newInstance(long token, int finish, Node[] value) {
        return new ArrayLiteralNode(token, finish, value);
    }

    public static final class ArrayLiteralNode
    extends LiteralNode<Node[]> {
        private Type elementType;
        private Object presets;
        private int[] postsets;
        private List<ArrayUnit> units;

        protected ArrayLiteralNode(long token, int finish, Node[] value) {
            super(Token.recast(token, TokenType.ARRAY), finish, value);
            this.elementType = Type.UNKNOWN;
        }

        private ArrayLiteralNode(ArrayLiteralNode node, Node[] value) {
            super(node, value);
            this.elementType = node.elementType;
            this.presets = node.presets;
            this.postsets = node.postsets;
            this.units = node.units;
        }

        public void analyze() {
            this.elementType = Type.INT;
            this.analyzeElements();
            if (this.elementType.isInteger()) {
                this.presetIntArray();
            } else if (this.elementType.isLong()) {
                this.presetLongArray();
            } else if (this.elementType.isNumeric()) {
                this.presetNumberArray();
            } else {
                this.presetObjectArray();
            }
        }

        private void presetIntArray() {
            int[] array = new int[((Node[])this.value).length];
            int[] computed = new int[((Node[])this.value).length];
            int nComputed = 0;
            for (int i = 0; i < ((Node[])this.value).length; ++i) {
                Object element = ArrayLiteralNode.objectAsConstant(((Node[])this.value)[i]);
                if (element instanceof Number) {
                    array[i] = ((Number)element).intValue();
                    continue;
                }
                computed[nComputed++] = i;
            }
            this.presets = array;
            this.postsets = Arrays.copyOf(computed, nComputed);
        }

        private void presetLongArray() {
            long[] array = new long[((Node[])this.value).length];
            int[] computed = new int[((Node[])this.value).length];
            int nComputed = 0;
            for (int i = 0; i < ((Node[])this.value).length; ++i) {
                Object element = ArrayLiteralNode.objectAsConstant(((Node[])this.value)[i]);
                if (element instanceof Number) {
                    array[i] = ((Number)element).longValue();
                    continue;
                }
                computed[nComputed++] = i;
            }
            this.presets = array;
            this.postsets = Arrays.copyOf(computed, nComputed);
        }

        private void presetNumberArray() {
            double[] array = new double[((Node[])this.value).length];
            int[] computed = new int[((Node[])this.value).length];
            int nComputed = 0;
            for (int i = 0; i < ((Node[])this.value).length; ++i) {
                Object element = ArrayLiteralNode.objectAsConstant(((Node[])this.value)[i]);
                if (element instanceof Number) {
                    array[i] = ((Number)element).doubleValue();
                    continue;
                }
                computed[nComputed++] = i;
            }
            this.presets = array;
            this.postsets = Arrays.copyOf(computed, nComputed);
        }

        private void presetObjectArray() {
            Object[] array = new Object[((Node[])this.value).length];
            int[] computed = new int[((Node[])this.value).length];
            int nComputed = 0;
            for (int i = 0; i < ((Node[])this.value).length; ++i) {
                Node node = ((Node[])this.value)[i];
                if (node == null) {
                    computed[nComputed++] = i;
                    continue;
                }
                Object element = ArrayLiteralNode.objectAsConstant(node);
                if (element != POSTSET_MARKER) {
                    array[i] = element;
                    continue;
                }
                computed[nComputed++] = i;
            }
            this.presets = array;
            this.postsets = Arrays.copyOf(computed, nComputed);
        }

        private void analyzeElements() {
            for (Node node : (Node[])this.value) {
                if (node == null) {
                    this.elementType = this.elementType.widest(Type.OBJECT);
                    break;
                }
                assert (node.getSymbol() != null);
                Type symbolType = node.getSymbol().getSymbolType();
                if (symbolType.isUnknown()) {
                    symbolType = Type.OBJECT;
                }
                if (symbolType.isBoolean()) {
                    this.elementType = this.elementType.widest(Type.OBJECT);
                    break;
                }
                this.elementType = this.elementType.widest(symbolType);
                if (this.elementType.isObject()) break;
            }
        }

        @Override
        public Node[] getArray() {
            return (Node[])this.value;
        }

        @Override
        public Type getType() {
            if (this.elementType.isInteger()) {
                return Type.INT_ARRAY;
            }
            if (this.elementType.isLong()) {
                return Type.LONG_ARRAY;
            }
            if (this.elementType.isNumeric()) {
                return Type.NUMBER_ARRAY;
            }
            return Type.OBJECT_ARRAY;
        }

        public Type getElementType() {
            return this.elementType;
        }

        public int[] getPostsets() {
            return this.postsets;
        }

        public Object getPresets() {
            return this.presets;
        }

        public List<ArrayUnit> getUnits() {
            return this.units == null ? null : Collections.unmodifiableList(this.units);
        }

        public void setUnits(List<ArrayUnit> units) {
            this.units = units;
        }

        @Override
        public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
            if (visitor.enterLiteralNode(this)) {
                List<Object> newValue;
                List<Object> oldValue = Arrays.asList((Object[])this.value);
                return visitor.leaveLiteralNode(oldValue != (newValue = Node.accept(visitor, Node.class, oldValue)) ? this.setValue(newValue) : this);
            }
            return this;
        }

        private ArrayLiteralNode setValue(List<Node> value) {
            return new ArrayLiteralNode(this, value.toArray(new Node[value.size()]));
        }

        @Override
        public void toString(StringBuilder sb) {
            sb.append('[');
            boolean first = true;
            for (Node node : (Node[])this.value) {
                if (!first) {
                    sb.append(',');
                    sb.append(' ');
                }
                if (node == null) {
                    sb.append("undefined");
                } else {
                    node.toString(sb);
                }
                first = false;
            }
            sb.append(']');
        }

        public static class ArrayUnit {
            private final CompileUnit compileUnit;
            private final int lo;
            private final int hi;

            public ArrayUnit(CompileUnit compileUnit, int lo, int hi) {
                this.compileUnit = compileUnit;
                this.lo = lo;
                this.hi = hi;
            }

            public int getHi() {
                return this.hi;
            }

            public int getLo() {
                return this.lo;
            }

            public CompileUnit getCompileUnit() {
                return this.compileUnit;
            }
        }
    }

    private static final class NullLiteralNode
    extends LiteralNode<Object> {
        private NullLiteralNode(long token, int finish) {
            super(Token.recast(token, TokenType.OBJECT), finish, null);
        }

        @Override
        public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
            if (visitor.enterLiteralNode(this)) {
                return visitor.leaveLiteralNode(this);
            }
            return this;
        }

        @Override
        public Type getType() {
            return Type.OBJECT;
        }

        @Override
        public Type getWidestOperationType() {
            return Type.OBJECT;
        }
    }

    @Immutable
    private static class LexerTokenLiteralNode
    extends LiteralNode<Lexer.LexerToken> {
        private LexerTokenLiteralNode(long token, int finish, Lexer.LexerToken value) {
            super(Token.recast(token, TokenType.STRING), finish, value);
        }

        private LexerTokenLiteralNode(LexerTokenLiteralNode literalNode) {
            super(literalNode);
        }

        @Override
        public Type getType() {
            return Type.OBJECT;
        }

        @Override
        public void toString(StringBuilder sb) {
            sb.append(((Lexer.LexerToken)this.value).toString());
        }
    }

    @Immutable
    private static class StringLiteralNode
    extends LiteralNode<String> {
        private StringLiteralNode(long token, int finish, String value) {
            super(Token.recast(token, TokenType.STRING), finish, value);
        }

        private StringLiteralNode(StringLiteralNode literalNode) {
            super(literalNode);
        }

        @Override
        public void toString(StringBuilder sb) {
            sb.append('\"');
            sb.append((String)this.value);
            sb.append('\"');
        }
    }

    private static class UndefinedLiteralNode
    extends LiteralNode<Undefined> {
        private UndefinedLiteralNode(long token, int finish) {
            super(Token.recast(token, TokenType.OBJECT), finish, ScriptRuntime.UNDEFINED);
        }

        private UndefinedLiteralNode(UndefinedLiteralNode literalNode) {
            super(literalNode);
        }
    }

    @Immutable
    private static final class NumberLiteralNode
    extends LiteralNode<Number> {
        private final Type type;

        private NumberLiteralNode(long token, int finish, Number value) {
            super(Token.recast(token, TokenType.DECIMAL), finish, value);
            this.type = NumberLiteralNode.numberGetType((Number)this.value);
        }

        private NumberLiteralNode(NumberLiteralNode literalNode) {
            super(literalNode);
            this.type = NumberLiteralNode.numberGetType((Number)this.value);
        }

        private static Type numberGetType(Number number) {
            if (number instanceof Integer) {
                return Type.INT;
            }
            if (number instanceof Long) {
                return Type.LONG;
            }
            if (number instanceof Double) {
                return Type.NUMBER;
            }
            assert (false);
            return null;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public Type getWidestOperationType() {
            return this.getType();
        }
    }

    @Immutable
    private static final class BooleanLiteralNode
    extends LiteralNode<Boolean> {
        private BooleanLiteralNode(long token, int finish, boolean value) {
            super(Token.recast(token, value ? TokenType.TRUE : TokenType.FALSE), finish, value);
        }

        private BooleanLiteralNode(BooleanLiteralNode literalNode) {
            super(literalNode);
        }

        @Override
        public boolean isTrue() {
            return (Boolean)this.value;
        }

        @Override
        public Type getType() {
            return Type.BOOLEAN;
        }

        @Override
        public Type getWidestOperationType() {
            return Type.BOOLEAN;
        }
    }
}

