/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.BinaryNode;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.TemporarySymbols;
import jdk.nashorn.internal.ir.TypeOverride;
import jdk.nashorn.internal.ir.UnaryNode;
import jdk.nashorn.internal.ir.annotations.Immutable;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.parser.TokenType;

@Immutable
public class RuntimeNode
extends Node
implements TypeOverride<RuntimeNode> {
    private final Request request;
    private final List<Node> args;
    private final Type callSiteType;
    private final boolean isFinal;

    public RuntimeNode(long token, int finish, Request request, List<Node> args) {
        super(token, finish);
        this.request = request;
        this.args = args;
        this.callSiteType = null;
        this.isFinal = false;
    }

    private RuntimeNode(RuntimeNode runtimeNode, Request request, Type callSiteType, boolean isFinal, List<Node> args) {
        super(runtimeNode);
        this.request = request;
        this.args = args;
        this.callSiteType = callSiteType;
        this.isFinal = isFinal;
    }

    public RuntimeNode(long token, int finish, Request request, Node ... args) {
        this(token, finish, request, Arrays.asList(args));
    }

    public RuntimeNode(Node parent, Request request, Node ... args) {
        this(parent, request, Arrays.asList(args));
    }

    public RuntimeNode(Node parent, Request request, List<Node> args) {
        super(parent);
        this.request = request;
        this.args = args;
        this.callSiteType = null;
        this.isFinal = false;
    }

    public RuntimeNode(UnaryNode parent, Request request) {
        this((Node)parent, request, parent.rhs());
    }

    public RuntimeNode(BinaryNode parent, Request request) {
        this((Node)parent, request, parent.lhs(), parent.rhs());
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public RuntimeNode setIsFinal(boolean isFinal) {
        if (this.isFinal == isFinal) {
            return this;
        }
        return new RuntimeNode(this, this.request, this.callSiteType, isFinal, this.args);
    }

    @Override
    public Type getType() {
        return this.hasCallSiteType() ? this.callSiteType : this.request.getReturnType();
    }

    @Override
    public RuntimeNode setType(TemporarySymbols ts, LexicalContext lc, Type type) {
        if (this.callSiteType == type) {
            return this;
        }
        return new RuntimeNode(this, this.request, type, this.isFinal, this.args);
    }

    @Override
    public boolean canHaveCallSiteType() {
        return this.request == Request.ADD;
    }

    private boolean hasCallSiteType() {
        return this.callSiteType != null;
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterRuntimeNode(this)) {
            ArrayList<Node> newArgs = new ArrayList<Node>();
            for (Node arg : this.args) {
                newArgs.add(arg.accept(visitor));
            }
            return visitor.leaveRuntimeNode(this.setArgs(newArgs));
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append("ScriptRuntime.");
        sb.append((Object)this.request);
        sb.append('(');
        boolean first = true;
        for (Node arg : this.args) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            arg.toString(sb);
        }
        sb.append(')');
    }

    public List<Node> getArgs() {
        return Collections.unmodifiableList(this.args);
    }

    private RuntimeNode setArgs(List<Node> args) {
        if (this.args == args) {
            return this;
        }
        return new RuntimeNode(this, this.request, this.callSiteType, this.isFinal, args);
    }

    public Request getRequest() {
        return this.request;
    }

    public boolean isPrimitive() {
        for (Node arg : this.args) {
            if (!arg.getType().isObject()) continue;
            return false;
        }
        return true;
    }

    public static enum Request {
        ADD(TokenType.ADD, Type.OBJECT, 2, true),
        DEBUGGER,
        NEW,
        TYPEOF,
        REFERENCE_ERROR,
        DELETE(TokenType.DELETE, Type.BOOLEAN, 1),
        FAIL_DELETE(TokenType.DELETE, Type.BOOLEAN, 1, false),
        EQ_STRICT(TokenType.EQ_STRICT, Type.BOOLEAN, 2, true),
        EQ(TokenType.EQ, Type.BOOLEAN, 2, true),
        GE(TokenType.GE, Type.BOOLEAN, 2, true),
        GT(TokenType.GT, Type.BOOLEAN, 2, true),
        IN(TokenType.IN, Type.BOOLEAN, 2),
        INSTANCEOF(TokenType.INSTANCEOF, Type.BOOLEAN, 2),
        LE(TokenType.LE, Type.BOOLEAN, 2, true),
        LT(TokenType.LT, Type.BOOLEAN, 2, true),
        NE_STRICT(TokenType.NE_STRICT, Type.BOOLEAN, 2, true),
        NE(TokenType.NE, Type.BOOLEAN, 2, true);

        private final TokenType tokenType;
        private final Type returnType;
        private final int arity;
        private final boolean canSpecialize;

        private Request() {
            this(TokenType.VOID, Type.OBJECT, 0);
        }

        private Request(TokenType tokenType, Type returnType, int arity) {
            this(tokenType, returnType, arity, false);
        }

        private Request(TokenType tokenType, Type returnType, int arity, boolean canSpecialize) {
            this.tokenType = tokenType;
            this.returnType = returnType;
            this.arity = arity;
            this.canSpecialize = canSpecialize;
        }

        public boolean canSpecialize() {
            return this.canSpecialize;
        }

        public int getArity() {
            return this.arity;
        }

        public Type getReturnType() {
            return this.returnType;
        }

        public TokenType getTokenType() {
            return this.tokenType;
        }

        public String nonStrictName() {
            switch (this) {
                case NE_STRICT: {
                    return NE.name();
                }
                case EQ_STRICT: {
                    return EQ.name();
                }
            }
            return this.name();
        }

        public static boolean isEQ(Request request) {
            return request == EQ || request == EQ_STRICT;
        }

        public static boolean isNE(Request request) {
            return request == NE || request == NE_STRICT;
        }

        public static Request reverse(Request request) {
            switch (request) {
                case NE_STRICT: 
                case EQ_STRICT: 
                case EQ: 
                case NE: {
                    return request;
                }
                case LE: {
                    return GE;
                }
                case LT: {
                    return GT;
                }
                case GE: {
                    return LE;
                }
                case GT: {
                    return LT;
                }
            }
            return null;
        }

        public static Request invert(Request request) {
            switch (request) {
                case EQ: {
                    return NE;
                }
                case EQ_STRICT: {
                    return NE_STRICT;
                }
                case NE: {
                    return EQ;
                }
                case NE_STRICT: {
                    return EQ_STRICT;
                }
                case LE: {
                    return GT;
                }
                case LT: {
                    return GE;
                }
                case GE: {
                    return LT;
                }
                case GT: {
                    return LE;
                }
            }
            return null;
        }

        public static boolean isComparison(Request request) {
            switch (request) {
                case NE_STRICT: 
                case EQ_STRICT: 
                case EQ: 
                case NE: 
                case LE: 
                case LT: 
                case GE: 
                case GT: {
                    return true;
                }
            }
            return false;
        }
    }
}

