/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jdk.nashorn.internal.codegen.Label;
import jdk.nashorn.internal.ir.BreakableNode;
import jdk.nashorn.internal.ir.CaseNode;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.ir.annotations.Immutable;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;

@Immutable
public final class SwitchNode
extends BreakableNode {
    private final Node expression;
    private final List<CaseNode> cases;
    private final int defaultCaseIndex;
    private Symbol tag;

    public SwitchNode(int lineNumber, long token, int finish, Node expression, List<CaseNode> cases, CaseNode defaultCase) {
        super(lineNumber, token, finish, new Label("switch_break"));
        this.expression = expression;
        this.cases = cases;
        this.defaultCaseIndex = defaultCase == null ? -1 : cases.indexOf(defaultCase);
    }

    private SwitchNode(SwitchNode switchNode, Node expression, List<CaseNode> cases, int defaultCase) {
        super(switchNode);
        this.expression = expression;
        this.cases = cases;
        this.defaultCaseIndex = defaultCase;
        this.tag = switchNode.getTag();
    }

    @Override
    public Node ensureUniqueLabels(LexicalContext lc) {
        ArrayList<CaseNode> newCases = new ArrayList<CaseNode>();
        for (CaseNode caseNode : this.cases) {
            newCases.add(new CaseNode(caseNode, caseNode.getTest(), caseNode.getBody()));
        }
        return Node.replaceInLexicalContext(lc, this, new SwitchNode(this, this.expression, newCases, this.defaultCaseIndex));
    }

    @Override
    public boolean isTerminal() {
        if (!this.cases.isEmpty() && this.defaultCaseIndex != -1) {
            for (CaseNode caseNode : this.cases) {
                if (caseNode.isTerminal()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Node accept(LexicalContext lc, NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterSwitchNode(this)) {
            return visitor.leaveSwitchNode(this.setExpression(lc, this.expression.accept(visitor)).setCases(lc, Node.accept(visitor, CaseNode.class, this.cases), this.defaultCaseIndex));
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append("switch (");
        this.expression.toString(sb);
        sb.append(')');
    }

    public CaseNode getDefaultCase() {
        return this.defaultCaseIndex == -1 ? null : this.cases.get(this.defaultCaseIndex);
    }

    public List<CaseNode> getCases() {
        return Collections.unmodifiableList(this.cases);
    }

    public SwitchNode setCases(LexicalContext lc, List<CaseNode> cases) {
        return this.setCases(lc, cases, this.defaultCaseIndex);
    }

    private SwitchNode setCases(LexicalContext lc, List<CaseNode> cases, int defaultCaseIndex) {
        if (this.cases == cases) {
            return this;
        }
        return Node.replaceInLexicalContext(lc, this, new SwitchNode(this, this.expression, cases, defaultCaseIndex));
    }

    public SwitchNode setCases(LexicalContext lc, List<CaseNode> cases, CaseNode defaultCase) {
        return this.setCases(lc, cases, defaultCase == null ? -1 : cases.indexOf(defaultCase));
    }

    public Node getExpression() {
        return this.expression;
    }

    public SwitchNode setExpression(LexicalContext lc, Node expression) {
        if (this.expression == expression) {
            return this;
        }
        return Node.replaceInLexicalContext(lc, this, new SwitchNode(this, expression, this.cases, this.defaultCaseIndex));
    }

    public Symbol getTag() {
        return this.tag;
    }

    public void setTag(Symbol tag) {
        this.tag = tag;
    }
}

