/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.Assignment;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.annotations.Immutable;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.parser.Token;
import jdk.nashorn.internal.parser.TokenType;

@Immutable
public final class UnaryNode
extends Node
implements Assignment<Node> {
    private final Node rhs;

    public UnaryNode(long token, Node rhs) {
        this(token, Math.min(rhs.getStart(), Token.descPosition(token)), Math.max(Token.descPosition(token) + Token.descLength(token), rhs.getFinish()), rhs);
    }

    public UnaryNode(long token, int start, int finish, Node rhs) {
        super(token, start, finish);
        this.rhs = rhs;
    }

    private UnaryNode(UnaryNode unaryNode, Node rhs) {
        super(unaryNode);
        this.rhs = rhs;
    }

    @Override
    public boolean isAssignment() {
        switch (this.tokenType()) {
            case DECPOSTFIX: 
            case DECPREFIX: 
            case INCPOSTFIX: 
            case INCPREFIX: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSelfModifying() {
        return this.isAssignment();
    }

    @Override
    public Type getWidestOperationType() {
        return this.isAssignment() ? Type.NUMBER : Type.OBJECT;
    }

    @Override
    public Node getAssignmentDest() {
        return this.isAssignment() ? this.rhs() : null;
    }

    @Override
    public Node setAssignmentDest(Node n) {
        return this.setRHS(n);
    }

    @Override
    public Node getAssignmentSource() {
        return this.getAssignmentDest();
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterUnaryNode(this)) {
            return visitor.leaveUnaryNode(this.setRHS(this.rhs.accept(visitor)));
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        TokenType type = this.tokenType();
        String name = type.getName();
        boolean isPostfix = type == TokenType.DECPOSTFIX || type == TokenType.INCPOSTFIX;
        boolean isConvert = type == TokenType.CONVERT && this.getSymbol() != null;
        boolean rhsParen = type.needsParens(this.rhs().tokenType(), false);
        int convertPos = 0;
        if (isConvert) {
            convertPos = sb.length();
            sb.append("(");
            sb.append(this.getType());
            sb.append(")(");
        }
        if (!isPostfix && !isConvert) {
            if (name == null) {
                sb.append(type.name());
                rhsParen = true;
            } else {
                sb.append(name);
                if (type.ordinal() > TokenType.BIT_NOT.ordinal()) {
                    sb.append(' ');
                }
            }
        }
        if (rhsParen) {
            sb.append('(');
        }
        this.rhs().toString(sb);
        if (rhsParen) {
            sb.append(')');
        }
        if (isPostfix) {
            sb.append(type == TokenType.DECPOSTFIX ? "--" : "++");
        }
        if (isConvert) {
            boolean endsWithParenthesis;
            boolean bl = endsWithParenthesis = sb.charAt(sb.length() - 1) == ')';
            if (!endsWithParenthesis) {
                sb.append(')');
            } else {
                sb.setCharAt(convertPos, ' ');
            }
        }
    }

    public Node rhs() {
        return this.rhs;
    }

    public UnaryNode setRHS(Node rhs) {
        if (this.rhs == rhs) {
            return this;
        }
        return new UnaryNode(this, rhs);
    }
}

