/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.objects;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.objects.NativeArray;
import jdk.nashorn.internal.objects.NativeArrayBuffer;
import jdk.nashorn.internal.runtime.AccessorProperty;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.Property;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.arrays.ArrayData;

abstract class ArrayBufferView
extends ScriptObject {
    private static PropertyMap $nasgenmap$;

    static PropertyMap getInitialMap() {
        return $nasgenmap$;
    }

    private ArrayBufferView(NativeArrayBuffer buffer, int byteOffset, int elementLength, Global global) {
        super(global.getArrayBufferViewMap());
        this.checkConstructorArgs(buffer, byteOffset, elementLength);
        this.setProto(this.getPrototype(global));
        this.setArray(this.factory().createArrayData(buffer, byteOffset, elementLength));
    }

    ArrayBufferView(NativeArrayBuffer buffer, int byteOffset, int elementLength) {
        this(buffer, byteOffset, elementLength, Global.instance());
    }

    private void checkConstructorArgs(NativeArrayBuffer buffer, int byteOffset, int elementLength) {
        if (byteOffset < 0 || elementLength < 0) {
            throw new RuntimeException("byteOffset or length must not be negative");
        }
        if (byteOffset + elementLength * this.bytesPerElement() > buffer.getByteLength()) {
            throw new RuntimeException("byteOffset + byteLength out of range");
        }
        if (byteOffset % this.bytesPerElement() != 0) {
            throw new RuntimeException("byteOffset must be a multiple of the element size");
        }
    }

    private int bytesPerElement() {
        return this.factory().bytesPerElement;
    }

    public static Object buffer(Object self) {
        return ((ArrayDataImpl)((ArrayBufferView)self).getArray()).buffer;
    }

    public static Object byteOffset(Object self) {
        return ((ArrayDataImpl)((ArrayBufferView)self).getArray()).byteOffset;
    }

    public static Object byteLength(Object self) {
        ArrayBufferView view = (ArrayBufferView)self;
        return ((ArrayDataImpl)view.getArray()).elementLength * view.bytesPerElement();
    }

    public static Object length(Object self) {
        return ((ArrayBufferView)self).elementLength();
    }

    @Override
    public final Object getLength() {
        return this.elementLength();
    }

    private int elementLength() {
        return ((ArrayDataImpl)this.getArray()).elementLength;
    }

    protected abstract Factory factory();

    protected abstract ScriptObject getPrototype(Global var1);

    protected boolean isFloatArray() {
        return false;
    }

    protected static ArrayBufferView constructorImpl(Object[] args, Factory factory) {
        ArrayBufferView dst;
        int length;
        Object arg0;
        Object object = arg0 = args.length != 0 ? args[0] : Integer.valueOf(0);
        if (arg0 instanceof NativeArrayBuffer) {
            int length2;
            int byteOffset;
            NativeArrayBuffer buffer = (NativeArrayBuffer)arg0;
            int n = byteOffset = args.length > 1 ? JSType.toInt32(args[1]) : 0;
            if (args.length > 2) {
                length2 = JSType.toInt32(args[2]);
            } else {
                if ((buffer.getByteLength() - byteOffset) % factory.bytesPerElement != 0) {
                    throw new RuntimeException("buffer.byteLength - byteOffset must be a multiple of the element size");
                }
                length2 = (buffer.getByteLength() - byteOffset) / factory.bytesPerElement;
            }
            return factory.construct(buffer, byteOffset, length2);
        }
        if (arg0 instanceof ArrayBufferView) {
            length = ((ArrayBufferView)arg0).elementLength();
            dst = factory.construct(length);
        } else if (arg0 instanceof NativeArray) {
            length = ArrayBufferView.lengthToInt(((NativeArray)arg0).getArray().length());
            dst = factory.construct(length);
        } else {
            int length3 = ArrayBufferView.lengthToInt(JSType.toInt64(arg0));
            return factory.construct(length3);
        }
        ArrayBufferView.copyElements(dst, length, (ScriptObject)arg0, 0);
        return dst;
    }

    protected static Object setImpl(Object self, Object array, Object offset0) {
        int length;
        ArrayBufferView dest = (ArrayBufferView)self;
        if (array instanceof ArrayBufferView) {
            length = ((ArrayBufferView)array).elementLength();
        } else if (array instanceof NativeArray) {
            length = (int)(((NativeArray)array).getArray().length() & Integer.MAX_VALUE);
        } else {
            throw new RuntimeException("argument is not of array type");
        }
        ScriptObject source = (ScriptObject)array;
        int offset = JSType.toInt32(offset0);
        if (dest.elementLength() < length + offset || offset < 0) {
            throw new RuntimeException("offset or array length out of bounds");
        }
        ArrayBufferView.copyElements(dest, length, source, offset);
        return ScriptRuntime.UNDEFINED;
    }

    private static void copyElements(ArrayBufferView dest, int length, ScriptObject source, int offset) {
        if (!dest.isFloatArray()) {
            int i = 0;
            int j = offset;
            while (i < length) {
                dest.set(j, source.getInt(i), false);
                ++i;
                ++j;
            }
        } else {
            int i = 0;
            int j = offset;
            while (i < length) {
                dest.set(j, source.getDouble(i), false);
                ++i;
                ++j;
            }
        }
    }

    private static int lengthToInt(long length) {
        if (length > Integer.MAX_VALUE || length < 0L) {
            throw ECMAErrors.rangeError("inappropriate.array.buffer.length", JSType.toString(length));
        }
        return (int)(length & Integer.MAX_VALUE);
    }

    protected static Object subarrayImpl(Object self, Object begin0, Object end0) {
        ArrayBufferView arrayView = (ArrayBufferView)self;
        int elementLength = arrayView.elementLength();
        int begin = NativeArrayBuffer.adjustIndex(JSType.toInt32(begin0), elementLength);
        int end = NativeArrayBuffer.adjustIndex(end0 != ScriptRuntime.UNDEFINED ? JSType.toInt32(end0) : elementLength, elementLength);
        ArrayDataImpl arrayData = (ArrayDataImpl)arrayView.getArray();
        return arrayView.factory().construct(arrayData.buffer, arrayData.byteIndex(begin), Math.max(end - begin, 0));
    }

    static {
        ArrayBufferView.$clinit$();
    }

    public static void $clinit$() {
        ArrayList<Property> arrayList = new ArrayList<Property>(4);
        arrayList.add(AccessorProperty.create("buffer", 7, cfr_ldc_0(), null));
        arrayList.add(AccessorProperty.create("byteOffset", 7, cfr_ldc_1(), null));
        arrayList.add(AccessorProperty.create("byteLength", 7, cfr_ldc_2(), null));
        arrayList.add(AccessorProperty.create("length", 7, cfr_ldc_3(), null));
        $nasgenmap$ = PropertyMap.newMap(arrayList).setIsShared();
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_0() {
        try {
            return MethodHandles.lookup().findStatic(ArrayBufferView.class, "buffer", MethodType.fromMethodDescriptorString("(Ljava/lang/Object;)Ljava/lang/Object;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_1() {
        try {
            return MethodHandles.lookup().findStatic(ArrayBufferView.class, "byteOffset", MethodType.fromMethodDescriptorString("(Ljava/lang/Object;)Ljava/lang/Object;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_2() {
        try {
            return MethodHandles.lookup().findStatic(ArrayBufferView.class, "byteLength", MethodType.fromMethodDescriptorString("(Ljava/lang/Object;)Ljava/lang/Object;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_3() {
        try {
            return MethodHandles.lookup().findStatic(ArrayBufferView.class, "length", MethodType.fromMethodDescriptorString("(Ljava/lang/Object;)Ljava/lang/Object;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    protected static abstract class Factory {
        final int bytesPerElement;

        public Factory(int bytesPerElement) {
            this.bytesPerElement = bytesPerElement;
        }

        public final ArrayBufferView construct(int elementLength) {
            return this.construct(new NativeArrayBuffer(elementLength * this.bytesPerElement), 0, elementLength);
        }

        public abstract ArrayBufferView construct(NativeArrayBuffer var1, int var2, int var3);

        public abstract ArrayData createArrayData(NativeArrayBuffer var1, int var2, int var3);
    }

    protected static abstract class ArrayDataImpl
    extends ArrayData {
        protected final NativeArrayBuffer buffer;
        protected final int byteOffset;
        private final int elementLength;

        protected ArrayDataImpl(NativeArrayBuffer buffer, int byteOffset, int elementLength) {
            super(elementLength);
            this.buffer = buffer;
            this.byteOffset = byteOffset;
            this.elementLength = elementLength;
        }

        @Override
        public Object[] asObjectArray() {
            Object[] array = new Object[this.elementLength];
            for (int i = 0; i < this.elementLength; ++i) {
                array[i] = this.getObjectImpl(i);
            }
            return array;
        }

        @Override
        public ArrayData ensure(long safeIndex) {
            return this;
        }

        @Override
        public void setLength(long length) {
        }

        @Override
        public ArrayData shrink(long newLength) {
            return this;
        }

        @Override
        public ArrayData set(int index, Object value, boolean strict) {
            if (this.has(index)) {
                this.setImpl(index, value);
            }
            return this;
        }

        @Override
        public ArrayData set(int index, int value, boolean strict) {
            if (this.has(index)) {
                this.setImpl(index, value);
            }
            return this;
        }

        @Override
        public ArrayData set(int index, long value, boolean strict) {
            if (this.has(index)) {
                this.setImpl(index, value);
            }
            return this;
        }

        @Override
        public ArrayData set(int index, double value, boolean strict) {
            if (this.has(index)) {
                this.setImpl(index, value);
            }
            return this;
        }

        @Override
        public int getInt(int index) {
            return this.getIntImpl(index);
        }

        @Override
        public long getLong(int index) {
            return this.getLongImpl(index);
        }

        @Override
        public double getDouble(int index) {
            return this.getDoubleImpl(index);
        }

        @Override
        public Object getObject(int index) {
            return this.getObjectImpl(index);
        }

        @Override
        public boolean has(int index) {
            return index >= 0 && index < this.elementLength;
        }

        @Override
        public boolean canDelete(int index, boolean strict) {
            return false;
        }

        @Override
        public boolean canDelete(long fromIndex, long toIndex, boolean strict) {
            return false;
        }

        @Override
        public ArrayData delete(int index) {
            return this;
        }

        @Override
        public ArrayData delete(long fromIndex, long toIndex) {
            return this;
        }

        @Override
        protected ArrayData convert(Class<?> type) {
            return this;
        }

        @Override
        public void shiftLeft(int by) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ArrayData shiftRight(int by) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object pop() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ArrayData slice(long from, long to) {
            throw new UnsupportedOperationException();
        }

        protected abstract int getIntImpl(int var1);

        protected long getLongImpl(int key) {
            return this.getIntImpl(key);
        }

        protected double getDoubleImpl(int key) {
            return this.getIntImpl(key);
        }

        protected Object getObjectImpl(int key) {
            return this.getIntImpl(key);
        }

        protected abstract void setImpl(int var1, int var2);

        protected void setImpl(int key, long value) {
            this.setImpl(key, (int)value);
        }

        protected void setImpl(int key, double value) {
            this.setImpl(key, JSType.toInt32(value));
        }

        protected void setImpl(int key, Object value) {
            this.setImpl(key, JSType.toInt32(value));
        }

        protected abstract int byteIndex(int var1);
    }
}

