/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.objects;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import jdk.nashorn.internal.lookup.Lookup;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.objects.NativeStrictArguments;
import jdk.nashorn.internal.runtime.AccessorProperty;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.Property;
import jdk.nashorn.internal.runtime.PropertyDescriptor;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.arrays.ArrayData;
import jdk.nashorn.internal.runtime.arrays.ArrayIndex;

public final class NativeArguments
extends ScriptObject {
    private static final MethodHandle G$LENGTH = NativeArguments.findOwnMH("G$length", Object.class, Object.class);
    private static final MethodHandle S$LENGTH = NativeArguments.findOwnMH("S$length", Void.TYPE, Object.class, Object.class);
    private static final MethodHandle G$CALLEE = NativeArguments.findOwnMH("G$callee", Object.class, Object.class);
    private static final MethodHandle S$CALLEE = NativeArguments.findOwnMH("S$callee", Void.TYPE, Object.class, Object.class);
    private static final PropertyMap map$;
    private Object length;
    private Object callee;
    private ArrayData namedArgs;
    private BitSet deleted;

    static PropertyMap getInitialMap() {
        return map$;
    }

    NativeArguments(Object[] arguments, Object callee, int numParams, ScriptObject proto, PropertyMap map) {
        super(proto, map);
        this.setIsArguments();
        this.setArray(ArrayData.allocate(arguments));
        this.length = arguments.length;
        this.callee = callee;
        Object[] newValues = new Object[numParams];
        if (numParams > arguments.length) {
            Arrays.fill(newValues, ScriptRuntime.UNDEFINED);
        }
        System.arraycopy(arguments, 0, newValues, 0, Math.min(newValues.length, arguments.length));
        this.namedArgs = ArrayData.allocate(newValues);
    }

    @Override
    public String getClassName() {
        return "Arguments";
    }

    @Override
    public Object getArgument(int key) {
        return this.namedArgs.has(key) ? this.namedArgs.getObject(key) : ScriptRuntime.UNDEFINED;
    }

    @Override
    public void setArgument(int key, Object value) {
        if (this.namedArgs.has(key)) {
            this.namedArgs = this.namedArgs.set(key, value, false);
        }
    }

    @Override
    public int getInt(Object key) {
        int index = ArrayIndex.getArrayIndex(key);
        return this.isMapped(index) ? this.namedArgs.getInt(index) : super.getInt(key);
    }

    @Override
    public int getInt(double key) {
        int index = ArrayIndex.getArrayIndex(key);
        return this.isMapped(index) ? this.namedArgs.getInt(index) : super.getInt(key);
    }

    @Override
    public int getInt(long key) {
        int index = ArrayIndex.getArrayIndex(key);
        return this.isMapped(index) ? this.namedArgs.getInt(index) : super.getInt(key);
    }

    @Override
    public int getInt(int key) {
        int index = ArrayIndex.getArrayIndex(key);
        return this.isMapped(index) ? this.namedArgs.getInt(index) : super.getInt(key);
    }

    @Override
    public long getLong(Object key) {
        int index = ArrayIndex.getArrayIndex(key);
        return this.isMapped(index) ? this.namedArgs.getLong(index) : super.getLong(key);
    }

    @Override
    public long getLong(double key) {
        int index = ArrayIndex.getArrayIndex(key);
        return this.isMapped(index) ? this.namedArgs.getLong(index) : super.getLong(key);
    }

    @Override
    public long getLong(long key) {
        int index = ArrayIndex.getArrayIndex(key);
        return this.isMapped(index) ? this.namedArgs.getLong(index) : super.getLong(key);
    }

    @Override
    public long getLong(int key) {
        int index = ArrayIndex.getArrayIndex(key);
        return this.isMapped(index) ? this.namedArgs.getLong(index) : super.getLong(key);
    }

    @Override
    public double getDouble(Object key) {
        int index = ArrayIndex.getArrayIndex(key);
        return this.isMapped(index) ? this.namedArgs.getDouble(index) : super.getDouble(key);
    }

    @Override
    public double getDouble(double key) {
        int index = ArrayIndex.getArrayIndex(key);
        return this.isMapped(index) ? this.namedArgs.getDouble(index) : super.getDouble(key);
    }

    @Override
    public double getDouble(long key) {
        int index = ArrayIndex.getArrayIndex(key);
        return this.isMapped(index) ? this.namedArgs.getDouble(index) : super.getDouble(key);
    }

    @Override
    public double getDouble(int key) {
        int index = ArrayIndex.getArrayIndex(key);
        return this.isMapped(index) ? this.namedArgs.getDouble(index) : super.getDouble(key);
    }

    @Override
    public Object get(Object key) {
        int index = ArrayIndex.getArrayIndex(key);
        return this.isMapped(index) ? this.namedArgs.getObject(index) : super.get(key);
    }

    @Override
    public Object get(double key) {
        int index = ArrayIndex.getArrayIndex(key);
        return this.isMapped(index) ? this.namedArgs.getObject(index) : super.get(key);
    }

    @Override
    public Object get(long key) {
        int index = ArrayIndex.getArrayIndex(key);
        return this.isMapped(index) ? this.namedArgs.getObject(index) : super.get(key);
    }

    @Override
    public Object get(int key) {
        int index = ArrayIndex.getArrayIndex(key);
        return this.isMapped(index) ? this.namedArgs.getObject(index) : super.get(key);
    }

    @Override
    public void set(Object key, int value, boolean strict) {
        int index = ArrayIndex.getArrayIndex(key);
        if (this.isMapped(index)) {
            this.namedArgs = this.namedArgs.set(index, value, strict);
        } else {
            super.set(key, value, strict);
        }
    }

    @Override
    public void set(Object key, long value, boolean strict) {
        int index = ArrayIndex.getArrayIndex(key);
        if (this.isMapped(index)) {
            this.namedArgs = this.namedArgs.set(index, value, strict);
        } else {
            super.set(key, value, strict);
        }
    }

    @Override
    public void set(Object key, double value, boolean strict) {
        int index = ArrayIndex.getArrayIndex(key);
        if (this.isMapped(index)) {
            this.namedArgs = this.namedArgs.set(index, value, strict);
        } else {
            super.set(key, value, strict);
        }
    }

    @Override
    public void set(Object key, Object value, boolean strict) {
        int index = ArrayIndex.getArrayIndex(key);
        if (this.isMapped(index)) {
            this.namedArgs = this.namedArgs.set(index, value, strict);
        } else {
            super.set(key, value, strict);
        }
    }

    @Override
    public void set(double key, int value, boolean strict) {
        int index = ArrayIndex.getArrayIndex(key);
        if (this.isMapped(index)) {
            this.namedArgs = this.namedArgs.set(index, value, strict);
        } else {
            super.set(key, value, strict);
        }
    }

    @Override
    public void set(double key, long value, boolean strict) {
        int index = ArrayIndex.getArrayIndex(key);
        if (this.isMapped(index)) {
            this.namedArgs = this.namedArgs.set(index, value, strict);
        } else {
            super.set(key, value, strict);
        }
    }

    @Override
    public void set(double key, double value, boolean strict) {
        int index = ArrayIndex.getArrayIndex(key);
        if (this.isMapped(index)) {
            this.namedArgs = this.namedArgs.set(index, value, strict);
        } else {
            super.set(key, value, strict);
        }
    }

    @Override
    public void set(double key, Object value, boolean strict) {
        int index = ArrayIndex.getArrayIndex(key);
        if (this.isMapped(index)) {
            this.namedArgs = this.namedArgs.set(index, value, strict);
        } else {
            super.set(key, value, strict);
        }
    }

    @Override
    public void set(long key, int value, boolean strict) {
        int index = ArrayIndex.getArrayIndex(key);
        if (this.isMapped(index)) {
            this.namedArgs = this.namedArgs.set(index, value, strict);
        } else {
            super.set(key, value, strict);
        }
    }

    @Override
    public void set(long key, long value, boolean strict) {
        int index = ArrayIndex.getArrayIndex(key);
        if (this.isMapped(index)) {
            this.namedArgs = this.namedArgs.set(index, value, strict);
        } else {
            super.set(key, value, strict);
        }
    }

    @Override
    public void set(long key, double value, boolean strict) {
        int index = ArrayIndex.getArrayIndex(key);
        if (this.isMapped(index)) {
            this.namedArgs = this.namedArgs.set(index, value, strict);
        } else {
            super.set(key, value, strict);
        }
    }

    @Override
    public void set(long key, Object value, boolean strict) {
        int index = ArrayIndex.getArrayIndex(key);
        if (this.isMapped(index)) {
            this.namedArgs = this.namedArgs.set(index, value, strict);
        } else {
            super.set(key, value, strict);
        }
    }

    @Override
    public void set(int key, int value, boolean strict) {
        int index = ArrayIndex.getArrayIndex(key);
        if (this.isMapped(index)) {
            this.namedArgs = this.namedArgs.set(index, value, strict);
        } else {
            super.set(key, value, strict);
        }
    }

    @Override
    public void set(int key, long value, boolean strict) {
        int index = ArrayIndex.getArrayIndex(key);
        if (this.isMapped(index)) {
            this.namedArgs = this.namedArgs.set(index, value, strict);
        } else {
            super.set(key, value, strict);
        }
    }

    @Override
    public void set(int key, double value, boolean strict) {
        int index = ArrayIndex.getArrayIndex(key);
        if (this.isMapped(index)) {
            this.namedArgs = this.namedArgs.set(index, value, strict);
        } else {
            super.set(key, value, strict);
        }
    }

    @Override
    public void set(int key, Object value, boolean strict) {
        int index = ArrayIndex.getArrayIndex(key);
        if (this.isMapped(index)) {
            this.namedArgs = this.namedArgs.set(index, value, strict);
        } else {
            super.set(key, value, strict);
        }
    }

    @Override
    public boolean has(Object key) {
        int index = ArrayIndex.getArrayIndex(key);
        return this.isMapped(index) || super.has(key);
    }

    @Override
    public boolean has(double key) {
        int index = ArrayIndex.getArrayIndex(key);
        return this.isMapped(index) || super.has(key);
    }

    @Override
    public boolean has(long key) {
        int index = ArrayIndex.getArrayIndex(key);
        return this.isMapped(index) || super.has(key);
    }

    @Override
    public boolean has(int key) {
        int index = ArrayIndex.getArrayIndex(key);
        return this.isMapped(index) || super.has(key);
    }

    @Override
    public boolean hasOwnProperty(Object key) {
        int index = ArrayIndex.getArrayIndex(key);
        return this.isMapped(index) || super.hasOwnProperty(key);
    }

    @Override
    public boolean hasOwnProperty(int key) {
        int index = ArrayIndex.getArrayIndex(key);
        return this.isMapped(index) || super.hasOwnProperty(key);
    }

    @Override
    public boolean hasOwnProperty(long key) {
        int index = ArrayIndex.getArrayIndex(key);
        return this.isMapped(index) || super.hasOwnProperty(key);
    }

    @Override
    public boolean hasOwnProperty(double key) {
        int index = ArrayIndex.getArrayIndex(key);
        return this.isMapped(index) || super.hasOwnProperty(key);
    }

    @Override
    public boolean delete(int key, boolean strict) {
        int index = ArrayIndex.getArrayIndex(key);
        boolean success = super.delete(key, strict);
        if (success && this.namedArgs.has(index)) {
            this.setDeleted(index);
        }
        return success;
    }

    @Override
    public boolean delete(long key, boolean strict) {
        int index = ArrayIndex.getArrayIndex(key);
        boolean success = super.delete(key, strict);
        if (success && this.namedArgs.has(index)) {
            this.setDeleted(index);
        }
        return success;
    }

    @Override
    public boolean delete(double key, boolean strict) {
        int index = ArrayIndex.getArrayIndex(key);
        boolean success = super.delete(key, strict);
        if (success && this.namedArgs.has(index)) {
            this.setDeleted(index);
        }
        return success;
    }

    @Override
    public boolean delete(Object key, boolean strict) {
        int index = ArrayIndex.getArrayIndex(key);
        boolean success = super.delete(key, strict);
        if (success && this.namedArgs.has(index)) {
            this.setDeleted(index);
        }
        return success;
    }

    @Override
    public boolean defineOwnProperty(String key, Object propertyDesc, boolean reject) {
        int index = ArrayIndex.getArrayIndex(key);
        if (index >= 0) {
            boolean allowed = super.defineOwnProperty(key, propertyDesc, false);
            if (!allowed) {
                if (reject) {
                    throw ECMAErrors.typeError("cant.redefine.property", key, ScriptRuntime.safeToString(this));
                }
                return false;
            }
            if (this.isMapped(index)) {
                PropertyDescriptor desc = NativeArguments.toPropertyDescriptor(Global.instance(), propertyDesc);
                if (desc.type() == 2) {
                    this.setDeleted(index);
                } else {
                    if (desc.has("value")) {
                        this.namedArgs = this.namedArgs.set(index, desc.getValue(), false);
                    }
                    if (desc.has("writable") && !desc.isWritable()) {
                        this.setDeleted(index);
                    }
                }
            }
            return true;
        }
        return super.defineOwnProperty(key, propertyDesc, reject);
    }

    private boolean isDeleted(int index) {
        return this.deleted != null ? this.deleted.get(index) : false;
    }

    private void setDeleted(int index) {
        if (this.deleted == null) {
            this.deleted = new BitSet((int)this.namedArgs.length());
        }
        this.deleted.set(index, true);
    }

    private boolean isMapped(int index) {
        return this.namedArgs.has(index) && !this.isDeleted(index);
    }

    public static ScriptObject allocate(Object[] arguments, ScriptFunction callee, int numParams) {
        boolean isStrict = callee == null || callee.isStrict();
        Global global = Global.instance();
        ScriptObject proto = global.getObjectPrototype();
        if (isStrict) {
            return new NativeStrictArguments(arguments, numParams, proto, global.getStrictArgumentsMap());
        }
        return new NativeArguments(arguments, callee, numParams, proto, global.getArgumentsMap());
    }

    public static Object G$length(Object self) {
        if (self instanceof NativeArguments) {
            return ((NativeArguments)self).getArgumentsLength();
        }
        return 0;
    }

    public static void S$length(Object self, Object value) {
        if (self instanceof NativeArguments) {
            ((NativeArguments)self).setArgumentsLength(value);
        }
    }

    public static Object G$callee(Object self) {
        if (self instanceof NativeArguments) {
            return ((NativeArguments)self).getCallee();
        }
        return ScriptRuntime.UNDEFINED;
    }

    public static void S$callee(Object self, Object value) {
        if (self instanceof NativeArguments) {
            ((NativeArguments)self).setCallee(value);
        }
    }

    @Override
    public Object getLength() {
        return this.length;
    }

    private Object getArgumentsLength() {
        return this.length;
    }

    private void setArgumentsLength(Object length) {
        this.length = length;
    }

    private Object getCallee() {
        return this.callee;
    }

    private void setCallee(Object callee) {
        this.callee = callee;
    }

    private static MethodHandle findOwnMH(String name, Class<?> rtype, Class<?> ... types) {
        return Lookup.MH.findStatic(MethodHandles.lookup(), NativeArguments.class, name, Lookup.MH.type(rtype, types));
    }

    static {
        ArrayList<Property> properties = new ArrayList<Property>(2);
        properties.add(AccessorProperty.create("length", 2, G$LENGTH, S$LENGTH));
        properties.add(AccessorProperty.create("callee", 2, G$CALLEE, S$CALLEE));
        map$ = PropertyMap.newMap(properties).setIsShared();
    }
}

