/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.SecureClassLoader;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.tools.Shell;

abstract class NashornLoader
extends SecureClassLoader {
    private static final String OBJECTS_PKG = "jdk.nashorn.internal.objects";
    private static final String RUNTIME_PKG = "jdk.nashorn.internal.runtime";
    private static final String RUNTIME_LINKER_PKG = "jdk.nashorn.internal.runtime.linker";
    private static final String SCRIPTS_PKG = "jdk.nashorn.internal.scripts";
    private static final Permission[] SCRIPT_PERMISSIONS = new Permission[4];
    private final Context context;

    final Context getContext() {
        return this.context;
    }

    NashornLoader(ClassLoader parent, Context context) {
        super(parent);
        this.context = context;
    }

    protected final Class<?> loadClassTrusted(String name, boolean resolve) throws ClassNotFoundException {
        return super.loadClass(name, resolve);
    }

    protected static void checkPackageAccess(String name) {
        SecurityManager sm;
        int i = name.lastIndexOf(46);
        if (i != -1 && (sm = System.getSecurityManager()) != null) {
            String pkgName;
            switch (pkgName = name.substring(0, i)) {
                case "jdk.nashorn.internal.runtime": 
                case "jdk.nashorn.internal.runtime.linker": 
                case "jdk.nashorn.internal.objects": 
                case "jdk.nashorn.internal.scripts": {
                    break;
                }
                default: {
                    sm.checkPackageAccess(pkgName);
                }
            }
        }
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        Permissions permCollection = new Permissions();
        for (Permission perm : SCRIPT_PERMISSIONS) {
            permCollection.add(perm);
        }
        return permCollection;
    }

    static ClassLoader createClassLoader(String classPath) {
        ClassLoader parent = Shell.class.getClassLoader();
        URL[] urls = NashornLoader.pathToURLs(classPath);
        return URLClassLoader.newInstance(urls, parent);
    }

    private static URL[] pathToURLs(String path) {
        String[] components = path.split(File.pathSeparator);
        URL[] urls = new URL[components.length];
        int count = 0;
        while (count < components.length) {
            URL url = NashornLoader.fileToURL(new File(components[count]));
            if (url == null) continue;
            urls[count++] = url;
        }
        if (urls.length != count) {
            URL[] tmp = new URL[count];
            System.arraycopy(urls, 0, tmp, 0, count);
            urls = tmp;
        }
        return urls;
    }

    private static URL fileToURL(File file) {
        String name;
        try {
            name = file.getCanonicalPath();
        }
        catch (IOException e) {
            name = file.getAbsolutePath();
        }
        name = name.replace(File.separatorChar, '/');
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if (!file.isFile()) {
            name = name + "/";
        }
        try {
            return new URL("file", "", name);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("file");
        }
    }

    static {
        NashornLoader.SCRIPT_PERMISSIONS[0] = new RuntimePermission("accessClassInPackage.jdk.nashorn.internal.runtime");
        NashornLoader.SCRIPT_PERMISSIONS[1] = new RuntimePermission("accessClassInPackage.jdk.nashorn.internal.runtime.linker");
        NashornLoader.SCRIPT_PERMISSIONS[2] = new RuntimePermission("accessClassInPackage.jdk.nashorn.internal.objects");
        NashornLoader.SCRIPT_PERMISSIONS[3] = new RuntimePermission("accessClassInPackage.jdk.nashorn.internal.scripts");
    }
}

