/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import jdk.nashorn.internal.codegen.Compiler;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.FunctionSignature;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.lookup.Lookup;
import jdk.nashorn.internal.parser.Token;
import jdk.nashorn.internal.parser.TokenType;
import jdk.nashorn.internal.runtime.CodeInstaller;
import jdk.nashorn.internal.runtime.CompiledFunction;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.Debug;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptEnvironment;
import jdk.nashorn.internal.runtime.ScriptFunctionData;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.Source;
import jdk.nashorn.internal.runtime.Undefined;

public final class RecompilableScriptFunctionData
extends ScriptFunctionData {
    private FunctionNode functionNode;
    private final PropertyMap allocatorMap;
    private final CodeInstaller<ScriptEnvironment> installer;
    private final String allocatorClassName;
    private MethodHandle allocator;
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final MethodHandle PARAM_TYPE_GUARD = RecompilableScriptFunctionData.findOwnMH("paramTypeGuard", Boolean.TYPE, Type[].class, Object[].class);
    private static final MethodHandle ENSURE_INT = RecompilableScriptFunctionData.findOwnMH("ensureInt", Integer.TYPE, Object.class);

    public RecompilableScriptFunctionData(FunctionNode functionNode, CodeInstaller<ScriptEnvironment> installer, String allocatorClassName, PropertyMap allocatorMap) {
        super(functionNode.isAnonymous() ? "" : functionNode.getIdent().getName(), functionNode.getParameters().size(), functionNode.isStrict(), false, true);
        this.functionNode = functionNode;
        this.installer = installer;
        this.allocatorClassName = allocatorClassName;
        this.allocatorMap = allocatorMap;
    }

    @Override
    String toSource() {
        Source source = this.functionNode.getSource();
        long token = RecompilableScriptFunctionData.tokenFor(this.functionNode);
        if (source != null && token != 0L) {
            return source.getString(Token.descPosition(token), Token.descLength(token));
        }
        return "function " + (this.name == null ? "" : this.name) + "() { [native code] }";
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        Source source = this.functionNode.getSource();
        long token = RecompilableScriptFunctionData.tokenFor(this.functionNode);
        if (source != null) {
            sb.append(source.getName()).append(':').append(source.getLine(Token.descPosition(token))).append(' ');
        }
        return sb.toString() + super.toString();
    }

    private static long tokenFor(FunctionNode fn) {
        int position = Token.descPosition(fn.getFirstToken());
        int length = Token.descPosition(fn.getLastToken()) - position + Token.descLength(fn.getLastToken());
        return Token.toDesc(TokenType.FUNCTION, position, length);
    }

    @Override
    ScriptObject allocate() {
        try {
            this.ensureHasAllocator();
            return this.allocator == null ? null : this.allocator.invokeExact(this.allocatorMap);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private void ensureHasAllocator() throws ClassNotFoundException {
        if (this.allocator == null && this.allocatorClassName != null) {
            this.allocator = Lookup.MH.findStatic(LOOKUP, Context.forStructureClass(this.allocatorClassName), CompilerConstants.ALLOCATE.symbolName(), Lookup.MH.type(ScriptObject.class, PropertyMap.class));
        }
    }

    @Override
    protected void ensureCodeGenerated() {
        if (!this.code.isEmpty()) {
            return;
        }
        if (this.functionNode.isLazy()) {
            Compiler.LOG.info("Trampoline hit: need to do lazy compilation of '", this.functionNode.getName(), "'");
            Compiler compiler = new Compiler(this.installer);
            this.functionNode = compiler.compile(this.functionNode);
            assert (!this.functionNode.isLazy());
            compiler.install(this.functionNode);
        }
        assert (this.functionNode.hasState(FunctionNode.CompilationState.EMITTED)) : this.functionNode.getName() + " " + this.functionNode.getState() + " " + Debug.id(this.functionNode);
        this.addCode(this.functionNode);
    }

    private MethodHandle addCode(FunctionNode fn) {
        return this.addCode(fn, null, null, null);
    }

    private MethodHandle addCode(FunctionNode fn, MethodType runtimeType, MethodHandle guard, MethodHandle fallback) {
        MethodType targetType = new FunctionSignature(fn).getMethodType();
        MethodHandle target = Lookup.MH.findStatic(LOOKUP, fn.getCompileUnit().getCode(), fn.getName(), targetType);
        for (int i = 0; i < targetType.parameterCount(); ++i) {
            if (targetType.parameterType(i) != Integer.TYPE) continue;
            target = Lookup.MH.filterArguments(target, i, ENSURE_INT);
        }
        MethodHandle mh = target;
        if (guard != null) {
            mh = Lookup.MH.guardWithTest(Lookup.MH.asCollector(guard, Object[].class, target.type().parameterCount()), Lookup.MH.asType(target, fallback.type()), fallback);
        }
        CompiledFunction cf = new CompiledFunction(runtimeType == null ? targetType : runtimeType, mh);
        this.code.add(cf);
        return cf.getInvoker();
    }

    private static Type runtimeType(Object arg) {
        if (arg == null) {
            return Type.OBJECT;
        }
        Class<?> clazz = arg.getClass();
        assert (!clazz.isPrimitive()) : "always boxed";
        if (clazz == Double.class) {
            return JSType.isRepresentableAsInt((Double)arg) ? Type.INT : Type.NUMBER;
        }
        if (clazz == Integer.class) {
            return Type.INT;
        }
        if (clazz == Long.class) {
            return Type.LONG;
        }
        if (clazz == String.class) {
            return Type.STRING;
        }
        return Type.OBJECT;
    }

    private static boolean canCoerce(Object arg, Type type) {
        Type argType = RecompilableScriptFunctionData.runtimeType(arg);
        if (Type.widest(argType, type) == type || arg == ScriptRuntime.UNDEFINED) {
            return true;
        }
        System.err.println(arg + " does not fit in " + argType + " " + type + " " + arg.getClass());
        new Throwable().printStackTrace();
        return false;
    }

    private static boolean paramTypeGuard(Type[] paramTypes, Object ... args) {
        int start;
        int length = args.length;
        assert (args.length >= paramTypes.length);
        for (int i = start = args.length - paramTypes.length; i < args.length; ++i) {
            Object arg = args[i];
            if (RecompilableScriptFunctionData.canCoerce(arg, paramTypes[i - start])) continue;
            return false;
        }
        return true;
    }

    private static int ensureInt(Object arg) {
        if (arg instanceof Number) {
            return ((Number)arg).intValue();
        }
        if (arg instanceof Undefined) {
            return 0;
        }
        throw new AssertionError(arg);
    }

    private static MethodType runtimeType(MethodType callSiteType, Object[] args) {
        int start;
        if (args == null) {
            return callSiteType;
        }
        Class[] paramTypes = new Class[callSiteType.parameterCount()];
        for (int i = start = args.length - callSiteType.parameterCount(); i < args.length; ++i) {
            paramTypes[i - start] = RecompilableScriptFunctionData.runtimeType(args[i]).getTypeClass();
        }
        return Lookup.MH.type((Class<?>)callSiteType.returnType(), paramTypes);
    }

    private static ArrayList<Type> runtimeType(MethodType mt) {
        ArrayList<Type> type = new ArrayList<Type>();
        for (int i = 0; i < mt.parameterCount(); ++i) {
            type.add(Type.typeFor(mt.parameterType(i)));
        }
        return type;
    }

    @Override
    MethodHandle getBestInvoker(MethodType callSiteType, Object[] args) {
        int i;
        MethodType runtimeType = RecompilableScriptFunctionData.runtimeType(callSiteType, args);
        assert (runtimeType.parameterCount() == callSiteType.parameterCount());
        MethodHandle mh = super.getBestInvoker(runtimeType, args);
        if (!this.functionNode.canSpecialize()) {
            return mh;
        }
        if (!this.code.isLessSpecificThan(runtimeType)) {
            return mh;
        }
        FunctionNode snapshot = this.functionNode.getSnapshot();
        assert (snapshot != null);
        LinkedList<Type> compileTimeArgs = new LinkedList<Type>();
        for (i = callSiteType.parameterCount() - 1; i >= 0 && compileTimeArgs.size() < snapshot.getParameters().size(); --i) {
            compileTimeArgs.addFirst(Type.typeFor(callSiteType.parameterType(i)));
        }
        MethodHandle guard = null;
        ArrayList<Type> runtimeParamTypes = RecompilableScriptFunctionData.runtimeType(runtimeType);
        while (runtimeParamTypes.size() > this.functionNode.getParameters().size()) {
            runtimeParamTypes.remove(0);
        }
        for (i = 0; i < compileTimeArgs.size(); ++i) {
            Type rparam = Type.typeFor(runtimeType.parameterType(i));
            Type cparam = (Type)compileTimeArgs.get(i);
            if (!cparam.isObject() || rparam.isObject() || guard != null) continue;
            guard = Lookup.MH.insertArguments(PARAM_TYPE_GUARD, 0, new Object[]{runtimeParamTypes.toArray(new Type[runtimeParamTypes.size()])});
        }
        Compiler.LOG.info("Callsite specialized ", this.name, " runtimeType=", runtimeType, " parameters=", snapshot.getParameters(), " args=", Arrays.asList(args));
        assert (snapshot != null);
        assert (snapshot != this.functionNode);
        Compiler compiler = new Compiler(this.installer);
        FunctionNode compiledSnapshot = compiler.compile(snapshot.setHints(null, new Compiler.Hints(runtimeParamTypes.toArray(new Type[runtimeParamTypes.size()]))));
        compiler.install(compiledSnapshot);
        return this.addCode(compiledSnapshot, runtimeType, guard, mh);
    }

    private static MethodHandle findOwnMH(String name, Class<?> rtype, Class<?> ... types) {
        return Lookup.MH.findStatic(MethodHandles.lookup(), RecompilableScriptFunctionData.class, name, Lookup.MH.type(rtype, types));
    }
}

