/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.lookup.Lookup;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.Property;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.linker.Bootstrap;

public final class UserAccessorProperty
extends Property {
    private final int getterSlot;
    private final int setterSlot;
    private static final CompilerConstants.Call USER_ACCESSOR_GETTER = CompilerConstants.staticCall(MethodHandles.lookup(), UserAccessorProperty.class, "userAccessorGetter", Object.class, ScriptObject.class, Integer.TYPE, Object.class);
    private static final CompilerConstants.Call USER_ACCESSOR_SETTER = CompilerConstants.staticCall(MethodHandles.lookup(), UserAccessorProperty.class, "userAccessorSetter", Void.TYPE, ScriptObject.class, Integer.TYPE, String.class, Object.class, Object.class);
    private static final MethodHandle INVOKE_UA_GETTER = Bootstrap.createDynamicInvoker("dyn:call", Object.class, Object.class, Object.class);
    private static final MethodHandle INVOKE_UA_SETTER = Bootstrap.createDynamicInvoker("dyn:call", Void.TYPE, Object.class, Object.class, Object.class);

    public UserAccessorProperty(String key, int flags, int getterSlot, int setterSlot) {
        super(key, flags, -1);
        this.getterSlot = getterSlot;
        this.setterSlot = setterSlot;
    }

    private UserAccessorProperty(UserAccessorProperty property) {
        super(property);
        this.getterSlot = property.getterSlot;
        this.setterSlot = property.setterSlot;
    }

    public int getGetterSlot() {
        return this.getterSlot;
    }

    public int getSetterSlot() {
        return this.setterSlot;
    }

    @Override
    protected Property copy() {
        return new UserAccessorProperty(this);
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        UserAccessorProperty uc = (UserAccessorProperty)other;
        return this.getterSlot == uc.getterSlot && this.setterSlot == uc.setterSlot;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.getterSlot ^ this.setterSlot;
    }

    @Override
    public int getSpillCount() {
        return 2;
    }

    @Override
    public boolean hasGetterFunction(ScriptObject obj) {
        return obj.getSpill(this.getterSlot) != null;
    }

    @Override
    public boolean hasSetterFunction(ScriptObject obj) {
        return obj.getSpill(this.setterSlot) != null;
    }

    @Override
    public Object getObjectValue(ScriptObject self, ScriptObject owner) {
        return UserAccessorProperty.userAccessorGetter(owner, this.getGetterSlot(), self);
    }

    @Override
    public void setObjectValue(ScriptObject self, ScriptObject owner, Object value, boolean strict) {
        UserAccessorProperty.userAccessorSetter(owner, this.getSetterSlot(), strict ? this.getKey() : null, self, value);
    }

    @Override
    public MethodHandle getGetter(Class<?> type) {
        return Lookup.filterReturnType(USER_ACCESSOR_GETTER.methodHandle(), type);
    }

    @Override
    public ScriptFunction getGetterFunction(ScriptObject obj) {
        Object value = obj.getSpill(this.getterSlot);
        return value instanceof ScriptFunction ? (ScriptFunction)value : null;
    }

    @Override
    public MethodHandle getSetter(Class<?> type, PropertyMap currentMap) {
        return USER_ACCESSOR_SETTER.methodHandle();
    }

    @Override
    public ScriptFunction getSetterFunction(ScriptObject obj) {
        Object value = obj.getSpill(this.setterSlot);
        return value instanceof ScriptFunction ? (ScriptFunction)value : null;
    }

    static Object userAccessorGetter(ScriptObject proto, int slot, Object self) {
        ScriptObject container = proto != null ? proto : (ScriptObject)self;
        Object func = container.getSpill(slot);
        if (func instanceof ScriptFunction) {
            try {
                return INVOKE_UA_GETTER.invokeExact(func, self);
            }
            catch (Error | RuntimeException t) {
                throw t;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        return ScriptRuntime.UNDEFINED;
    }

    static void userAccessorSetter(ScriptObject proto, int slot, String name, Object self, Object value) {
        ScriptObject container = proto != null ? proto : (ScriptObject)self;
        Object func = container.getSpill(slot);
        if (func instanceof ScriptFunction) {
            try {
                INVOKE_UA_SETTER.invokeExact(func, self, value);
            }
            catch (Error | RuntimeException t) {
                throw t;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        } else if (name != null) {
            throw ECMAErrors.typeError("property.has.no.setter", name, ScriptRuntime.safeToString(self));
        }
    }
}

