/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.arrays;

import java.util.Iterator;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.arrays.ArrayIterator;
import jdk.nashorn.internal.runtime.arrays.EmptyArrayLikeIterator;
import jdk.nashorn.internal.runtime.arrays.MapIterator;
import jdk.nashorn.internal.runtime.arrays.ReverseArrayIterator;
import jdk.nashorn.internal.runtime.arrays.ReverseMapIterator;
import jdk.nashorn.internal.runtime.arrays.ReverseScriptObjectMirrorIterator;
import jdk.nashorn.internal.runtime.arrays.ScriptObjectMirrorIterator;

public abstract class ArrayLikeIterator<T>
implements Iterator<T> {
    protected long index;
    protected final boolean includeUndefined;

    protected ArrayLikeIterator(boolean includeUndefined) {
        this.includeUndefined = includeUndefined;
        this.index = 0L;
    }

    public boolean isReverse() {
        return false;
    }

    protected long bumpIndex() {
        return this.index++;
    }

    public long nextIndex() {
        return this.index;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public abstract long getLength();

    public static ArrayLikeIterator<Object> arrayLikeIterator(Object object) {
        return ArrayLikeIterator.arrayLikeIterator(object, false);
    }

    public static ArrayLikeIterator<Object> reverseArrayLikeIterator(Object object) {
        return ArrayLikeIterator.reverseArrayLikeIterator(object, false);
    }

    public static ArrayLikeIterator<Object> arrayLikeIterator(Object object, boolean includeUndefined) {
        Object obj = object;
        if (ScriptObject.isArray(obj)) {
            return new ArrayIterator((ScriptObject)obj, includeUndefined);
        }
        if ((obj = JSType.toScriptObject(obj)) instanceof ScriptObject) {
            return new MapIterator((ScriptObject)obj, includeUndefined);
        }
        if (obj instanceof ScriptObjectMirror) {
            return new ScriptObjectMirrorIterator((ScriptObjectMirror)obj, includeUndefined);
        }
        return new EmptyArrayLikeIterator();
    }

    public static ArrayLikeIterator<Object> reverseArrayLikeIterator(Object object, boolean includeUndefined) {
        Object obj = object;
        if (ScriptObject.isArray(obj)) {
            return new ReverseArrayIterator((ScriptObject)obj, includeUndefined);
        }
        if ((obj = JSType.toScriptObject(obj)) instanceof ScriptObject) {
            return new ReverseMapIterator((ScriptObject)obj, includeUndefined);
        }
        if (obj instanceof ScriptObjectMirror) {
            return new ReverseScriptObjectMirrorIterator((ScriptObjectMirror)obj, includeUndefined);
        }
        assert (!obj.getClass().isArray());
        return new EmptyArrayLikeIterator();
    }
}

