/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.arrays;

import java.util.Arrays;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.arrays.ArrayData;
import jdk.nashorn.internal.runtime.arrays.DeletedRangeArrayFilter;
import jdk.nashorn.internal.runtime.arrays.SparseArrayData;
import jdk.nashorn.internal.runtime.arrays.UndefinedArrayFilter;

final class ObjectArrayData
extends ArrayData {
    private Object[] array;

    ObjectArrayData(Object[] array, int length) {
        super(length);
        this.array = array;
        if (array.length > length) {
            Arrays.fill(array, length, array.length, ScriptRuntime.UNDEFINED);
        }
    }

    @Override
    public Object[] asObjectArray() {
        return Arrays.copyOf(this.array, (int)this.length());
    }

    @Override
    public ArrayData convert(Class<?> type) {
        return this;
    }

    @Override
    public void shiftLeft(int by) {
        System.arraycopy(this.array, by, this.array, 0, this.array.length - by);
    }

    @Override
    public ArrayData shiftRight(int by) {
        ArrayData newData = this.ensure((long)by + this.length() - 1L);
        if (newData != this) {
            newData.shiftRight(by);
            return newData;
        }
        System.arraycopy(this.array, 0, this.array, by, this.array.length - by);
        return this;
    }

    @Override
    public ArrayData ensure(long safeIndex) {
        if (safeIndex >= 524288L && safeIndex >= (long)this.array.length) {
            return new SparseArrayData(this, safeIndex + 1L);
        }
        int newLength = this.array.length;
        while ((long)newLength <= safeIndex) {
            newLength = ArrayData.nextSize(newLength);
        }
        if ((long)this.array.length <= safeIndex) {
            this.array = Arrays.copyOf(this.array, newLength);
            Arrays.fill(this.array, (int)this.length(), newLength, ScriptRuntime.UNDEFINED);
        }
        this.setLength(safeIndex + 1L);
        return this;
    }

    @Override
    public ArrayData shrink(long newLength) {
        Arrays.fill(this.array, (int)newLength, this.array.length, ScriptRuntime.UNDEFINED);
        return this;
    }

    @Override
    public ArrayData set(int index, Object value, boolean strict) {
        if (value == ScriptRuntime.UNDEFINED) {
            return new UndefinedArrayFilter(this).set(index, value, strict);
        }
        this.array[index] = value;
        this.setLength(Math.max((long)(index + 1), this.length()));
        return this;
    }

    @Override
    public ArrayData set(int index, int value, boolean strict) {
        this.array[index] = value;
        this.setLength(Math.max((long)(index + 1), this.length()));
        return this;
    }

    @Override
    public ArrayData set(int index, long value, boolean strict) {
        this.array[index] = value;
        this.setLength(Math.max((long)(index + 1), this.length()));
        return this;
    }

    @Override
    public ArrayData set(int index, double value, boolean strict) {
        this.array[index] = value;
        this.setLength(Math.max((long)(index + 1), this.length()));
        return this;
    }

    @Override
    public ArrayData setEmpty(int index) {
        this.array[index] = ScriptRuntime.EMPTY;
        return this;
    }

    @Override
    public ArrayData setEmpty(long lo, long hi) {
        Arrays.fill(this.array, (int)Math.max(lo, 0L), (int)Math.min(hi, Integer.MAX_VALUE), ScriptRuntime.EMPTY);
        return this;
    }

    @Override
    public int getInt(int index) {
        return JSType.toInt32(this.array[index]);
    }

    @Override
    public long getLong(int index) {
        return JSType.toLong(this.array[index]);
    }

    @Override
    public double getDouble(int index) {
        return JSType.toNumber(this.array[index]);
    }

    @Override
    public Object getObject(int index) {
        return this.array[index];
    }

    @Override
    public boolean has(int index) {
        return 0 <= index && (long)index < this.length();
    }

    @Override
    public ArrayData delete(int index) {
        this.setEmpty(index);
        return new DeletedRangeArrayFilter(this, index, index);
    }

    @Override
    public ArrayData delete(long fromIndex, long toIndex) {
        this.setEmpty(fromIndex, toIndex);
        return new DeletedRangeArrayFilter(this, fromIndex, toIndex);
    }

    @Override
    public Object pop() {
        if (this.length() == 0L) {
            return ScriptRuntime.UNDEFINED;
        }
        int newLength = (int)(this.length() - 1L);
        Object elem = this.array[newLength];
        this.setEmpty(newLength);
        this.setLength(newLength);
        return elem;
    }

    @Override
    public ArrayData slice(long from, long to) {
        long start = from < 0L ? from + this.length() : from;
        long newLength = to - start;
        return new ObjectArrayData(Arrays.copyOfRange(this.array, (int)from, (int)to), (int)newLength);
    }
}

