/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.linker;

import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import jdk.internal.dynalink.beans.StaticClass;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.Type;
import jdk.internal.org.objectweb.asm.commons.InstructionAdapter;
import jdk.nashorn.internal.runtime.linker.JavaAdapterGeneratorBase;

class JavaAdapterClassLoader
extends JavaAdapterGeneratorBase {
    private static final Type PRIVILEGED_ACTION_TYPE = Type.getType(PrivilegedAction.class);
    private static final String PRIVILEGED_ACTION_TYPE_NAME = PRIVILEGED_ACTION_TYPE.getInternalName();
    private static final String PRIVILEGED_RUN_METHOD_DESCRIPTOR = Type.getMethodDescriptor(OBJECT_TYPE, new Type[0]);
    private static final ProtectionDomain GENERATED_PROTECTION_DOMAIN = JavaAdapterClassLoader.createGeneratedProtectionDomain();
    private final String className;
    private final byte[] classBytes;
    private final String globalSetterClassName;

    JavaAdapterClassLoader(String className, byte[] classBytes, String globalSetterClassName) {
        this.className = className.replace('/', '.');
        this.classBytes = classBytes;
        this.globalSetterClassName = globalSetterClassName.replace('/', '.');
    }

    StaticClass generateClass(final ClassLoader parentLoader) {
        return AccessController.doPrivileged(new PrivilegedAction<StaticClass>(){

            @Override
            public StaticClass run() {
                try {
                    return StaticClass.forClass(Class.forName(JavaAdapterClassLoader.this.className, true, JavaAdapterClassLoader.this.createClassLoader(parentLoader)));
                }
                catch (ClassNotFoundException e) {
                    throw new AssertionError((Object)e);
                }
            }
        });
    }

    static boolean isAdapterClass(Class<?> clazz) {
        return clazz.getClassLoader() instanceof AdapterLoader;
    }

    private ClassLoader createClassLoader(ClassLoader parentLoader) {
        return new AdapterLoader(parentLoader){
            private final ClassLoader myLoader;
            private final ProtectionDomain myProtectionDomain;
            {
                this.myLoader = this.getClass().getClassLoader();
                this.myProtectionDomain = this.getClass().getProtectionDomain();
            }

            @Override
            public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                try {
                    return super.loadClass(name, resolve);
                }
                catch (SecurityException se) {
                    if (name.startsWith("jdk.nashorn.internal.")) {
                        return this.myLoader.loadClass(name);
                    }
                    throw se;
                }
            }

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                if (name.equals(JavaAdapterClassLoader.this.className)) {
                    return this.defineClass(name, JavaAdapterClassLoader.this.classBytes, 0, JavaAdapterClassLoader.this.classBytes.length, GENERATED_PROTECTION_DOMAIN);
                }
                if (name.equals(JavaAdapterClassLoader.this.globalSetterClassName)) {
                    byte[] bytes = JavaAdapterClassLoader.generatePrivilegedActionClassBytes(JavaAdapterClassLoader.this.globalSetterClassName.replace('.', '/'));
                    return this.defineClass(name, bytes, 0, bytes.length, this.myProtectionDomain);
                }
                throw new ClassNotFoundException(name);
            }
        };
    }

    private static ProtectionDomain createGeneratedProtectionDomain() {
        Permissions permissions = new Permissions();
        permissions.add(new AllPermission());
        return new ProtectionDomain(new CodeSource(null, (CodeSigner[])null), permissions);
    }

    private static byte[] generatePrivilegedActionClassBytes(String className) {
        ClassWriter w = new ClassWriter(3);
        w.visit(51, 48, className, null, OBJECT_TYPE_NAME, new String[]{PRIVILEGED_ACTION_TYPE_NAME});
        w.visitField(18, "global", SCRIPT_OBJECT_TYPE_DESCRIPTOR, null, null).visitEnd();
        InstructionAdapter mv = new InstructionAdapter(w.visitMethod(2, "<init>", SET_GLOBAL_METHOD_DESCRIPTOR, null, new String[0]));
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.invokespecial(OBJECT_TYPE_NAME, "<init>", VOID_NOARG_METHOD_DESCRIPTOR);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.putfield(className, "global", SCRIPT_OBJECT_TYPE_DESCRIPTOR);
        mv.visitInsn(177);
        mv.visitEnd();
        mv.visitMaxs(0, 0);
        mv = new InstructionAdapter(w.visitMethod(1, "run", PRIVILEGED_RUN_METHOD_DESCRIPTOR, null, new String[0]));
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.getfield(className, "global", SCRIPT_OBJECT_TYPE_DESCRIPTOR);
        mv.invokestatic(CONTEXT_TYPE_NAME, "setGlobal", SET_GLOBAL_METHOD_DESCRIPTOR);
        mv.visitInsn(1);
        mv.visitInsn(176);
        mv.visitEnd();
        mv.visitMaxs(0, 0);
        mv = new InstructionAdapter(w.visitMethod(8, "setGlobal", SET_GLOBAL_METHOD_DESCRIPTOR, null, new String[0]));
        mv.visitCode();
        mv.anew(Type.getType("L" + className + ";"));
        mv.dup();
        mv.visitVarInsn(25, 0);
        mv.invokespecial(className, "<init>", SET_GLOBAL_METHOD_DESCRIPTOR);
        mv.invokestatic(Type.getInternalName(AccessController.class), "doPrivileged", Type.getMethodDescriptor(OBJECT_TYPE, PRIVILEGED_ACTION_TYPE));
        mv.pop();
        mv.visitInsn(177);
        mv.visitEnd();
        mv.visitMaxs(0, 0);
        return w.toByteArray();
    }

    private static class AdapterLoader
    extends SecureClassLoader {
        AdapterLoader(ClassLoader parent) {
            super(parent);
        }
    }
}

