/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.linker;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdk.internal.dynalink.beans.StaticClass;
import jdk.internal.dynalink.support.LinkRequestImpl;
import jdk.nashorn.internal.lookup.Lookup;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.linker.AdaptationException;
import jdk.nashorn.internal.runtime.linker.AdaptationResult;
import jdk.nashorn.internal.runtime.linker.Bootstrap;
import jdk.nashorn.internal.runtime.linker.ClassAndLoader;
import jdk.nashorn.internal.runtime.linker.JavaAdapterBytecodeGenerator;
import jdk.nashorn.internal.runtime.linker.JavaAdapterClassLoader;
import jdk.nashorn.internal.runtime.linker.JavaAdapterServices;
import jdk.nashorn.internal.runtime.linker.NashornCallSiteDescriptor;

public final class JavaAdapterFactory {
    private static final ClassValue<Map<List<Class<?>>, AdapterInfo>> ADAPTER_INFO_MAPS = new ClassValue<Map<List<Class<?>>, AdapterInfo>>(){

        @Override
        protected Map<List<Class<?>>, AdapterInfo> computeValue(Class<?> type) {
            return new HashMap();
        }
    };

    public static StaticClass getAdapterClassFor(Class<?>[] types, ScriptObject classOverrides) {
        assert (types != null && types.length > 0);
        return JavaAdapterFactory.getAdapterInfo(types).getAdapterClassFor(classOverrides);
    }

    public static MethodHandle getConstructor(final Class<?> sourceType, final Class<?> targetType) throws Exception {
        final StaticClass adapterClass = JavaAdapterFactory.getAdapterClassFor(new Class[]{targetType}, null);
        return AccessController.doPrivileged(new PrivilegedExceptionAction<MethodHandle>(){

            @Override
            public MethodHandle run() throws Exception {
                return Lookup.MH.bindTo(Bootstrap.getLinkerServices().getGuardedInvocation(new LinkRequestImpl(NashornCallSiteDescriptor.get(MethodHandles.publicLookup(), "dyn:new", MethodType.methodType(targetType, StaticClass.class, sourceType), 0), false, adapterClass, null)).getInvocation(), adapterClass);
            }
        });
    }

    public static boolean isAdapterClass(Class<?> clazz) {
        return JavaAdapterClassLoader.isAdapterClass(clazz);
    }

    static boolean isAutoConvertibleFromFunction(Class<?> clazz) {
        return JavaAdapterFactory.getAdapterInfo(new Class[]{clazz}).autoConvertibleFromFunction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AdapterInfo getAdapterInfo(Class<?>[] types) {
        AdapterInfo adapterInfo;
        ClassAndLoader definingClassAndLoader = ClassAndLoader.getDefiningClassAndLoader(types);
        Map<List<Class<?>>, AdapterInfo> adapterInfoMap = ADAPTER_INFO_MAPS.get(definingClassAndLoader.getRepresentativeClass());
        List<Object> typeList = types.length == 1 ? JavaAdapterFactory.getSingletonClassList(types[0]) : Arrays.asList((Object[])types.clone());
        Map<List<Class<?>>, AdapterInfo> map = adapterInfoMap;
        synchronized (map) {
            adapterInfo = adapterInfoMap.get(typeList);
            if (adapterInfo == null) {
                adapterInfo = JavaAdapterFactory.createAdapterInfo(types, definingClassAndLoader);
                adapterInfoMap.put(typeList, adapterInfo);
            }
        }
        return adapterInfo;
    }

    private static List<Class<?>> getSingletonClassList(Class<?> clazz) {
        return Collections.singletonList(clazz);
    }

    private static AdapterInfo createAdapterInfo(Class<?>[] types, final ClassAndLoader definingClassAndLoader) {
        Class<?> superClass = null;
        final ArrayList interfaces = new ArrayList(types.length);
        for (Class<?> t : types) {
            int mod = t.getModifiers();
            if (!t.isInterface()) {
                if (superClass != null) {
                    return new AdapterInfo(AdaptationResult.Outcome.ERROR_MULTIPLE_SUPERCLASSES, t.getCanonicalName() + " and " + superClass.getCanonicalName());
                }
                if (Modifier.isFinal(mod)) {
                    return new AdapterInfo(AdaptationResult.Outcome.ERROR_FINAL_CLASS, t.getCanonicalName());
                }
                superClass = t;
            } else {
                interfaces.add(t);
            }
            if (Modifier.isPublic(mod)) continue;
            return new AdapterInfo(AdaptationResult.Outcome.ERROR_NON_PUBLIC_CLASS, t.getCanonicalName());
        }
        final Class effectiveSuperClass = superClass == null ? Object.class : superClass;
        return AccessController.doPrivileged(new PrivilegedAction<AdapterInfo>(){

            @Override
            public AdapterInfo run() {
                try {
                    return new AdapterInfo(effectiveSuperClass, interfaces, definingClassAndLoader);
                }
                catch (AdaptationException e) {
                    return new AdapterInfo(e.getAdaptationResult());
                }
            }
        });
    }

    private static class AdapterInfo {
        private static final ClassAndLoader SCRIPT_OBJECT_LOADER = new ClassAndLoader(ScriptObject.class, true);
        private final ClassLoader commonLoader;
        private final JavaAdapterClassLoader adapterGenerator;
        final StaticClass instanceAdapterClass;
        final boolean autoConvertibleFromFunction;
        final AdaptationResult adaptationResult;

        AdapterInfo(Class<?> superClass, List<Class<?>> interfaces, ClassAndLoader definingLoader) throws AdaptationException {
            this.commonLoader = AdapterInfo.findCommonLoader(definingLoader);
            JavaAdapterBytecodeGenerator gen = new JavaAdapterBytecodeGenerator(superClass, interfaces, this.commonLoader, false);
            this.autoConvertibleFromFunction = gen.isAutoConvertibleFromFunction();
            this.instanceAdapterClass = gen.createAdapterClassLoader().generateClass(this.commonLoader);
            this.adapterGenerator = new JavaAdapterBytecodeGenerator(superClass, interfaces, this.commonLoader, true).createAdapterClassLoader();
            this.adaptationResult = AdaptationResult.SUCCESSFUL_RESULT;
        }

        AdapterInfo(AdaptationResult.Outcome outcome, String classList) {
            this(new AdaptationResult(outcome, classList));
        }

        AdapterInfo(AdaptationResult adaptationResult) {
            this.commonLoader = null;
            this.adapterGenerator = null;
            this.instanceAdapterClass = null;
            this.autoConvertibleFromFunction = false;
            this.adaptationResult = adaptationResult;
        }

        StaticClass getAdapterClassFor(ScriptObject classOverrides) {
            if (this.adaptationResult.getOutcome() != AdaptationResult.Outcome.SUCCESS) {
                throw this.adaptationResult.typeError();
            }
            if (classOverrides == null) {
                return this.instanceAdapterClass;
            }
            JavaAdapterServices.setClassOverrides(classOverrides);
            try {
                StaticClass staticClass = this.adapterGenerator.generateClass(this.commonLoader);
                return staticClass;
            }
            finally {
                JavaAdapterServices.setClassOverrides(null);
            }
        }

        private static ClassLoader findCommonLoader(ClassAndLoader classAndLoader) throws AdaptationException {
            if (classAndLoader.canSee(SCRIPT_OBJECT_LOADER)) {
                return classAndLoader.getLoader();
            }
            if (SCRIPT_OBJECT_LOADER.canSee(classAndLoader)) {
                return SCRIPT_OBJECT_LOADER.getLoader();
            }
            throw new AdaptationException(AdaptationResult.Outcome.ERROR_NO_COMMON_LOADER, classAndLoader.getRepresentativeClass().getCanonicalName());
        }
    }
}

