/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.APersistentMap;
import clojure.lang.ASeq;
import clojure.lang.IFn;
import clojure.lang.IMapEntry;
import clojure.lang.IObj;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.MapEntry;
import clojure.lang.Obj;
import clojure.lang.PersistentHashMap;
import clojure.lang.RT;
import clojure.lang.SeqIterator;
import clojure.lang.Util;
import java.io.Serializable;
import java.util.Iterator;

public class PersistentStructMap
extends APersistentMap
implements IObj {
    final Def def;
    final Object[] vals;
    final IPersistentMap ext;
    final IPersistentMap _meta;

    public static Def createSlotMap(ISeq keys2) {
        if (keys2 == null) {
            throw new IllegalArgumentException("Must supply keys");
        }
        int c = RT.count(keys2);
        Object[] v = new Object[2 * c];
        int i = 0;
        ISeq s = keys2;
        while (s != null) {
            v[2 * i] = s.first();
            v[2 * i + 1] = i;
            s = s.next();
            ++i;
        }
        return new Def(keys2, RT.map(v));
    }

    public static PersistentStructMap create(Def def, ISeq keyvals) {
        Object[] vals2 = new Object[def.keyslots.count()];
        IPersistentMap ext = PersistentHashMap.EMPTY;
        while (keyvals != null) {
            if (keyvals.next() == null) {
                throw new IllegalArgumentException(String.format("No value supplied for key: %s", keyvals.first()));
            }
            Object k = keyvals.first();
            Object v = RT.second(keyvals);
            IMapEntry e = def.keyslots.entryAt(k);
            if (e != null) {
                vals2[((Integer)e.getValue()).intValue()] = v;
            } else {
                ext = ext.assoc(k, v);
            }
            keyvals = keyvals.next().next();
        }
        return new PersistentStructMap(null, def, vals2, ext);
    }

    public static PersistentStructMap construct(Def def, ISeq valseq) {
        Object[] vals2 = new Object[def.keyslots.count()];
        PersistentHashMap ext = PersistentHashMap.EMPTY;
        for (int i = 0; i < vals2.length && valseq != null; valseq = valseq.next(), ++i) {
            vals2[i] = valseq.first();
        }
        if (valseq != null) {
            throw new IllegalArgumentException("Too many arguments to struct constructor");
        }
        return new PersistentStructMap(null, def, vals2, ext);
    }

    public static IFn getAccessor(final Def def, Object key2) {
        IMapEntry e = def.keyslots.entryAt(key2);
        if (e != null) {
            final int i = (Integer)e.getValue();
            return new AFn(){

                @Override
                public Object invoke(Object arg1) {
                    PersistentStructMap m = (PersistentStructMap)arg1;
                    if (m.def != def) {
                        throw Util.runtimeException("Accessor/struct mismatch");
                    }
                    return m.vals[i];
                }
            };
        }
        throw new IllegalArgumentException("Not a key of struct");
    }

    protected PersistentStructMap(IPersistentMap meta2, Def def, Object[] vals2, IPersistentMap ext) {
        this._meta = meta2;
        this.ext = ext;
        this.def = def;
        this.vals = vals2;
    }

    protected PersistentStructMap makeNew(IPersistentMap meta2, Def def, Object[] vals2, IPersistentMap ext) {
        return new PersistentStructMap(meta2, def, vals2, ext);
    }

    @Override
    public IObj withMeta(IPersistentMap meta2) {
        if (meta2 == this._meta) {
            return this;
        }
        return this.makeNew(meta2, this.def, this.vals, this.ext);
    }

    @Override
    public IPersistentMap meta() {
        return this._meta;
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.def.keyslots.containsKey(key2) || this.ext.containsKey(key2);
    }

    @Override
    public IMapEntry entryAt(Object key2) {
        IMapEntry e = this.def.keyslots.entryAt(key2);
        if (e != null) {
            return new MapEntry(e.getKey(), this.vals[(Integer)e.getValue()]);
        }
        return this.ext.entryAt(key2);
    }

    @Override
    public IPersistentMap assoc(Object key2, Object val2) {
        IMapEntry e = this.def.keyslots.entryAt(key2);
        if (e != null) {
            int i = (Integer)e.getValue();
            Object[] newVals = (Object[])this.vals.clone();
            newVals[i] = val2;
            return this.makeNew(this._meta, this.def, newVals, this.ext);
        }
        return this.makeNew(this._meta, this.def, this.vals, this.ext.assoc(key2, val2));
    }

    @Override
    public Object valAt(Object key2) {
        Integer i = (Integer)this.def.keyslots.valAt(key2);
        if (i != null) {
            return this.vals[i];
        }
        return this.ext.valAt(key2);
    }

    @Override
    public Object valAt(Object key2, Object notFound) {
        Integer i = (Integer)this.def.keyslots.valAt(key2);
        if (i != null) {
            return this.vals[i];
        }
        return this.ext.valAt(key2, notFound);
    }

    @Override
    public IPersistentMap assocEx(Object key2, Object val2) {
        if (this.containsKey(key2)) {
            throw Util.runtimeException("Key already present");
        }
        return this.assoc(key2, val2);
    }

    @Override
    public IPersistentMap without(Object key2) {
        IMapEntry e = this.def.keyslots.entryAt(key2);
        if (e != null) {
            throw Util.runtimeException("Can't remove struct key");
        }
        IPersistentMap newExt = this.ext.without(key2);
        if (newExt == this.ext) {
            return this;
        }
        return this.makeNew(this._meta, this.def, this.vals, newExt);
    }

    public Iterator iterator() {
        return new SeqIterator(this.seq());
    }

    @Override
    public int count() {
        return this.vals.length + RT.count(this.ext);
    }

    @Override
    public ISeq seq() {
        return new Seq(null, this.def.keys, this.vals, 0, this.ext);
    }

    @Override
    public IPersistentCollection empty() {
        return PersistentStructMap.construct(this.def, null);
    }

    static class Seq
    extends ASeq {
        final int i;
        final ISeq keys;
        final Object[] vals;
        final IPersistentMap ext;

        public Seq(IPersistentMap meta2, ISeq keys2, Object[] vals2, int i, IPersistentMap ext) {
            super(meta2);
            this.i = i;
            this.keys = keys2;
            this.vals = vals2;
            this.ext = ext;
        }

        @Override
        public Obj withMeta(IPersistentMap meta2) {
            if (meta2 != this._meta) {
                return new Seq(meta2, this.keys, this.vals, this.i, this.ext);
            }
            return this;
        }

        @Override
        public Object first() {
            return new MapEntry(this.keys.first(), this.vals[this.i]);
        }

        @Override
        public ISeq next() {
            if (this.i + 1 < this.vals.length) {
                return new Seq(this._meta, this.keys.next(), this.vals, this.i + 1, this.ext);
            }
            return this.ext.seq();
        }
    }

    public static class Def
    implements Serializable {
        final ISeq keys;
        final IPersistentMap keyslots;

        Def(ISeq keys2, IPersistentMap keyslots) {
            this.keys = keys2;
            this.keyslots = keyslots;
        }
    }
}

