/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AReference;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Var;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class Namespace
extends AReference
implements Serializable {
    public final Symbol name;
    final transient AtomicReference<IPersistentMap> mappings = new AtomicReference();
    final transient AtomicReference<IPersistentMap> aliases = new AtomicReference();
    static final ConcurrentHashMap<Symbol, Namespace> namespaces = new ConcurrentHashMap();

    public String toString() {
        return this.name.toString();
    }

    Namespace(Symbol name2) {
        super(name2.meta());
        this.name = name2;
        this.mappings.set(RT.DEFAULT_IMPORTS);
        this.aliases.set(RT.map(new Object[0]));
    }

    public static ISeq all() {
        return RT.seq(namespaces.values());
    }

    public Symbol getName() {
        return this.name;
    }

    public IPersistentMap getMappings() {
        return this.mappings.get();
    }

    public Var intern(Symbol sym) {
        Object o;
        if (sym.ns != null) {
            throw new IllegalArgumentException("Can't intern namespace-qualified symbol");
        }
        IPersistentMap map2 = this.getMappings();
        Var v = null;
        while ((o = map2.valAt(sym)) == null) {
            if (v == null) {
                v = new Var(this, sym);
            }
            IPersistentMap newMap = map2.assoc(sym, v);
            this.mappings.compareAndSet(map2, newMap);
            map2 = this.getMappings();
        }
        if (o instanceof Var && ((Var)o).ns == this) {
            return (Var)o;
        }
        if (v == null) {
            v = new Var(this, sym);
        }
        this.warnOrFailOnReplace(sym, o, v);
        while (!this.mappings.compareAndSet(map2, map2.assoc(sym, v))) {
            map2 = this.getMappings();
        }
        return v;
    }

    private void warnOrFailOnReplace(Symbol sym, Object o, Object v) {
        if (o instanceof Var) {
            Namespace ns = ((Var)o).ns;
            if (ns == this) {
                return;
            }
            if (ns != RT.CLOJURE_NS) {
                throw new IllegalStateException(sym + " already refers to: " + o + " in namespace: " + this.name);
            }
        }
        RT.errPrintWriter().println("WARNING: " + sym + " already refers to: " + o + " in namespace: " + this.name + ", being replaced by: " + v);
    }

    Object reference(Symbol sym, Object val2) {
        Object o;
        if (sym.ns != null) {
            throw new IllegalArgumentException("Can't intern namespace-qualified symbol");
        }
        IPersistentMap map2 = this.getMappings();
        while ((o = map2.valAt(sym)) == null) {
            IPersistentMap newMap = map2.assoc(sym, val2);
            this.mappings.compareAndSet(map2, newMap);
            map2 = this.getMappings();
        }
        if (o == val2) {
            return o;
        }
        this.warnOrFailOnReplace(sym, o, val2);
        while (!this.mappings.compareAndSet(map2, map2.assoc(sym, val2))) {
            map2 = this.getMappings();
        }
        return val2;
    }

    public static boolean areDifferentInstancesOfSameClassName(Class cls1, Class cls2) {
        return cls1 != cls2 && cls1.getName().equals(cls2.getName());
    }

    Class referenceClass(Symbol sym, Class val2) {
        if (sym.ns != null) {
            throw new IllegalArgumentException("Can't intern namespace-qualified symbol");
        }
        IPersistentMap map2 = this.getMappings();
        Class c = (Class)map2.valAt(sym);
        while (c == null || Namespace.areDifferentInstancesOfSameClassName(c, val2)) {
            IPersistentMap newMap = map2.assoc(sym, val2);
            this.mappings.compareAndSet(map2, newMap);
            map2 = this.getMappings();
            c = (Class)map2.valAt(sym);
        }
        if (c == val2) {
            return c;
        }
        throw new IllegalStateException(sym + " already refers to: " + c + " in namespace: " + this.name);
    }

    public void unmap(Symbol sym) {
        if (sym.ns != null) {
            throw new IllegalArgumentException("Can't unintern namespace-qualified symbol");
        }
        IPersistentMap map2 = this.getMappings();
        while (map2.containsKey(sym)) {
            IPersistentMap newMap = map2.without(sym);
            this.mappings.compareAndSet(map2, newMap);
            map2 = this.getMappings();
        }
    }

    public Class importClass(Symbol sym, Class c) {
        return this.referenceClass(sym, c);
    }

    public Class importClass(Class c) {
        String n = c.getName();
        return this.importClass(Symbol.intern(n.substring(n.lastIndexOf(46) + 1)), c);
    }

    public Var refer(Symbol sym, Var var) {
        return (Var)this.reference(sym, var);
    }

    public static Namespace findOrCreate(Symbol name2) {
        Namespace ns = namespaces.get(name2);
        if (ns != null) {
            return ns;
        }
        Namespace newns = new Namespace(name2);
        ns = namespaces.putIfAbsent(name2, newns);
        return ns == null ? newns : ns;
    }

    public static Namespace remove(Symbol name2) {
        if (name2.equals(RT.CLOJURE_NS.name)) {
            throw new IllegalArgumentException("Cannot remove clojure namespace");
        }
        return namespaces.remove(name2);
    }

    public static Namespace find(Symbol name2) {
        return namespaces.get(name2);
    }

    public Object getMapping(Symbol name2) {
        return this.mappings.get().valAt(name2);
    }

    public Var findInternedVar(Symbol symbol2) {
        Object o = this.mappings.get().valAt(symbol2);
        if (o != null && o instanceof Var && ((Var)o).ns == this) {
            return (Var)o;
        }
        return null;
    }

    public IPersistentMap getAliases() {
        return this.aliases.get();
    }

    public Namespace lookupAlias(Symbol alias2) {
        IPersistentMap map2 = this.getAliases();
        return (Namespace)map2.valAt(alias2);
    }

    public void addAlias(Symbol alias2, Namespace ns) {
        if (alias2 == null || ns == null) {
            throw new NullPointerException("Expecting Symbol + Namespace");
        }
        IPersistentMap map2 = this.getAliases();
        while (!map2.containsKey(alias2)) {
            IPersistentMap newMap = map2.assoc(alias2, ns);
            this.aliases.compareAndSet(map2, newMap);
            map2 = this.getAliases();
        }
        if (!map2.valAt(alias2).equals(ns)) {
            throw new IllegalStateException("Alias " + alias2 + " already exists in namespace " + this.name + ", aliasing " + map2.valAt(alias2));
        }
    }

    public void removeAlias(Symbol alias2) {
        IPersistentMap map2 = this.getAliases();
        while (map2.containsKey(alias2)) {
            IPersistentMap newMap = map2.without(alias2);
            this.aliases.compareAndSet(map2, newMap);
            map2 = this.getAliases();
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return Namespace.findOrCreate(this.name);
    }
}

