;;; Not included due to dependency avoidance.
;;; TODO rewrite to avoid fs, that's pretty doable

(defn list-dir-content
  "Like fs/list-dir, does not include subdirectories"
  [dir]
  (remove #(.isDirectory %)
          (fs/list-dir dir)))

(defn relocate-path
  [path base]
  (fs/with-cwd base
    (fs/absolute path)))


(defn short-names
  "Given s seq, return a set including all names that do NOT include a shorter string"
  [seq]
  (if (empty? seq)
    []
    (let [sorted (sort-by count seq)]
    (reduce (fn [acc elt]
              (if (some (fn [short] (str/includes? elt short)) acc)
                acc
                (conj acc elt)))
            (set [(first sorted)])
            (rest sorted)))))
