/*
 * Decompiled with CFR 0.152.
 */
package com.github.swrirobotics.bags.reader.messages.serialization;

import com.github.swrirobotics.bags.reader.exceptions.UninitializedFieldException;
import com.github.swrirobotics.bags.reader.messages.serialization.Field;
import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Timestamp;
import java.util.List;

public class ArrayType
implements Field {
    private final Field myBaseType;
    private final String myTypeName;
    private final int myLength;
    private final List<Field> myFields = Lists.newArrayList();
    private String myName;
    private ByteBuffer myData = null;

    public ArrayType(Field field, int length) {
        this.myBaseType = field;
        this.myLength = length;
        this.myTypeName = this.myBaseType.getType() + "[" + (this.myLength > 0 ? Integer.valueOf(this.myLength) : "") + "]";
    }

    public List<Field> getFields() throws UninitializedFieldException {
        return this.myFields;
    }

    public void setOrder(ByteOrder order) {
        this.myData = this.myData.order(order);
    }

    public byte[] getAsBytes() {
        byte[] tmp = new byte[this.myData.capacity()];
        this.myData.get(tmp);
        return tmp;
    }

    public short[] getAsShorts() {
        short[] tmp;
        if (this.myTypeName.equals("uint8[]")) {
            tmp = new short[this.myData.capacity()];
            byte[] bytes = new byte[this.myData.capacity()];
            this.myData.get(bytes);
            for (int i = 0; i < bytes.length; ++i) {
                tmp[i] = (short)((short)bytes[i] & 0xFF);
            }
        } else {
            tmp = new short[this.myData.capacity() / 2];
            this.myData.asShortBuffer().get(tmp);
        }
        return tmp;
    }

    public int[] getAsInts() {
        int[] tmp;
        if (this.myTypeName.equals("uint16[]")) {
            tmp = new int[this.myData.capacity() / 2];
            short[] shorts = new short[this.myData.capacity() / 2];
            this.myData.asShortBuffer().get(shorts);
            for (int i = 0; i < shorts.length; ++i) {
                tmp[i] = shorts[i] & 0xFFFF;
            }
        } else {
            tmp = new int[this.myData.capacity() / 4];
            this.myData.asIntBuffer().get(tmp);
        }
        return tmp;
    }

    public long[] getAsLongs() {
        long[] tmp;
        if (this.myTypeName.equals("uint32[]")) {
            tmp = new long[this.myData.capacity() / 4];
            int[] ints = new int[this.myData.capacity() / 4];
            this.myData.asIntBuffer().get(ints);
            for (int i = 0; i < ints.length; ++i) {
                tmp[i] = (long)ints[i] & 0xFFFFFFFFL;
            }
        } else {
            tmp = new long[this.myData.capacity() / 8];
            this.myData.asLongBuffer().get(tmp);
        }
        return tmp;
    }

    public BigInteger[] getAsBigIntegers() {
        BigInteger[] bigints = new BigInteger[this.myData.capacity() / 8];
        byte[] tmp = new byte[8];
        for (int i = 0; i < this.myData.capacity(); i += 8) {
            this.myData.get(tmp);
            bigints[i / 8] = new BigInteger(1, tmp);
        }
        return bigints;
    }

    public float[] getAsFloats() {
        float[] tmp = new float[this.myData.capacity() / 4];
        this.myData.asFloatBuffer().get(tmp);
        return tmp;
    }

    public double[] getAsDoubles() {
        double[] tmp = new double[this.myData.capacity() / 8];
        this.myData.asDoubleBuffer().get(tmp);
        return tmp;
    }

    public double[] getAsDurations() {
        int[] intValues = this.getAsInts();
        double[] durations = new double[intValues.length / 2];
        for (int i = 0; i < intValues.length; i += 2) {
            int secs = intValues[0];
            int nsecs = intValues[1];
            durations[i / 2] = (double)secs + (double)nsecs / 1.0E9;
        }
        return durations;
    }

    public Timestamp[] getAsTimestamps() {
        int[] intValues = this.getAsInts();
        Timestamp[] timestamps = new Timestamp[intValues.length / 2];
        for (int i = 0; i < intValues.length; i += 2) {
            int rawSecs = intValues[0];
            int rawNsecs = intValues[1];
            long secs = rawSecs >= 0 ? (long)rawSecs : 0x100000000L + (long)rawSecs;
            long nsecs = rawNsecs >= 0 ? (long)rawNsecs : 0x100000000L + (long)rawNsecs;
            Timestamp val = new Timestamp(secs * 1000L);
            val.setNanos((int)nsecs);
            timestamps[i / 2] = val;
        }
        return timestamps;
    }

    @Override
    public void readMessage(ByteBuffer buffer) {
        if (!this.myFields.isEmpty()) {
            return;
        }
        int length = this.myLength;
        if (length == 0) {
            length = buffer.getInt();
        }
        switch (this.myBaseType.getType()) {
            case "bool": 
            case "byte": 
            case "char": 
            case "int8": 
            case "uint8": {
                byte[] tempBytes = new byte[length];
                buffer.get(tempBytes);
                this.myData = ByteBuffer.wrap(tempBytes);
                break;
            }
            case "int16": 
            case "uint16": {
                byte[] tempBytes = new byte[length * 2];
                buffer.get(tempBytes);
                this.myData = ByteBuffer.wrap(tempBytes).order(ByteOrder.LITTLE_ENDIAN);
                break;
            }
            case "int32": 
            case "uint32": 
            case "float32": {
                byte[] tempBytes = new byte[length * 4];
                buffer.get(tempBytes);
                this.myData = ByteBuffer.wrap(tempBytes).order(ByteOrder.LITTLE_ENDIAN);
                break;
            }
            case "duration": 
            case "float64": 
            case "int64": 
            case "time": 
            case "uint64": {
                byte[] tempBytes = new byte[length * 8];
                buffer.get(tempBytes);
                this.myData = ByteBuffer.wrap(tempBytes).order(ByteOrder.LITTLE_ENDIAN);
                break;
            }
            default: {
                for (int i = 0; i < length; ++i) {
                    Field instance = this.myBaseType.copy();
                    instance.readMessage(buffer);
                    this.myFields.add(instance);
                }
            }
        }
    }

    @Override
    public void reset() {
        this.myFields.clear();
    }

    @Override
    public String getType() {
        return this.myTypeName;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public Field copy() {
        ArrayType newAt = new ArrayType(this.myBaseType.copy(), this.myLength);
        newAt.setName(this.myName);
        return newAt;
    }

    @Override
    public void setName(String name) {
        this.myName = name;
    }
}

