/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.Associative;
import clojure.lang.Compiler;
import clojure.lang.IFn;
import clojure.lang.IMapEntry;
import clojure.lang.IMeta;
import clojure.lang.IObj;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentList;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentSet;
import clojure.lang.IPersistentVector;
import clojure.lang.IReference;
import clojure.lang.ISeq;
import clojure.lang.Keyword;
import clojure.lang.LazilyPersistentVector;
import clojure.lang.LineNumberingPushbackReader;
import clojure.lang.Namespace;
import clojure.lang.Numbers;
import clojure.lang.PersistentHashMap;
import clojure.lang.PersistentHashSet;
import clojure.lang.PersistentList;
import clojure.lang.PersistentTreeMap;
import clojure.lang.PersistentVector;
import clojure.lang.RT;
import clojure.lang.Reflector;
import clojure.lang.Symbol;
import clojure.lang.Util;
import clojure.lang.Var;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NotTheLispReader {
    static final Symbol QUOTE = Symbol.create((String)"quote");
    static final Symbol THE_VAR = Symbol.create((String)"var");
    static Symbol UNQUOTE = Symbol.create((String)"clojure.core", (String)"unquote");
    static Symbol UNQUOTE_SPLICING = Symbol.create((String)"clojure.core", (String)"unquote-splicing");
    static Symbol CONCAT = Symbol.create((String)"clojure.core", (String)"concat");
    static Symbol SEQ = Symbol.create((String)"clojure.core", (String)"seq");
    static Symbol LIST = Symbol.create((String)"clojure.core", (String)"list");
    static Symbol APPLY = Symbol.create((String)"clojure.core", (String)"apply");
    static Symbol HASHMAP = Symbol.create((String)"clojure.core", (String)"hash-map");
    static Symbol HASHSET = Symbol.create((String)"clojure.core", (String)"hash-set");
    static Symbol VECTOR = Symbol.create((String)"clojure.core", (String)"vector");
    static Symbol WITH_META = Symbol.create((String)"clojure.core", (String)"with-meta");
    static Symbol META = Symbol.create((String)"clojure.core", (String)"meta");
    static Symbol DEREF = Symbol.create((String)"clojure.core", (String)"deref");
    static Symbol CJDDOC = Symbol.create((String)"cjd!doc");
    static IFn[] macros = new IFn[256];
    static IFn[] dispatchMacros = new IFn[256];
    static Pattern symbolPat = Pattern.compile("[:]?([\\D&&[^/]].*/)?([\\D&&[^/]][^/]*)");
    static Pattern intPat = Pattern.compile("([-+]?)(?:(0)|([1-9][0-9]*)|0[xX]([0-9A-Fa-f]+)|0([0-7]+)|([1-9][0-9]?)[rR]([0-9A-Za-z]+)|0[0-9]+)");
    static Pattern ratioPat = Pattern.compile("([-+]?[0-9]+)/([0-9]+)");
    static Pattern floatPat = Pattern.compile("([-+]?[0-9]+(\\.[0-9]*)?([eE][-+]?[0-9]+)?)(M)?");
    static final Symbol SLASH = Symbol.create((String)"/");
    static final Symbol CLOJURE_SLASH = Symbol.create((String)"clojure.core", (String)"/");
    static Var GENSYM_ENV = Var.create(null);
    static Var ARG_ENV = Var.create(null);

    static {
        NotTheLispReader.macros[34] = new StringReader();
        NotTheLispReader.macros[59] = new CommentReader();
        NotTheLispReader.macros[39] = new WrappingReader(QUOTE);
        NotTheLispReader.macros[64] = new WrappingReader(DEREF);
        NotTheLispReader.macros[94] = new MetaReader();
        NotTheLispReader.macros[96] = new SyntaxQuoteReader();
        NotTheLispReader.macros[126] = new UnquoteReader();
        NotTheLispReader.macros[40] = new ListReader();
        NotTheLispReader.macros[41] = new UnmatchedDelimiterReader();
        NotTheLispReader.macros[91] = new VectorReader();
        NotTheLispReader.macros[93] = new UnmatchedDelimiterReader();
        NotTheLispReader.macros[123] = new MapReader();
        NotTheLispReader.macros[125] = new UnmatchedDelimiterReader();
        NotTheLispReader.macros[92] = new CharacterReader();
        NotTheLispReader.macros[37] = new ArgReader();
        NotTheLispReader.macros[35] = new DispatchReader();
        NotTheLispReader.dispatchMacros[94] = new MetaReader();
        NotTheLispReader.dispatchMacros[39] = new VarReader();
        NotTheLispReader.dispatchMacros[34] = new RegexReader();
        NotTheLispReader.dispatchMacros[40] = new FnReader();
        NotTheLispReader.dispatchMacros[123] = new SetReader();
        NotTheLispReader.dispatchMacros[61] = new EvalReader();
        NotTheLispReader.dispatchMacros[33] = new CommentReader();
        NotTheLispReader.dispatchMacros[60] = new UnreadableReader();
        NotTheLispReader.dispatchMacros[95] = new DiscardReader();
    }

    static boolean isWhitespace(int ch) {
        return Character.isWhitespace(ch);
    }

    static void unread(PushbackReader r, int ch) throws IOException {
        if (ch != -1) {
            r.unread(ch);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object read(PushbackReader r, boolean eofIsError, Object eofValue, boolean isRecursive) throws Exception {
        try {
            int ch;
            block14: {
                Object ret;
                do {
                    block13: {
                        ch = r.read();
                        while (true) {
                            if (!NotTheLispReader.isWhitespace(ch)) {
                                if (ch == -1) {
                                    if (!eofIsError) break;
                                    throw new Exception("EOF while reading");
                                }
                                break block13;
                            }
                            ch = r.read();
                        }
                        return eofValue;
                    }
                    if (Character.isDigit(ch)) {
                        Object n = NotTheLispReader.readNumber(r, (char)ch);
                        if (RT.suppressRead()) {
                            return null;
                        }
                        return n;
                    }
                    IFn macroFn = NotTheLispReader.getMacro(ch);
                    if (macroFn == null) break block14;
                    ret = macroFn.invoke((Object)r, (Object)Character.valueOf((char)ch));
                    if (!RT.suppressRead()) continue;
                    return null;
                } while (ret == r);
                return ret;
            }
            if (ch == 43 || ch == 45) {
                int ch2 = r.read();
                if (Character.isDigit(ch2)) {
                    NotTheLispReader.unread(r, ch2);
                    Object n = NotTheLispReader.readNumber(r, (char)ch);
                    if (RT.suppressRead()) {
                        return null;
                    }
                    return n;
                }
                NotTheLispReader.unread(r, ch2);
            }
            String token = NotTheLispReader.readToken(r, (char)ch);
            if (RT.suppressRead()) {
                return null;
            }
            return NotTheLispReader.interpretToken(token);
        }
        catch (Exception e) {
            if (!isRecursive && r instanceof LineNumberingPushbackReader) {
                LineNumberingPushbackReader rdr = (LineNumberingPushbackReader)r;
                throw new ReaderException(rdr.getLineNumber(), (Throwable)e);
            }
            throw e;
        }
    }

    private static String readToken(PushbackReader r, char initch) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(initch);
        while (true) {
            int ch;
            if ((ch = r.read()) == -1 || NotTheLispReader.isWhitespace(ch) || NotTheLispReader.isTerminatingMacro(ch)) {
                NotTheLispReader.unread(r, ch);
                return sb.toString();
            }
            sb.append((char)ch);
        }
    }

    private static Object readNumber(PushbackReader r, char initch) throws Exception {
        int ch;
        StringBuilder sb = new StringBuilder();
        sb.append(initch);
        while (true) {
            if ((ch = r.read()) == -1 || NotTheLispReader.isWhitespace(ch) || NotTheLispReader.isMacro(ch)) break;
            sb.append((char)ch);
        }
        NotTheLispReader.unread(r, ch);
        String s = sb.toString();
        Object n = NotTheLispReader.matchNumber(s);
        if (n == null) {
            throw new NumberFormatException("Invalid number: " + s);
        }
        return n;
    }

    private static int readUnicodeChar(String token, int offset, int length, int base) throws Exception {
        if (token.length() != offset + length) {
            throw new IllegalArgumentException("Invalid unicode character: \\" + token);
        }
        int uc = 0;
        int i = offset;
        while (i < offset + length) {
            int d = Character.digit(token.charAt(i), base);
            if (d == -1) {
                throw new IllegalArgumentException("Invalid digit: " + (char)d);
            }
            uc = uc * base + d;
            ++i;
        }
        return (char)uc;
    }

    private static int readUnicodeChar(PushbackReader r, int initch, int base, int length, boolean exact) throws Exception {
        int uc = Character.digit(initch, base);
        if (uc == -1) {
            throw new IllegalArgumentException("Invalid digit: " + initch);
        }
        int i = 1;
        while (i < length) {
            int ch = r.read();
            if (ch == -1 || NotTheLispReader.isWhitespace(ch) || NotTheLispReader.isMacro(ch)) {
                NotTheLispReader.unread(r, ch);
                break;
            }
            int d = Character.digit(ch, base);
            if (d == -1) {
                throw new IllegalArgumentException("Invalid digit: " + (char)ch);
            }
            uc = uc * base + d;
            ++i;
        }
        if (i != length && exact) {
            throw new IllegalArgumentException("Invalid character length: " + i + ", should be: " + length);
        }
        return uc;
    }

    private static Object interpretToken(String s) throws Exception {
        if (s.equals("/")) {
            return SLASH;
        }
        if (s.equals("clojure.core//")) {
            return CLOJURE_SLASH;
        }
        Object ret = null;
        ret = NotTheLispReader.matchSymbol(s);
        if (ret != null) {
            return ret;
        }
        throw new Exception("Invalid token: " + s);
    }

    private static Object matchSymbol(String s) {
        Matcher m = symbolPat.matcher(s);
        if (m.matches()) {
            int gc = m.groupCount();
            String ns = m.group(1);
            String name = m.group(2);
            if (ns != null && ns.endsWith(":/") || name.endsWith(":") || s.indexOf("::", 1) != -1) {
                return null;
            }
            if (s.startsWith("::")) {
                Symbol ks = Symbol.intern((String)s.substring(2));
                Namespace kns = ks.ns != null ? Compiler.namespaceFor((Symbol)ks) : Compiler.currentNS();
                if (kns != null) {
                    return Keyword.intern((String)kns.name.name, (String)ks.name);
                }
                return null;
            }
            boolean isKeyword = s.charAt(0) == ':';
            Symbol sym = Symbol.intern((String)s.substring(isKeyword ? 1 : 0));
            if (isKeyword) {
                return Keyword.intern((Symbol)sym);
            }
            return sym;
        }
        return null;
    }

    private static Object matchNumber(String s) {
        Matcher m = intPat.matcher(s);
        if (m.matches()) {
            if (m.group(2) != null) {
                return 0;
            }
            boolean negate = m.group(1).equals("-");
            int radix = 10;
            String n = m.group(3);
            if (n != null) {
                radix = 10;
            } else {
                n = m.group(4);
                if (n != null) {
                    radix = 16;
                } else {
                    n = m.group(5);
                    if (n != null) {
                        radix = 8;
                    } else {
                        n = m.group(7);
                        if (n != null) {
                            radix = Integer.parseInt(m.group(6));
                        }
                    }
                }
            }
            if (n == null) {
                return null;
            }
            BigInteger bn = new BigInteger(n, radix);
            return Numbers.reduce((BigInteger)(negate ? bn.negate() : bn));
        }
        m = floatPat.matcher(s);
        if (m.matches()) {
            if (m.group(4) != null) {
                return new BigDecimal(m.group(1));
            }
            return Double.parseDouble(s);
        }
        m = ratioPat.matcher(s);
        if (m.matches()) {
            return Numbers.divide((BigInteger)new BigInteger(m.group(1)), (BigInteger)new BigInteger(m.group(2)));
        }
        return null;
    }

    private static IFn getMacro(int ch) {
        if (ch < macros.length) {
            return macros[ch];
        }
        return null;
    }

    private static boolean isMacro(int ch) {
        return ch < macros.length && macros[ch] != null;
    }

    private static boolean isTerminatingMacro(int ch) {
        return ch != 35 && ch < macros.length && macros[ch] != null;
    }

    static Symbol garg(int n) {
        return Symbol.intern(null, (String)(String.valueOf(n == -1 ? "rest" : "p" + n) + "__" + RT.nextID() + "#"));
    }

    static Symbol registerArg(int n) {
        PersistentTreeMap argsyms = (PersistentTreeMap)ARG_ENV.deref();
        if (argsyms == null) {
            throw new IllegalStateException("arg literal not in #()");
        }
        Symbol ret = (Symbol)argsyms.valAt((Object)n);
        if (ret == null) {
            ret = NotTheLispReader.garg(n);
            ARG_ENV.set((Object)argsyms.assoc((Object)n, (Object)ret));
        }
        return ret;
    }

    static boolean isUnquoteSplicing(Object form) {
        return form instanceof ISeq && Util.equals((Object)RT.first((Object)form), (Object)UNQUOTE_SPLICING);
    }

    static boolean isUnquote(Object form) {
        return form instanceof ISeq && Util.equals((Object)RT.first((Object)form), (Object)UNQUOTE);
    }

    public static List readDelimitedList(char delim, PushbackReader r, boolean isRecursive) throws Exception {
        ArrayList<Object> a = new ArrayList<Object>();
        while (true) {
            int ch = r.read();
            while (NotTheLispReader.isWhitespace(ch)) {
                ch = r.read();
            }
            if (ch == -1) {
                throw new Exception("EOF while reading");
            }
            if (ch == delim) break;
            IFn macroFn = NotTheLispReader.getMacro(ch);
            if (macroFn != null) {
                Object mret = macroFn.invoke((Object)r, (Object)Character.valueOf((char)ch));
                if (mret == r) continue;
                a.add(mret);
                continue;
            }
            NotTheLispReader.unread(r, ch);
            Object o = NotTheLispReader.read(r, true, null, isRecursive);
            if (o == r) continue;
            a.add(o);
        }
        return a;
    }

    static class ArgReader
    extends AFn {
        ArgReader() {
        }

        public Object invoke(Object reader, Object pct) throws Exception {
            PushbackReader r = (PushbackReader)reader;
            if (ARG_ENV.deref() == null) {
                return NotTheLispReader.interpretToken(NotTheLispReader.readToken(r, '%'));
            }
            int ch = r.read();
            NotTheLispReader.unread(r, ch);
            if (ch == -1 || NotTheLispReader.isWhitespace(ch) || NotTheLispReader.isTerminatingMacro(ch)) {
                return NotTheLispReader.registerArg(1);
            }
            Object n = NotTheLispReader.read(r, true, null, true);
            if (n.equals(Compiler._AMP_)) {
                return NotTheLispReader.registerArg(-1);
            }
            if (!(n instanceof Number)) {
                throw new IllegalStateException("arg literal must be %, %& or %integer");
            }
            return NotTheLispReader.registerArg(((Number)n).intValue());
        }
    }

    public static class CharacterReader
    extends AFn {
        public Object invoke(Object reader, Object backslash) throws Exception {
            PushbackReader r = (PushbackReader)reader;
            int ch = r.read();
            if (ch == -1) {
                throw new Exception("EOF while reading character");
            }
            String token = NotTheLispReader.readToken(r, (char)ch);
            if (token.length() == 1) {
                return Character.valueOf(token.charAt(0));
            }
            if (token.equals("newline")) {
                return Character.valueOf('\n');
            }
            if (token.equals("space")) {
                return Character.valueOf(' ');
            }
            if (token.equals("tab")) {
                return Character.valueOf('\t');
            }
            if (token.equals("backspace")) {
                return Character.valueOf('\b');
            }
            if (token.equals("formfeed")) {
                return Character.valueOf('\f');
            }
            if (token.equals("return")) {
                return Character.valueOf('\r');
            }
            if (token.startsWith("u")) {
                char c = (char)NotTheLispReader.readUnicodeChar(token, 1, 4, 16);
                if (c >= '\ud800' && c <= '\udfff') {
                    throw new Exception("Invalid character constant: \\u" + Integer.toString(c, 16));
                }
                return Character.valueOf(c);
            }
            if (token.startsWith("o")) {
                int len = token.length() - 1;
                if (len > 3) {
                    throw new Exception("Invalid octal escape sequence length: " + len);
                }
                int uc = NotTheLispReader.readUnicodeChar(token, 1, len, 8);
                if (uc > 255) {
                    throw new Exception("Octal escape sequence must be in range [0, 377].");
                }
                return Character.valueOf((char)uc);
            }
            throw new Exception("Unsupported character: \\" + token);
        }
    }

    public static class CommentReader
    extends AFn {
        public Object invoke(Object reader, Object semicolon) throws Exception {
            int ch;
            Reader r = (Reader)reader;
            while ((ch = r.read()) != -1 && ch != 10 && ch != 13) {
            }
            return r;
        }
    }

    static class CtorReader
    extends AFn {
        static final Symbol cls = Symbol.create((String)"class");

        CtorReader() {
        }

        public Object invoke(Object reader, Object leftangle) throws Exception {
            PushbackReader r = (PushbackReader)reader;
            List list = NotTheLispReader.readDelimitedList('>', r, true);
            if (list.isEmpty()) {
                throw new Exception("Must supply 'class', classname or classname/staticMethod");
            }
            Symbol s = (Symbol)list.get(0);
            Object[] args = list.subList(1, list.size()).toArray();
            if (s.equals((Object)cls)) {
                return RT.classForName((String)args[0].toString());
            }
            if (s.ns != null) {
                String classname = s.ns;
                String method = s.name;
                return Reflector.invokeStaticMethod((String)classname, (String)method, (Object[])args);
            }
            return Reflector.invokeConstructor((Class)RT.classForName((String)s.name), (Object[])args);
        }
    }

    public static class DeprecatedWrappingReader
    extends AFn {
        final Symbol sym;
        final String macro;

        public DeprecatedWrappingReader(Symbol sym, String macro) {
            this.sym = sym;
            this.macro = macro;
        }

        public Object invoke(Object reader, Object quote) throws Exception {
            System.out.println("WARNING: reader macro " + this.macro + " is deprecated; use " + this.sym.getName() + " instead");
            PushbackReader r = (PushbackReader)reader;
            Object o = NotTheLispReader.read(r, true, null, true);
            return RT.list((Object)this.sym, (Object)o);
        }
    }

    public static class DiscardReader
    extends AFn {
        public Object invoke(Object reader, Object underscore) throws Exception {
            Object o;
            PushbackReader r = (PushbackReader)reader;
            int line = -1;
            if (r instanceof LineNumberingPushbackReader) {
                line = ((LineNumberingPushbackReader)r).getLineNumber();
            }
            if ((o = NotTheLispReader.read(r, true, null, true)) instanceof PersistentList) {
                Object f = RT.first((Object)o);
                if (f instanceof Symbol && ((Symbol)f).getName().equals("*")) {
                    IObj s = (IObj)RT.cons((Object)CJDDOC, (Object)RT.next((Object)o));
                    if (line >= 0) {
                        return s.withMeta(RT.map((Object[])new Object[]{RT.LINE_KEY, line}));
                    }
                    return s;
                }
                return r;
            }
            return r;
        }
    }

    public static class DispatchReader
    extends AFn {
        public Object invoke(Object reader, Object hash) throws Exception {
            int ch = ((Reader)reader).read();
            if (ch == -1) {
                throw new Exception("EOF while reading character");
            }
            IFn fn = dispatchMacros[ch];
            if (fn == null) {
                throw new Exception(String.format("No dispatch macro for: %c", Character.valueOf((char)ch)));
            }
            return fn.invoke(reader, (Object)ch);
        }
    }

    public static class EvalReader
    extends AFn {
        public Object invoke(Object reader, Object eq) throws Exception {
            if (!RT.booleanCast((Object)RT.READEVAL.deref())) {
                throw new Exception("EvalReader not allowed when *read-eval* is false.");
            }
            PushbackReader r = (PushbackReader)reader;
            Object o = NotTheLispReader.read(r, true, null, true);
            if (o instanceof Symbol) {
                return RT.classForName((String)o.toString());
            }
            if (o instanceof IPersistentList) {
                Symbol fs = (Symbol)RT.first((Object)o);
                if (fs.equals((Object)THE_VAR)) {
                    Symbol vs = (Symbol)RT.second((Object)o);
                    return RT.var((String)vs.ns, (String)vs.name);
                }
                if (fs.name.endsWith(".")) {
                    Object[] args = RT.toArray((Object)RT.next((Object)o));
                    return Reflector.invokeConstructor((Class)RT.classForName((String)fs.name.substring(0, fs.name.length() - 1)), (Object[])args);
                }
                if (Compiler.namesStaticMember((Symbol)fs)) {
                    Object[] args = RT.toArray((Object)RT.next((Object)o));
                    return Reflector.invokeStaticMethod((String)fs.ns, (String)fs.name, (Object[])args);
                }
                Object v = Compiler.maybeResolveIn((Namespace)Compiler.currentNS(), (Symbol)fs);
                if (v instanceof Var) {
                    return ((IFn)v).applyTo(RT.next((Object)o));
                }
                throw new Exception("Can't resolve " + fs);
            }
            throw new IllegalArgumentException("Unsupported #= form");
        }
    }

    public static class FnReader
    extends AFn {
        public Object invoke(Object reader, Object lparen) throws Exception {
            PushbackReader r = (PushbackReader)reader;
            if (ARG_ENV.deref() != null) {
                throw new IllegalStateException("Nested #()s are not allowed");
            }
            try {
                Var.pushThreadBindings((Associative)RT.map((Object[])new Object[]{ARG_ENV, PersistentTreeMap.EMPTY}));
                r.unread(40);
                Object form = NotTheLispReader.read(r, true, null, true);
                PersistentVector args = PersistentVector.EMPTY;
                PersistentTreeMap argsyms = (PersistentTreeMap)ARG_ENV.deref();
                ISeq rargs = argsyms.rseq();
                if (rargs != null) {
                    Object restsym;
                    int higharg = (Integer)((Map.Entry)rargs.first()).getKey();
                    if (higharg > 0) {
                        int i = 1;
                        while (i <= higharg) {
                            Object sym = argsyms.valAt((Object)i);
                            if (sym == null) {
                                sym = NotTheLispReader.garg(i);
                            }
                            args = args.cons(sym);
                            ++i;
                        }
                    }
                    if ((restsym = argsyms.valAt((Object)-1)) != null) {
                        args = args.cons((Object)Compiler._AMP_);
                        args = args.cons(restsym);
                    }
                }
                ISeq iSeq = RT.list((Object)Compiler.FN, (Object)args, (Object)form);
                return iSeq;
            }
            finally {
                Var.popThreadBindings();
            }
        }
    }

    public static class ListReader
    extends AFn {
        public Object invoke(Object reader, Object leftparen) throws Exception {
            List list;
            PushbackReader r = (PushbackReader)reader;
            int line = -1;
            if (r instanceof LineNumberingPushbackReader) {
                line = ((LineNumberingPushbackReader)r).getLineNumber();
            }
            if ((list = NotTheLispReader.readDelimitedList(')', r, true)).isEmpty()) {
                return PersistentList.EMPTY;
            }
            IObj s = (IObj)PersistentList.create((List)list);
            if (line != -1) {
                return s.withMeta(RT.map((Object[])new Object[]{RT.LINE_KEY, line}));
            }
            return s;
        }
    }

    public static class MapReader
    extends AFn {
        public Object invoke(Object reader, Object leftparen) throws Exception {
            PushbackReader r = (PushbackReader)reader;
            return RT.map((Object[])NotTheLispReader.readDelimitedList('}', r, true).toArray());
        }
    }

    public static class MetaReader
    extends AFn {
        public Object invoke(Object reader, Object caret) throws Exception {
            Object meta;
            PushbackReader r = (PushbackReader)reader;
            int line = -1;
            if (r instanceof LineNumberingPushbackReader) {
                line = ((LineNumberingPushbackReader)r).getLineNumber();
            }
            if ((meta = NotTheLispReader.read(r, true, null, true)) instanceof Symbol || meta instanceof Keyword || meta instanceof String) {
                meta = RT.map((Object[])new Object[]{RT.TAG_KEY, meta});
            } else if (!(meta instanceof IPersistentMap)) {
                throw new IllegalArgumentException("Metadata must be Symbol,Keyword,String or Map");
            }
            Object o = NotTheLispReader.read(r, true, null, true);
            if (o instanceof IMeta) {
                if (line != -1 && o instanceof ISeq) {
                    meta = ((IPersistentMap)meta).assoc((Object)RT.LINE_KEY, (Object)line);
                }
                if (o instanceof IReference) {
                    ((IReference)o).resetMeta((IPersistentMap)meta);
                    return o;
                }
                return ((IObj)o).withMeta((IPersistentMap)meta);
            }
            throw new IllegalArgumentException("Metadata can only be applied to IMetas");
        }
    }

    public static class ReaderException
    extends Exception {
        final int line;

        public ReaderException(int line, Throwable cause) {
            super(cause);
            this.line = line;
        }
    }

    public static class RegexReader
    extends AFn {
        static StringReader stringrdr = new StringReader();

        public Object invoke(Object reader, Object doublequote) throws Exception {
            StringBuilder sb = new StringBuilder();
            Reader r = (Reader)reader;
            int ch = r.read();
            while (ch != 34) {
                if (ch == -1) {
                    throw new Exception("EOF while reading regex");
                }
                sb.append((char)ch);
                if (ch == 92) {
                    ch = r.read();
                    if (ch == -1) {
                        throw new Exception("EOF while reading regex");
                    }
                    sb.append((char)ch);
                }
                ch = r.read();
            }
            return Pattern.compile(sb.toString());
        }
    }

    public static class SetReader
    extends AFn {
        public Object invoke(Object reader, Object leftbracket) throws Exception {
            PushbackReader r = (PushbackReader)reader;
            return PersistentHashSet.createWithCheck((List)NotTheLispReader.readDelimitedList('}', r, true));
        }
    }

    public static class StringReader
    extends AFn {
        public Object invoke(Object reader, Object doublequote) throws Exception {
            StringBuilder sb = new StringBuilder();
            Reader r = (Reader)reader;
            int ch = r.read();
            while (ch != 34) {
                if (ch == -1) {
                    throw new Exception("EOF while reading string");
                }
                if (ch == 92) {
                    ch = r.read();
                    if (ch == -1) {
                        throw new Exception("EOF while reading string");
                    }
                    switch (ch) {
                        case 116: {
                            ch = 9;
                            break;
                        }
                        case 114: {
                            ch = 13;
                            break;
                        }
                        case 110: {
                            ch = 10;
                            break;
                        }
                        case 92: {
                            break;
                        }
                        case 34: {
                            break;
                        }
                        case 98: {
                            ch = 8;
                            break;
                        }
                        case 102: {
                            ch = 12;
                            break;
                        }
                        case 117: {
                            ch = r.read();
                            if (Character.digit(ch, 16) == -1) {
                                throw new Exception("Invalid unicode escape: \\u" + (char)ch);
                            }
                            ch = NotTheLispReader.readUnicodeChar((PushbackReader)r, ch, 16, 4, true);
                            break;
                        }
                        default: {
                            if (Character.isDigit(ch)) {
                                if ((ch = NotTheLispReader.readUnicodeChar((PushbackReader)r, ch, 8, 3, false)) <= 255) break;
                                throw new Exception("Octal escape sequence must be in range [0, 377].");
                            }
                            throw new Exception("Unsupported escape character: \\" + (char)ch);
                        }
                    }
                }
                sb.append((char)ch);
                ch = r.read();
            }
            return sb.toString();
        }
    }

    public static class SyntaxQuoteReader
    extends AFn {
        public Object invoke(Object reader, Object backquote) throws Exception {
            PushbackReader r = (PushbackReader)reader;
            try {
                Var.pushThreadBindings((Associative)RT.map((Object[])new Object[]{GENSYM_ENV, PersistentHashMap.EMPTY}));
                Object form = NotTheLispReader.read(r, true, null, true);
                Object object = SyntaxQuoteReader.syntaxQuote(form);
                return object;
            }
            finally {
                Var.popThreadBindings();
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static Object syntaxQuote(Object form) throws Exception {
            void var1_10;
            IPersistentMap newMeta;
            if (Compiler.isSpecial((Object)form)) {
                ISeq iSeq = RT.list((Object)Compiler.QUOTE, (Object)form);
            } else if (form instanceof Symbol) {
                Symbol sym = (Symbol)form;
                if (sym.ns == null && sym.name.endsWith("#")) {
                    IPersistentMap gmap = (IPersistentMap)GENSYM_ENV.deref();
                    if (gmap == null) {
                        throw new IllegalStateException("Gensym literal not in syntax-quote");
                    }
                    Symbol gs = (Symbol)gmap.valAt((Object)sym);
                    if (gs == null) {
                        gs = Symbol.intern(null, (String)(String.valueOf(sym.name.substring(0, sym.name.length() - 1)) + "__" + RT.nextID() + "__auto__"));
                        GENSYM_ENV.set((Object)gmap.assoc((Object)sym, (Object)gs));
                    }
                    sym = gs;
                } else if (sym.ns == null && sym.name.endsWith(".")) {
                    Symbol csym = Symbol.intern(null, (String)sym.name.substring(0, sym.name.length() - 1));
                    csym = Compiler.resolveSymbol((Symbol)csym);
                    sym = Symbol.intern(null, (String)csym.name.concat("."));
                } else if (sym.ns != null || !sym.name.startsWith(".")) {
                    Object maybeClass = null;
                    if (sym.ns != null) {
                        maybeClass = Compiler.currentNS().getMapping(Symbol.intern(null, (String)sym.ns));
                    }
                    sym = maybeClass instanceof Class ? Symbol.intern((String)((Class)maybeClass).getName(), (String)sym.name) : Compiler.resolveSymbol((Symbol)sym);
                }
                ISeq iSeq = RT.list((Object)Compiler.QUOTE, (Object)sym);
            } else {
                if (NotTheLispReader.isUnquote(form)) {
                    return RT.second((Object)form);
                }
                if (NotTheLispReader.isUnquoteSplicing(form)) {
                    throw new IllegalStateException("splice not in list");
                }
                if (form instanceof IPersistentCollection) {
                    if (form instanceof IPersistentMap) {
                        IPersistentVector keyvals = SyntaxQuoteReader.flattenMap(form);
                        ISeq iSeq = RT.list((Object)APPLY, (Object)HASHMAP, (Object)RT.list((Object)SEQ, (Object)RT.cons((Object)CONCAT, (Object)SyntaxQuoteReader.sqExpandList(keyvals.seq()))));
                    } else if (form instanceof IPersistentVector) {
                        ISeq iSeq = RT.list((Object)APPLY, (Object)VECTOR, (Object)RT.list((Object)SEQ, (Object)RT.cons((Object)CONCAT, (Object)SyntaxQuoteReader.sqExpandList(((IPersistentVector)form).seq()))));
                    } else if (form instanceof IPersistentSet) {
                        ISeq iSeq = RT.list((Object)APPLY, (Object)HASHSET, (Object)RT.list((Object)SEQ, (Object)RT.cons((Object)CONCAT, (Object)SyntaxQuoteReader.sqExpandList(((IPersistentSet)form).seq()))));
                    } else {
                        if (!(form instanceof ISeq) && !(form instanceof IPersistentList)) throw new UnsupportedOperationException("Unknown Collection type");
                        ISeq seq = RT.seq((Object)form);
                        if (seq == null) {
                            ISeq iSeq = RT.cons((Object)LIST, null);
                        } else {
                            ISeq iSeq = RT.list((Object)SEQ, (Object)RT.cons((Object)CONCAT, (Object)SyntaxQuoteReader.sqExpandList(seq)));
                        }
                    }
                } else if (form instanceof Keyword || form instanceof Number || form instanceof Character || form instanceof String) {
                    Object object = form;
                } else {
                    ISeq iSeq = RT.list((Object)Compiler.QUOTE, (Object)form);
                }
            }
            if (!(form instanceof IObj) || RT.meta((Object)form) == null || (newMeta = ((IObj)form).meta().without((Object)RT.LINE_KEY)).count() <= 0) return var1_10;
            return RT.list((Object)WITH_META, (Object)var1_10, (Object)SyntaxQuoteReader.syntaxQuote(((IObj)form).meta()));
        }

        private static ISeq sqExpandList(ISeq seq) throws Exception {
            PersistentVector ret = PersistentVector.EMPTY;
            while (seq != null) {
                Object item = seq.first();
                ret = NotTheLispReader.isUnquote(item) ? ret.cons((Object)RT.list((Object)LIST, (Object)RT.second((Object)item))) : (NotTheLispReader.isUnquoteSplicing(item) ? ret.cons(RT.second((Object)item)) : ret.cons((Object)RT.list((Object)LIST, (Object)SyntaxQuoteReader.syntaxQuote(item))));
                seq = seq.next();
            }
            return ret.seq();
        }

        private static IPersistentVector flattenMap(Object form) {
            PersistentVector keyvals = PersistentVector.EMPTY;
            ISeq s = RT.seq((Object)form);
            while (s != null) {
                IMapEntry e = (IMapEntry)s.first();
                keyvals = keyvals.cons(e.key());
                keyvals = keyvals.cons(e.val());
                s = s.next();
            }
            return keyvals;
        }
    }

    public static class UnmatchedDelimiterReader
    extends AFn {
        public Object invoke(Object reader, Object rightdelim) throws Exception {
            throw new Exception("Unmatched delimiter: " + rightdelim);
        }
    }

    static class UnquoteReader
    extends AFn {
        UnquoteReader() {
        }

        public Object invoke(Object reader, Object comma) throws Exception {
            PushbackReader r = (PushbackReader)reader;
            int ch = r.read();
            if (ch == -1) {
                throw new Exception("EOF while reading character");
            }
            if (ch == 64) {
                Object o = NotTheLispReader.read(r, true, null, true);
                return RT.list((Object)UNQUOTE_SPLICING, (Object)o);
            }
            NotTheLispReader.unread(r, ch);
            Object o = NotTheLispReader.read(r, true, null, true);
            return RT.list((Object)UNQUOTE, (Object)o);
        }
    }

    public static class UnreadableReader
    extends AFn {
        public Object invoke(Object reader, Object leftangle) throws Exception {
            throw new Exception("Unreadable form");
        }
    }

    public static class VarReader
    extends AFn {
        public Object invoke(Object reader, Object quote) throws Exception {
            PushbackReader r = (PushbackReader)reader;
            Object o = NotTheLispReader.read(r, true, null, true);
            return RT.list((Object)THE_VAR, (Object)o);
        }
    }

    public static class VectorReader
    extends AFn {
        public Object invoke(Object reader, Object leftparen) throws Exception {
            PushbackReader r = (PushbackReader)reader;
            return LazilyPersistentVector.create((Collection)NotTheLispReader.readDelimitedList(']', r, true));
        }
    }

    public static class WrappingReader
    extends AFn {
        final Symbol sym;

        public WrappingReader(Symbol sym) {
            this.sym = sym;
        }

        public Object invoke(Object reader, Object quote) throws Exception {
            PushbackReader r = (PushbackReader)reader;
            Object o = NotTheLispReader.read(r, true, null, true);
            return RT.list((Object)this.sym, (Object)o);
        }
    }
}

