(ns cjd.vox.vox-utilz
  (:use
    [cjd.util.string-utils]
    )
  )

(defn stringify
  "Turns a _list_ of symbols into a list of strings. Thus:
(stringify '(a b c)) => (\"a\" \"b\" \"c\") "
  [items]
  (loop [[item & more] items
           strs nil]
      (if item
        (recur
          more
          (if (string? item) item (cons (str item) strs))
          ;(str item)
          )
        (vec (reverse strs)))))

(defn restring [toks]
  (apply str (interleave toks (repeat " "))))

(defmacro tmod [target op & reps]
  (if (= op '->)
    (let [t (re-pattern (str "(?i) " target " "))
          rs (str " " (restring (stringify reps)) )]
      `[~t ~rs])
    (throw (IllegalArgumentException. "Missing -> in token-mod"))))

(defmacro token-rep-map [& mods]
  (let [xmods (map (fn [mod] (cons 'tmod mod)) mods)]
    `(reduce (fn [acc# [target# reps#]] (conj acc# [target# reps#])) [] [~@xmods])))


(defmacro prefmod [target op & reps]
  (if (= op '->)
    (let [t (re-pattern (str "(?i) " target))
          rs (str " " (restring (stringify reps)) " ")]
      `[~t ~rs])
    (throw (IllegalArgumentException. (str "Missing -> in prefix-rep: " )))))

(defmacro prefix-rep-list [& mods]
  (let [xmods (map (fn [mod] (cons 'prefmod mod)) mods)]
    `(reduce (fn [acc# [target# reps#]] (conj acc# [target# reps#])) [] [~@xmods])))
