/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.Item;
import com.android.dx.dex.file.MemberIdItem;
import com.android.dx.dex.file.MethodIdsSection;
import com.android.dx.dex.file.UniformItemSection;
import com.android.dx.util.DexException;
import java.util.Formatter;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class MemberIdsSection
extends UniformItemSection {
    private static final int MAX_MEMBERS = 65536;

    public MemberIdsSection(String name2, DexFile file2) {
        super(name2, file2, 4);
    }

    protected void orderItems() {
        int idx = 0;
        if (this.items().size() > 65536) {
            throw new DexException(this.tooManyMembersMessage());
        }
        for (Item item : this.items()) {
            ((MemberIdItem)item).setIndex(idx);
            ++idx;
        }
    }

    private String tooManyMembersMessage() {
        TreeMap<String, AtomicInteger> membersByPackage = new TreeMap<String, AtomicInteger>();
        for (Item item : this.items()) {
            String packageName = ((MemberIdItem)item).getDefiningClass().getPackageName();
            AtomicInteger count2 = (AtomicInteger)membersByPackage.get(packageName);
            if (count2 == null) {
                count2 = new AtomicInteger();
                membersByPackage.put(packageName, count2);
            }
            count2.incrementAndGet();
        }
        Formatter formatter2 = new Formatter();
        String string2 = this instanceof MethodIdsSection ? "methods" : "fields";
        formatter2.format("Too many %s: %d; max is %d. By package:", string2, this.items().size(), 65536);
        for (Map.Entry entry : membersByPackage.entrySet()) {
            formatter2.format("%n%6d %s", ((AtomicInteger)entry.getValue()).get(), entry.getKey());
        }
        return formatter2.toString();
    }
}

