/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.ASeq;
import clojure.lang.Counted;
import clojure.lang.IHashEq;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentList;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.Obj;
import clojure.lang.PersistentVector;
import clojure.lang.RT;
import clojure.lang.SeqIterator;
import clojure.lang.Sequential;
import clojure.lang.Util;
import java.util.Collection;
import java.util.Iterator;

public class PersistentQueue
extends Obj
implements IPersistentList,
Collection,
Counted,
IHashEq {
    public static final PersistentQueue EMPTY = new PersistentQueue(null, 0, null, null);
    final int cnt;
    final ISeq f;
    final PersistentVector r;
    int _hash = -1;
    int _hasheq = -1;

    PersistentQueue(IPersistentMap meta, int cnt, ISeq f, PersistentVector r) {
        super(meta);
        this.cnt = cnt;
        this.f = f;
        this.r = r;
    }

    public boolean equiv(Object obj) {
        if (!(obj instanceof Sequential)) {
            return false;
        }
        ISeq ms = RT.seq(obj);
        ISeq s = this.seq();
        while (s != null) {
            if (ms == null || !Util.equiv(s.first(), ms.first())) {
                return false;
            }
            s = s.next();
            ms = ms.next();
        }
        return ms == null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Sequential)) {
            return false;
        }
        ISeq ms = RT.seq(obj);
        ISeq s = this.seq();
        while (s != null) {
            if (ms == null || !Util.equals(s.first(), ms.first())) {
                return false;
            }
            s = s.next();
            ms = ms.next();
        }
        return ms == null;
    }

    public int hashCode() {
        if (this._hash == -1) {
            int hash = 1;
            for (ISeq s = this.seq(); s != null; s = s.next()) {
                hash = 31 * hash + (s.first() == null ? 0 : s.first().hashCode());
            }
            this._hash = hash;
        }
        return this._hash;
    }

    public int hasheq() {
        if (this._hasheq == -1) {
            int hash = 1;
            for (ISeq s = this.seq(); s != null; s = s.next()) {
                hash = 31 * hash + Util.hasheq(s.first());
            }
            this._hasheq = hash;
        }
        return this._hasheq;
    }

    public Object peek() {
        return RT.first(this.f);
    }

    public PersistentQueue pop() {
        if (this.f == null) {
            return this;
        }
        ISeq f1 = this.f.next();
        PersistentVector r1 = this.r;
        if (f1 == null) {
            f1 = RT.seq(this.r);
            r1 = null;
        }
        return new PersistentQueue(this.meta(), this.cnt - 1, f1, r1);
    }

    public int count() {
        return this.cnt;
    }

    public ISeq seq() {
        if (this.f == null) {
            return null;
        }
        return new Seq(this.f, RT.seq(this.r));
    }

    public PersistentQueue cons(Object o) {
        if (this.f == null) {
            return new PersistentQueue(this.meta(), this.cnt + 1, RT.list(o), null);
        }
        return new PersistentQueue(this.meta(), this.cnt + 1, this.f, (this.r != null ? this.r : PersistentVector.EMPTY).cons(o));
    }

    public IPersistentCollection empty() {
        return EMPTY.withMeta(this.meta());
    }

    public PersistentQueue withMeta(IPersistentMap meta) {
        return new PersistentQueue(meta, this.cnt, this.f, this.r);
    }

    public Object[] toArray() {
        return RT.seqToArray(this.seq());
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean containsAll(Collection c) {
        for (Object o : c) {
            if (!this.contains(o)) continue;
            return true;
        }
        return false;
    }

    public Object[] toArray(Object[] a) {
        return RT.seqToPassedArray(this.seq(), a);
    }

    public int size() {
        return this.count();
    }

    public boolean isEmpty() {
        return this.count() == 0;
    }

    public boolean contains(Object o) {
        for (ISeq s = this.seq(); s != null; s = s.next()) {
            if (!Util.equiv(s.first(), o)) continue;
            return true;
        }
        return false;
    }

    public Iterator iterator() {
        return new SeqIterator(this.seq());
    }

    static class Seq
    extends ASeq {
        final ISeq f;
        final ISeq rseq;

        Seq(ISeq f, ISeq rseq) {
            this.f = f;
            this.rseq = rseq;
        }

        Seq(IPersistentMap meta, ISeq f, ISeq rseq) {
            super(meta);
            this.f = f;
            this.rseq = rseq;
        }

        public Object first() {
            return this.f.first();
        }

        public ISeq next() {
            ISeq f1 = this.f.next();
            ISeq r1 = this.rseq;
            if (f1 == null) {
                if (this.rseq == null) {
                    return null;
                }
                f1 = this.rseq;
                r1 = null;
            }
            return new Seq(f1, r1);
        }

        public int count() {
            return RT.count(this.f) + RT.count(this.rseq);
        }

        public Seq withMeta(IPersistentMap meta) {
            return new Seq(meta, this.f, this.rseq);
        }
    }
}

