/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.Numbers;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;

public class Ratio
extends Number
implements Comparable {
    public final BigInteger numerator;
    public final BigInteger denominator;

    public Ratio(BigInteger numerator, BigInteger denominator) {
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public boolean equals(Object arg0) {
        return arg0 != null && arg0 instanceof Ratio && ((Ratio)arg0).numerator.equals(this.numerator) && ((Ratio)arg0).denominator.equals(this.denominator);
    }

    public int hashCode() {
        return this.numerator.hashCode() ^ this.denominator.hashCode();
    }

    public String toString() {
        return this.numerator.toString() + "/" + this.denominator.toString();
    }

    public int intValue() {
        return (int)this.doubleValue();
    }

    public long longValue() {
        return this.bigIntegerValue().longValue();
    }

    public float floatValue() {
        return (float)this.doubleValue();
    }

    public double doubleValue() {
        return this.decimalValue(MathContext.DECIMAL64).doubleValue();
    }

    public BigDecimal decimalValue() {
        return this.decimalValue(MathContext.UNLIMITED);
    }

    public BigDecimal decimalValue(MathContext mc) {
        BigDecimal numerator = new BigDecimal(this.numerator);
        BigDecimal denominator = new BigDecimal(this.denominator);
        return numerator.divide(denominator, mc);
    }

    public BigInteger bigIntegerValue() {
        return this.numerator.divide(this.denominator);
    }

    public int compareTo(Object o) {
        Number other = (Number)o;
        return Numbers.compare(this, other);
    }
}

