/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.Compiler;
import clojure.lang.Util;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

public abstract class DynamicClassLoader
extends URLClassLoader {
    HashMap<Integer, Object[]> constantVals = new HashMap();
    static ConcurrentHashMap<String, Reference<Class>> classCache = new ConcurrentHashMap();
    static final URL[] EMPTY_URLS = new URL[0];
    static final ReferenceQueue rq = new ReferenceQueue();

    public DynamicClassLoader() {
        super(EMPTY_URLS, Thread.currentThread().getContextClassLoader() == null || Thread.currentThread().getContextClassLoader() == ClassLoader.getSystemClassLoader() ? Compiler.class.getClassLoader() : Thread.currentThread().getContextClassLoader());
    }

    public DynamicClassLoader(ClassLoader parent) {
        super(EMPTY_URLS, parent);
    }

    public final Class defineClass(String name, byte[] bytes, Object srcForm) {
        Util.clearCache(rq, classCache);
        Class<?> c = this.defineMissingClass(name, bytes, srcForm);
        classCache.put(name, new SoftReference(c, rq));
        return c;
    }

    protected abstract Class<?> defineMissingClass(String var1, byte[] var2, Object var3);

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Reference<Class> cr = classCache.get(name);
        if (cr != null) {
            Class c = cr.get();
            if (c != null) {
                return c;
            }
            classCache.remove(name, cr);
        }
        return super.findClass(name);
    }

    public final void registerConstants(int id, Object[] val) {
        this.constantVals.put(id, val);
    }

    public final Object[] getConstants(int id) {
        return this.constantVals.get(id);
    }

    @Override
    public final void addURL(URL url) {
        super.addURL(url);
    }
}

