/*
 * Decompiled with CFR 0.152.
 */
package clojure.tools.nrepl;

import clojure.lang.IFn;
import clojure.tools.nrepl.StdOutBuffer;
import java.io.Writer;

public class SessionOutPrintWriter
extends Writer {
    private final StdOutBuffer buf;
    private final IFn outLimit;
    private final IFn flushFn;

    public SessionOutPrintWriter(StdOutBuffer buf, IFn outLimit, IFn flushFn) {
        this.buf = buf;
        this.outLimit = outLimit;
        this.flushFn = flushFn;
    }

    public void close() {
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int x) {
        StdOutBuffer stdOutBuffer = this.buf;
        synchronized (stdOutBuffer) {
            this.buf.append((char)x);
            this.maybeFlush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String x) {
        StdOutBuffer stdOutBuffer = this.buf;
        synchronized (stdOutBuffer) {
            this.buf.append(x);
            this.maybeFlush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String x, int off, int len) {
        StdOutBuffer stdOutBuffer = this.buf;
        synchronized (stdOutBuffer) {
            this.buf.append(x, off, off + len);
            this.maybeFlush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] x, int off, int len) {
        StdOutBuffer stdOutBuffer = this.buf;
        synchronized (stdOutBuffer) {
            this.buf.append(x, off, len);
            this.maybeFlush();
        }
    }

    private void maybeFlush() {
        try {
            if ((Integer)this.outLimit.invoke() <= this.buf.length()) {
                this.flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        StdOutBuffer stdOutBuffer = this.buf;
        synchronized (stdOutBuffer) {
            String text = this.buf.toString();
            this.buf.setLength(0);
            if (text.length() > 0) {
                try {
                    this.flushFn.invoke((Object)text);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

