/*
 * Decompiled with CFR 0.152.
 */
package clojure.tools.nrepl;

import clojure.lang.IFn;
import java.io.Reader;
import java.util.concurrent.LinkedBlockingQueue;

public class SessionPushBackReader
extends Reader {
    private final LinkedBlockingQueue inputQueue;
    private final IFn requestInputFn;
    private final IFn doRead;

    public SessionPushBackReader(LinkedBlockingQueue inputQueue, IFn requestInputFn, IFn doRead) {
        this.inputQueue = inputQueue;
        this.requestInputFn = requestInputFn;
        this.doRead = doRead;
    }

    public void close() {
        this.inputQueue.clear();
    }

    public int read(char[] buf, int off, int len) {
        Object readResult;
        Object firstChar;
        if (len == 0) {
            return -1;
        }
        try {
            firstChar = this.requestInputFn.invoke();
            if (firstChar == null) {
                return -1;
            }
        }
        catch (Exception e) {
            System.out.println("Error in requestInput");
            System.out.println(e.getMessage());
            e.printStackTrace();
            return -1;
        }
        if (firstChar instanceof Long && firstChar.equals(-1L)) {
            return -1;
        }
        buf[off] = ((Character)firstChar).charValue();
        try {
            readResult = this.doRead.invoke((Object)buf, (Object)(off + 1), (Object)(len - 1));
        }
        catch (Exception e) {
            System.out.println("Error in doRead");
            System.out.println(e.getMessage());
            e.printStackTrace();
            return -1;
        }
        if (readResult instanceof Long) {
            return ((Long)readResult).intValue() - off;
        }
        if (readResult instanceof Integer) {
            return (Integer)readResult - off;
        }
        return -1;
    }
}

