# clr.core.async

A port of [clojure/core.async](https://github.com/clojure/core.async) library to ClojureCLR.

> A Clojure library designed to provide facilities for async programming and communication.



## Releases

Nuget reference:

```
    PM> Install-Package clojure.core.async -Version 1.6.674 
```
	
Leiningen/Clojars reference:

```
   [org.clojure.clr/core.async "1.6.674"]
```
   

## Documentation

* [Rationale](https://clojure.org/news/2013/06/28/clojure-clore-async-channels)
* [API docs](https://clojure.github.io/core.async/)
* [Code walkthrough](https://github.com/clojure/core.async/blob/master/examples/walkthrough.clj)

## Presentations

* [Rich Hickey on core.async](https://www.youtube.com/watch?v=yJxFPoxqzWE)
* [Tim Baldridge on core.async](https://www.youtube.com/watch?v=enwIIGzhahw) from Clojure/conj 2013 ([code](https://github.com/halgari/clojure-conj-2013-core.async-examples)).
* Tim Baldridge on go macro internals - [part 1](https://www.youtube.com/watch?v=R3PZMIwXN_g) [part 2](https://www.youtube.com/watch?v=SI7qtuuahhU)

## Contributing 

[Contributing to Clojure projects](https://clojure.org/community/contributing) requires a signed Contributor Agreement. Pull requests and GitHub issues are not accepted; please use the [core.async JIRA project](https://clojure.atlassian.net/browse/ASYNC) to report problems or enhancements.
 
# Copyright and License #

Original ClojureJVM code:

> Copyright © 2017-2022 Rich Hickey and contributors

> Distributed under the Eclipse Public License, the same as Clojure
