(ns clotool.smacalalag.scraping.confighelper
  (:require [clojure.data.csv :as csv]
            [clojure.java.io :as io]))

(defn- get-exclusions
  [exclusion-file]
  (with-open [in-file (io/reader exclusion-file)]
    (doall
      (map first (csv/read-csv in-file)))))

(defn- check
  [location exclusion-file]
  (for [x (get-exclusions exclusion-file)]
    (re-find (re-pattern x) location)))

(defn in-exclusion?
  [location exclusion-file]
  (some string? (check location exclusion-file)))
