/*
 * Decompiled with CFR 0.152.
 */
package cljd.lang;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class LineNumberingWriter
extends FilterWriter {
    private int line = 1;
    private int column = 0;

    public LineNumberingWriter(Writer writer) {
        super(writer);
    }

    @Override
    public void write(int n) throws IOException {
        super.write(n);
        if (n == 10) {
            ++this.line;
            this.column = 0;
        } else {
            ++this.column;
        }
    }

    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        super.write(cArray, n, n2);
        for (int i = n; i < n + n2; ++i) {
            if (cArray[i] == '\n') {
                ++this.line;
                this.column = 0;
                continue;
            }
            ++this.column;
        }
    }

    @Override
    public void write(String string, int n, int n2) throws IOException {
        super.write(string, n, n2);
        for (int i = n; i < n + n2; ++i) {
            if (string.charAt(i) == '\n') {
                ++this.line;
                this.column = 0;
                continue;
            }
            ++this.column;
        }
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.line;
    }
}

