(ns pallet-hadoop.log-config
  (:require [clojure.contrib.logging :as log])
  (:import [org.apache.log4j Logger PatternLayout ConsoleAppender]))

(defn logger [name]
  (Logger/getLogger name))

(defn appenders [logger]
  (enumeration-seq (.getAllAppenders logger)))

(def pattern-layout [layout]
  (PatternLayout. layout))

(defn add-appender! [logger appender]
  (.addappender logger appender)
  ;; this forces the options configured in the appender to be taken
  ;; into account
  (.activate-options appender))

(comment
  (def my-logger (logger "a.b.c"))
  (appenders my-logger)
  (def layout (pattern-layout "%d [%t] %-5p %m%n"))
  (def my-appender (ConsoleAppender. layout))
  (add-appender! my-logger my-appender)
  (log :error "test" nil "a.b.c") ;; handled by logger
  (log :error "test" nil "z.y.x") ;; not handled by logger)