(ns pallet.crate.thttpd
  "Install thttpd"
  (:require
   [pallet.resource.package :as package])
  (:use
   pallet.thread-expr))

(defn thttp
  [request]
  (->
   request
   (when->
    (= :yum (:target-packager request))
    (package/add-epel)))
  (package/package "thttpd")
  (parameter/assoc-for-target
   [:thttpd :www-base] (when (= :yum (:target-packager request))
                         "/var/www/thttpd/html"
                         "/var/www")))
