/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security;

import com.idoox.wasp.serialization.SerializationHelper;
import java.security.cert.Certificate;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.SchemaContext;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.Serializer;
import org.idoox.xml.schema.Member;
import org.idoox.xmlrpc.MessageCreatingException;
import org.idoox.xmlrpc.encoding.EncodingTokenWriter;

public class CertificateSerializer
implements Serializer {
    private static QName structType = new QName("http://idoox.com/security", "Certificate");

    public String getMechanismType() {
        return Serializer.MECHANISM_TYPE;
    }

    public void serialize(EncodingTokenWriter dataWriter, Object data, int[] arrayPos, SerializationContext context, SerializationChain chain) throws MessageCreatingException {
        try {
            Certificate cert = (Certificate)data;
            String type = cert.getType();
            byte[] encoded = cert.getEncoded();
            Member m = context.getCurrentMember();
            dataWriter.writeStructureStart(m.getName(), structType, arrayPos, null);
            SchemaContext.State state = context.enterCurrentMember();
            Member nextMember = context.nextMember();
            nextMember = SerializationHelper.serialize((EncodingTokenWriter)dataWriter, (Object)type, null, (SerializationContext)context);
            SerializationHelper.serialize((EncodingTokenWriter)dataWriter, (Object)encoded, null, (SerializationContext)context);
            context.leave(state);
            dataWriter.writeStructureEnd();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageCreatingException((Throwable)e);
        }
    }

    public void grabReferences(Object data, SerializationContext context, SerializationChain chain) throws MessageCreatingException {
        Member m = context.getCurrentMember();
        context.registerReference(data, m.getType());
    }

    public void init(Configurable conf) {
    }
}

