/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization.attachments;

import com.idoox.xml.schema.util.XMLSchemaUtil;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.Serializer;
import org.idoox.wasp.types.MessageAttachment;
import org.idoox.xml.schema.Attribute;
import org.idoox.xmlrpc.MessageCreatingException;
import org.idoox.xmlrpc.encoding.EncodingTokenWriter;

public class AttachmentSerializer
implements Serializer {
    private static final QName REF_LOCATION = new QName("http://schemas.xmlsoap.org/ws/2002/04/reference/", "location");

    public void serialize(EncodingTokenWriter dataWriter, Object data, int[] arrayPos, SerializationContext context, SerializationChain chain) throws MessageCreatingException {
        try {
            MessageAttachment d = (MessageAttachment)data;
            String contentLocation = d.getContentLocation();
            String reference = contentLocation != null ? contentLocation : "cid:" + d.getContentId();
            context.registerAttachment(d);
            boolean dime = false;
            Attribute[] attributes = context.getCurrentConstructSchemaType().getAttributes();
            if (attributes != null) {
                int i = 0;
                while (i < attributes.length) {
                    Attribute attribute = XMLSchemaUtil.dereferenceAttribute((Attribute)attributes[i]);
                    if (attribute != null && REF_LOCATION.equals(attribute.getName())) {
                        dime = true;
                        break;
                    }
                    ++i;
                }
            }
            if (dime) {
                dataWriter.writeSoapReference("http://schemas.xmlsoap.org/ws/2002/04/reference/", "location", context.getCurrentConstructName(), arrayPos, reference);
            } else {
                dataWriter.writeReference(context.getCurrentConstructName(), arrayPos, reference);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (IOException e) {
            throw new MessageCreatingException((Throwable)e);
        }
    }

    public void grabReferences(Object data, SerializationContext context, SerializationChain chain) throws MessageCreatingException {
    }

    public void init(Configurable conf) {
    }

    public String getMechanismType() {
        return Serializer.MECHANISM_TYPE;
    }
}

