/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization.xml;

import com.idoox.wasp.serialization.DeserializationException;
import com.idoox.wasp.serialization.DuplicateAccessException;
import com.idoox.wasp.serialization.WaspSerializationHelper;
import com.idoox.wasp.serialization.xml.XMLReflectionDeserializer;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.idoox.wasp.serialization.DeserializationChain;
import org.idoox.wasp.serialization.DeserializationContext;
import org.idoox.wasp.serialization.SchemaContext;
import org.idoox.wasp.serialization.XMLDeserializer;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.idoox.xml.schema.Attribute;
import org.idoox.xml.schema.AttributeGroup;
import org.idoox.xml.schema.SchemaConstruct;
import org.idoox.xml.schema.Type;
import org.idoox.xmlrpc.MessageProcessingException;

public final class XMLAttributesDeserializationHelper {
    private XMLAttributesDeserializationHelper() {
    }

    public static void deserializeAttributes(Tokenizer dataTokenizer, Token currentToken, Object fillInto, DeserializationContext context, DeserializationChain next, Type type) throws MessageProcessingException, IOException, DuplicateAccessException, IntrospectionException, IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        XMLAttributesDeserializationHelper.deserializeAttributes(dataTokenizer, fillInto, context, currentToken, type.getAttributes());
        XMLAttributesDeserializationHelper.deserializeAttributeGroups(dataTokenizer, currentToken, fillInto, context, next, type.getAttributeGroups());
    }

    private static void deserializeAttributeGroups(Tokenizer dataTokenizer, Token currentToken, Object fillInto, DeserializationContext context, DeserializationChain next, AttributeGroup[] attributeGroups) throws MessageProcessingException, IOException, DuplicateAccessException, IntrospectionException, IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        if (attributeGroups == null) {
            return;
        }
        int i = 0;
        while (i < attributeGroups.length) {
            XMLAttributesDeserializationHelper.deserializeAttributes(dataTokenizer, fillInto, context, currentToken, attributeGroups[i].getAttributes());
            XMLAttributesDeserializationHelper.deserializeAttributeGroups(dataTokenizer, currentToken, fillInto, context, next, attributeGroups[i].getAttributeGroups());
            ++i;
        }
    }

    private static void deserializeAttributes(Tokenizer dataTokenizer, Object fillInto, DeserializationContext context, Token currentToken, Attribute[] attributes) throws MessageProcessingException, DuplicateAccessException, IntrospectionException, IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        if (attributes == null) {
            return;
        }
        Map props = WaspSerializationHelper.getProperties(fillInto.getClass());
        int i = 0;
        while (i < attributes.length) {
            SchemaConstruct attributeConstruct = attributes[i].getReferencedConstruct();
            if (attributeConstruct == null) {
                attributeConstruct = attributes[i];
            }
            SchemaContext.State state = context.putSchemaConstruct(attributeConstruct);
            String name = WaspSerializationHelper.getConstructJavaMemberName((SchemaConstruct)context.getCurrentSchemaConstruct());
            Object o = props.get(name);
            PropertyDescriptor prop = null;
            Field field = null;
            if (o == null) {
                o = props.get(WaspSerializationHelper.mapElementName((String)name));
                if (o == null && !((o = props.get(WaspSerializationHelper.decapitalizeName((String)name))) instanceof PropertyDescriptor)) {
                    o = null;
                }
                if (o == null) {
                    char[] chars = name.toCharArray();
                    chars[0] = Character.toUpperCase(chars[0]);
                    o = props.get(WaspSerializationHelper.mapElementName((String)new String(chars)));
                }
                if (o == null) {
                    throw new NoSuchFieldException("Don't know how to map <" + name + "> in " + fillInto.getClass());
                }
            }
            if (o instanceof PropertyDescriptor) {
                prop = (PropertyDescriptor)o;
            } else {
                field = (Field)o;
            }
            Class<?> memberClass = prop == null ? field.getType() : prop.getPropertyType();
            DeserializationChain chain = context.getDeserializationChain(memberClass);
            XMLDeserializer memberDeserializer = (XMLDeserializer)chain.getNextDeserializerAs("systinet:xmlser/1.0");
            try {
                dataTokenizer.readToken(currentToken);
            }
            catch (TokenizerException e) {
                throw new MessageProcessingException((Throwable)e);
            }
            catch (IOException e) {
                throw new MessageProcessingException((Throwable)e);
            }
            Object member = memberDeserializer.deserialize(dataTokenizer, currentToken, memberClass, context, chain);
            context.releaseDeserializationChain(chain);
            context.leave(state);
            if (prop != null) {
                Method writeMethod = prop.getWriteMethod();
                if (writeMethod == null) {
                    throw new DeserializationException("No write method for property " + prop.getName() + ", class " + fillInto.getClass());
                }
                writeMethod.invoke(fillInto, member);
            } else {
                XMLReflectionDeserializer.setField(fillInto, field, member);
            }
            ++i;
        }
    }
}

