/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization.xml.msnet;

import com.idoox.wasp.serialization.SerializationHelper;
import com.idoox.wasp.serialization.xml.XMLAttributesSerializationHelper;
import com.idoox.wasp.serialization.xml.XMLReflectionSerializer;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.SchemaContext;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.XMLSerializer;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.schema.Member;
import org.idoox.xml.schema.SchemaConstruct;
import org.idoox.xml.schema.Type;
import org.idoox.xmlrpc.MessageCreatingException;

public class XMLCollectionSerializer
implements XMLSerializer {
    private static final String SYSTINET_MSNET_LITERAL_CONTAINERS_NAMESPACE = "http://systinet.com/containers/literal/ms.net";

    public void serialize(TokenWriter dataWriter, Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
        try {
            boolean member;
            Type currentType = context.getCurrentConstructSchemaType();
            QName memberQName = null;
            SchemaConstruct currentSchemaConstruct = context.getCurrentSchemaConstruct();
            if (currentSchemaConstruct instanceof Member) {
                member = true;
                Member listMember = (Member)currentSchemaConstruct;
                memberQName = listMember.getName();
                dataWriter.enter(memberQName.getNamespaceURI(), memberQName.getLocalPart());
                QName schemaTypeQName = context.getCurrentConstructSchemaType().getName();
                String prefix = dataWriter.getPrefixForNamespace(schemaTypeQName.getNamespaceURI());
                if (prefix == null) {
                    prefix = "msn";
                    dataWriter.setPrefixForNamespace(prefix, schemaTypeQName.getNamespaceURI());
                }
                dataWriter.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", prefix + ":" + schemaTypeQName.getLocalPart());
            } else {
                member = false;
            }
            XMLAttributesSerializationHelper.writeAttributes(dataWriter, data, context, next, currentType);
            SchemaContext.State arrayState = context.enterCurrentMember();
            SchemaConstruct arrayMember = context.nextSchemaConstruct();
            memberQName = arrayMember.getName();
            dataWriter.enter(memberQName.getNamespaceURI(), memberQName.getLocalPart());
            SchemaContext.State itemState = context.enterCurrentMember();
            Member itemMember = (Member)context.nextSchemaConstruct();
            memberQName = itemMember.getName();
            Collection collection = (Collection)data;
            Member fakeMember = new Member(itemMember.getName(), itemMember.getType(), true);
            Iterator collectionIterator = collection.iterator();
            while (collectionIterator.hasNext()) {
                SchemaContext.State state = context.putSchemaConstruct((SchemaConstruct)fakeMember);
                SerializationHelper.serialize((TokenWriter)dataWriter, collectionIterator.next(), (SerializationContext)context);
                context.leave(state);
            }
            context.leave(itemState);
            dataWriter.leave();
            XMLCollectionSerializer.serializeCustomProperties(dataWriter, data, context, next, currentType);
            context.leave(arrayState);
            if (member) {
                dataWriter.leave();
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new MessageCreatingException((Throwable)e);
        }
    }

    static void serializeCustomProperties(TokenWriter dataWriter, Object data, SerializationContext context, SerializationChain next, Type currentType) throws MessageCreatingException {
        if (!XMLCollectionSerializer.fromSystinetsNamespace(currentType)) {
            Type newTypeWithoutContentButWithProperties = XMLCollectionSerializer.createArtificalType(currentType);
            SchemaContext.State state1 = context.putSchemaConstruct((SchemaConstruct)newTypeWithoutContentButWithProperties);
            XMLReflectionSerializer.serializeStatic(dataWriter, data, context, next);
            context.leave(state1);
        }
    }

    static Type createArtificalType(Type actualType) {
        Type parent;
        Type result;
        Type curType = result = (Type)actualType.clone();
        while (!XMLCollectionSerializer.fromSystinetsNamespace(parent = curType.getBaseType())) {
            parent = (Type)parent.clone();
            curType.setBaseType(parent);
            curType = parent;
        }
        curType.setBaseType(null);
        result.setName(null);
        return result;
    }

    static boolean fromSystinetsNamespace(Type type) {
        return SYSTINET_MSNET_LITERAL_CONTAINERS_NAMESPACE.equals(type.getName().getNamespaceURI());
    }

    public void grabReferences(Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
        SchemaContext.State itemState;
        SchemaContext.State arrayState;
        Member member = (Member)context.getCurrentSchemaConstruct();
        if (context.registerReference(data, member.getType()) == null) {
            Collection collection = (Collection)data;
            arrayState = context.enterCurrentMember();
            context.nextSchemaConstruct();
            itemState = context.enterCurrentMember();
            SchemaConstruct itemMember = context.nextSchemaConstruct();
            Iterator collectionIterator = collection.iterator();
            while (collectionIterator.hasNext()) {
                SchemaContext.State state = context.putSchemaConstruct(itemMember);
                SerializationHelper.grabReferences(collectionIterator.next(), (SerializationContext)context);
                context.leave(state);
            }
        } else {
            throw new MessageCreatingException("In document/literal it is not allowed to have multireferences. Data already registered: " + data.getClass().getName());
        }
        context.leave(itemState);
        context.leave(arrayState);
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }

    public void init(Configurable conf) {
    }
}

