/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization.javabuiltin;

import com.idoox.wasp.serialization.SerializationHelper;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.SchemaContext;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.Serializer;
import org.idoox.xml.schema.Member;
import org.idoox.xmlrpc.MessageCreatingException;
import org.idoox.xmlrpc.encoding.EncodingTokenWriter;

public class ListSerializer
implements Serializer {
    protected QName structType;

    public String getMechanismType() {
        return Serializer.MECHANISM_TYPE;
    }

    public ListSerializer() {
        this("http://idoox.com/containers", "List");
    }

    protected ListSerializer(String structNamespace, String structName) {
        this.setStructParams(structNamespace, structName);
    }

    public void serialize(EncodingTokenWriter dataWriter, Object data, int[] arrayPos, SerializationContext context, SerializationChain chain) throws MessageCreatingException {
        try {
            List dataList = (List)data;
            Member m = (Member)context.getCurrentSchemaConstruct();
            String id = context.getMultirefId(data);
            dataWriter.writeStructureStart(m.getName(), this.structType, arrayPos, id);
            Iterator listIter = dataList.iterator();
            while (listIter.hasNext()) {
                SchemaContext.State state = context.enterCurrentMember();
                Member nextMember = context.nextMember();
                SerializationHelper.serialize((EncodingTokenWriter)dataWriter, listIter.next(), null, (SerializationContext)context);
                context.leave(state);
            }
            dataWriter.writeStructureEnd();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageCreatingException((Throwable)e);
        }
    }

    public void grabReferences(Object data, SerializationContext context, SerializationChain chain) throws MessageCreatingException {
        Member m = (Member)context.getCurrentSchemaConstruct();
        if (context.registerReference(data, m.getType()) == null) {
            List dataList = (List)data;
            Iterator listIter = dataList.iterator();
            while (listIter.hasNext()) {
                SchemaContext.State state = context.enterCurrentMember();
                Member nextMember = context.nextMember();
                SerializationHelper.grabReferences(listIter.next(), (SerializationContext)context);
                context.leave(state);
            }
        }
    }

    protected void setStructParams(String structNamespace, String structName) {
        this.structType = new QName(structNamespace, structName);
    }

    public void init(Configurable config) {
    }
}

