/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization.xml.msnet;

import com.idoox.wasp.serialization.SerializationHelper;
import com.idoox.wasp.serialization.xml.XMLAttributesDeserializationHelper;
import com.idoox.wasp.serialization.xml.msnet.XMLCollectionDeserializer;
import com.idoox.wasp.serialization.xml.msnet.XMLCollectionSerializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.DeserializationChain;
import org.idoox.wasp.serialization.DeserializationContext;
import org.idoox.wasp.serialization.SchemaContext;
import org.idoox.wasp.serialization.XMLDeserializer;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.schema.Member;
import org.idoox.xml.schema.SchemaConstruct;
import org.idoox.xml.schema.Type;
import org.idoox.xmlrpc.MessageProcessingException;

public class XMLMapDeserializer
implements XMLDeserializer {
    private static final Class HASH_MAP_CLASS = class$java$util$HashMap == null ? (class$java$util$HashMap = XMLMapDeserializer.class$("java.util.HashMap")) : class$java$util$HashMap;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$HashMap;
    static /* synthetic */ Class class$java$util$Map;

    public Object deserialize(Tokenizer dataTokenizer, Token currentToken, Class targetClass, DeserializationContext context, DeserializationChain chain) throws MessageProcessingException {
        try {
            Type currentType = context.getCurrentConstructSchemaType();
            boolean deserializingUserCollectionExtension = !XMLCollectionSerializer.fromSystinetsNamespace(currentType);
            Map map = this.createMapImplementation(targetClass);
            if (deserializingUserCollectionExtension) {
                XMLAttributesDeserializationHelper.deserializeAttributes(dataTokenizer, currentToken, map, context, chain, currentType);
            }
            SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
            SchemaContext.State mapState = context.enterCurrentMember();
            context.nextMember();
            Object[] arrayOfKeys = this.deserializeArray(dataTokenizer, currentToken, context, chain);
            Object[] arrayOfValues = this.deserializeArray(dataTokenizer, currentToken, context, chain);
            context.leave(mapState);
            if (arrayOfKeys.length != arrayOfValues.length) {
                throw new MessageProcessingException("Number of Keys is different from Values. #Keys=" + arrayOfKeys.length + ", #Values=" + arrayOfValues.length);
            }
            int i = 0;
            while (i < arrayOfKeys.length) {
                map.put(arrayOfKeys[i], arrayOfValues[i]);
                ++i;
            }
            if (deserializingUserCollectionExtension && dataTokenizer.currentState() == 2) {
                XMLCollectionDeserializer.deserializeCustomProperties(dataTokenizer, context, currentType, targetClass, map);
            }
            return map;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageProcessingException((Throwable)e);
        }
    }

    protected Object[] deserializeArray(Tokenizer dataTokenizer, Token currentToken, DeserializationContext context, DeserializationChain chain) throws MessageProcessingException {
        try {
            ArrayList<Object> valueArray = new ArrayList<Object>();
            SchemaContext.State arrayState = context.enterCurrentMember();
            Member member = (Member)context.nextMember().clone();
            member.setMinOccurs(1);
            member.setMaxOccurs(1);
            while (SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer) != 3) {
                SchemaContext.State itemState = context.putSchemaConstruct((SchemaConstruct)member);
                Object o = SerializationHelper.deserializeCurrent((Tokenizer)dataTokenizer, (Token)currentToken, (Class)(class$java$lang$Object == null ? XMLMapDeserializer.class$("java.lang.Object") : class$java$lang$Object), (DeserializationContext)context);
                valueArray.add(o);
                context.leave(itemState);
            }
            context.leave(arrayState);
            SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
            return valueArray.toArray();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageProcessingException("Exception occured while parsing Map structure", (Throwable)e);
        }
    }

    protected Map createMapImplementation(Class targetClass) {
        Map fromTargetClass;
        if (targetClass != HASH_MAP_CLASS && (fromTargetClass = (Map)XMLCollectionDeserializer.createFromTargetClass(targetClass, class$java$util$Map == null ? (class$java$util$Map = XMLMapDeserializer.class$("java.util.Map")) : class$java$util$Map)) != null) {
            return fromTargetClass;
        }
        return new HashMap();
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }

    public void init(Configurable conf) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

