/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization.xsdbuiltin;

import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.DeserializationChain;
import org.idoox.wasp.serialization.DeserializationContext;
import org.idoox.wasp.serialization.Deserializer;
import org.idoox.wasp.serialization.Reference;
import org.idoox.xml.schema.Type;
import org.idoox.xmlrpc.MessageProcessingException;
import org.idoox.xmlrpc.encoding.EncodingTokenizer;

public class DateDeserializer
implements Deserializer {
    public String getMechanismType() {
        return Deserializer.MECHANISM_TYPE;
    }

    public Object deserialize(EncodingTokenizer dataTokenizer, Class targetClass, DeserializationContext context, DeserializationChain chain) throws MessageProcessingException {
        Deserializer deserializer = (Deserializer)chain.getNextDeserializerAs(Deserializer.MECHANISM_TYPE);
        Object ret = deserializer.deserialize(dataTokenizer, targetClass, context, chain);
        if (ret != null && ret instanceof Reference) {
            return new DateReference((Reference)ret);
        }
        return ret;
    }

    public void init(Configurable conf) {
    }

    class DateReference
    implements Reference {
        Reference prev;
        Reference next;
        Class valueClass;
        Type schemaType;
        Object value;

        DateReference(Reference prev) {
            this.prev = prev;
            this.valueClass = prev.getValueClass();
            this.schemaType = prev.getSchemaType();
            prev.setNextReference((Reference)this);
        }

        public Type getSchemaType() {
            if (this.next != null) {
                return this.next.getSchemaType();
            }
            return this.schemaType;
        }

        public void setNextReference(Reference nextReference) {
            if (this.next != null) {
                this.next.setNextReference(nextReference);
            } else {
                this.next = nextReference;
            }
        }

        public Object getObjectValue() {
            if (this.next != null) {
                return this.next.getObjectValue();
            }
            return this.value;
        }

        public void setObjectValue(Object value) {
            this.value = value;
            if (this.next != null) {
                this.next.setObjectValue(this.value);
            }
        }

        public Class getValueClass() {
            if (this.next != null) {
                return this.next.getValueClass();
            }
            return this.valueClass;
        }
    }
}

