/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.persistence;

import com.systinet.persistence.PersistenceException;
import com.systinet.persistence.tablemodel.Column;
import com.systinet.persistence.tablemodel.Table;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public final class ClassParser {
    private ClassParser() {
    }

    public static String getTableNameFor(Class clazz) {
        String clazzName = clazz.getName();
        int from = Math.max(clazzName.lastIndexOf(46), clazzName.lastIndexOf(36));
        return clazzName.substring(from + 1);
    }

    public static List getPersistentFields(Class clazz) {
        Field[] fields = clazz.getFields();
        ArrayList<Field> nonTransient = new ArrayList<Field>(fields.length);
        int i = 0;
        while (i < fields.length) {
            Field cf = fields[i];
            if (ClassParser.canBePersistentField(cf)) {
                nonTransient.add(cf);
            }
            ++i;
        }
        return nonTransient;
    }

    public static boolean canBePersistentField(Field field) {
        int fieldModifiers = field.getModifiers();
        return !Modifier.isTransient(fieldModifiers) && !Modifier.isStatic(fieldModifiers);
    }

    static Table parse(Class clazz) throws PersistenceException {
        ClassParser.checkClassRequirement(clazz);
        Table table = new Table();
        String tableName = ClassParser.getTableNameFor(clazz);
        table.setName(tableName);
        Field[] fields = clazz.getFields();
        int i = 0;
        while (i < fields.length) {
            Column newCol = ClassParser.processField(fields[i]);
            if (newCol != null) {
                table.addColumn(newCol);
            }
            ++i;
        }
        if (table.columns().size() == 0) {
            throw new PersistenceException(clazz.getName() + " has no public non-transient fields");
        }
        return table;
    }

    private static Column processField(Field field) {
        if (!ClassParser.canBePersistentField(field)) {
            return null;
        }
        String name = field.getName();
        Class<?> type = field.getType();
        return new Column(name, type);
    }

    private static void checkClassRequirement(Class clazz) throws PersistenceException {
        if (!Modifier.isPublic(clazz.getModifiers())) {
            throw new PersistenceException(clazz.getName() + " is not public");
        }
        Constructor<?>[] constructors = clazz.getConstructors();
        int i = 0;
        while (i < constructors.length) {
            if (constructors[i].getParameterTypes().length == 0) {
                return;
            }
            ++i;
        }
        throw new PersistenceException(clazz.getName() + " has no public parameterless constructor");
    }
}

