/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.persistence;

import com.systinet.persistence.DatabaseSchemaHelper;
import com.systinet.persistence.PersistenceException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class FieldSetterManager {
    private Map byJavaMap = new HashMap();
    private Map bySqlMap = new HashMap();
    private Map byJavaAndSqlMap = new HashMap();
    public static final FieldSetter OBJECT_FIELD_SETTER = new DefaultFieldSetter();
    public static final BySqlFieldSetter BLOB_FIELD_SETTER = new BlobFieldSetter();
    public static final BySqlFieldSetter BINARY_FIELD_SETTER = new BinaryFieldSetter();
    public static final FieldSetterManager DEFAULT_FIELD_SETTER_MANAGER;

    static FieldSetterManager createUnmodifiableInstance(FieldSetterManager fsm) {
        FieldSetterManager unmodFsm = new FieldSetterManager(){

            public void register(ByJavaFieldSetter fieldSetter) {
                throw new UnsupportedOperationException("This FieldSetterManager is unmofiable");
            }

            public void register(BySqlFieldSetter fieldSetter) {
                throw new UnsupportedOperationException("This FieldSetterManager is unmofiable");
            }

            public void register(ByJavaAndSqlFieldSetter fieldSetter) {
                throw new UnsupportedOperationException("This FieldSetterManager is unmofiable");
            }
        };
        unmodFsm.byJavaMap = fsm.byJavaMap;
        unmodFsm.bySqlMap = fsm.bySqlMap;
        unmodFsm.byJavaAndSqlMap = fsm.byJavaAndSqlMap;
        return unmodFsm;
    }

    public void register(ByJavaFieldSetter fieldSetter) {
        this.byJavaMap.put(fieldSetter.forFieldType(), fieldSetter);
    }

    public void register(BySqlFieldSetter fieldSetter) {
        Integer key = new Integer(fieldSetter.forSqlType());
        this.bySqlMap.put(key, fieldSetter);
    }

    public void register(ByJavaAndSqlFieldSetter fieldSetter) {
        JavaAndSqlKey key = new JavaAndSqlKey(fieldSetter.forFieldType(), fieldSetter.forSqlType());
        this.byJavaAndSqlMap.put(key, fieldSetter);
    }

    public FieldSetter findSetter(Class javaType, Integer sqlType) {
        FieldSetter res;
        JavaAndSqlKey searchKey;
        FieldSetter res2;
        if (javaType != null && sqlType != null && (res2 = (FieldSetter)this.byJavaAndSqlMap.get(searchKey = new JavaAndSqlKey(javaType, sqlType))) != null) {
            return res2;
        }
        if (sqlType != null && (res = (FieldSetter)this.bySqlMap.get(sqlType)) != null) {
            return res;
        }
        if (javaType != null && (res = (FieldSetter)this.byJavaMap.get(javaType)) != null) {
            return res;
        }
        return null;
    }

    static {
        FieldSetterManager modFsm = new FieldSetterManager();
        modFsm.register(new PrimBooleanFieldSetter());
        modFsm.register(new BooleanFieldSetter());
        modFsm.register(new PrimCharFieldSetter());
        modFsm.register(new CharacterFieldSetter());
        modFsm.register(new PrimByteFieldSetter());
        modFsm.register(new ByteFieldSetter());
        modFsm.register(new PrimShortFieldSetter());
        modFsm.register(new ShortFieldSetter());
        modFsm.register(new PrimIntFieldSetter());
        modFsm.register(new IntegerFieldSetter());
        modFsm.register(new PrimLongFieldSetter());
        modFsm.register(new LongFieldSetter());
        modFsm.register(new PrimFloatFieldSetter());
        modFsm.register(new FloatFieldSetter());
        modFsm.register(new PrimDoubleFieldSetter());
        modFsm.register(new DoubleFieldSetter());
        modFsm.register(new DateFieldSetter());
        modFsm.register(new StringFieldSetter());
        DEFAULT_FIELD_SETTER_MANAGER = FieldSetterManager.createUnmodifiableInstance(modFsm);
    }

    public static class BlobFieldSetterWithLoader
    extends BlobFieldSetter {
        private BinaryFieldSetterWithLoader realSetter;

        public BlobFieldSetterWithLoader(ClassLoader loader) {
            this.realSetter = new BinaryFieldSetterWithLoader(loader);
        }

        public void setField(Field field, Object instance, ResultSet source, int colIndex, int sqlType) throws SQLException, IllegalAccessException, PersistenceException {
            this.realSetter.setField(field, instance, source, colIndex, sqlType);
        }
    }

    public static class BinaryFieldSetterWithLoader
    extends BinaryFieldSetter {
        private ClassLoader loader;

        public BinaryFieldSetterWithLoader(ClassLoader loader) {
            if (loader == null) {
                throw new NullPointerException("loader parameter must not be null");
            }
            this.loader = loader;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setField(Field field, Object instance, ResultSet source, int colIndex, int sqlType) throws SQLException, IllegalAccessException, PersistenceException {
            try {
                InputStream is = null;
                try {
                    is = source.getBinaryStream(colIndex);
                    Object value = null;
                    if (is != null) {
                        ObjectInputStreamWithLoader ois = new ObjectInputStreamWithLoader(is, this.loader);
                        value = ois.readObject();
                    }
                    field.set(instance, value);
                    Object var10_11 = null;
                    if (is == null) return;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                is.close();
                return;
            }
            catch (ClassNotFoundException cnfe) {
                throw new PersistenceException("Class to be deserialized from BINARY not found: " + cnfe.getMessage(), cnfe);
            }
            catch (IOException ioe) {
                throw new PersistenceException("Error reading BINARY column '" + field.getName() + "': " + ioe.getMessage(), ioe);
            }
        }
    }

    public static class ObjectInputStreamWithLoader
    extends ObjectInputStream {
        private ClassLoader loader;

        public ObjectInputStreamWithLoader(InputStream in, ClassLoader loader) throws IOException {
            super(in);
            if (loader == null) {
                throw new NullPointerException("Param 'loader' is null");
            }
            this.loader = loader;
        }

        protected Class resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
            Class<Comparable<Byte>> simpleType;
            String name = classDesc.getName();
            if (!name.startsWith("[")) {
                return this.loader.loadClass(name);
            }
            int dimension = 0;
            while (name.charAt(dimension) == '[') {
                ++dimension;
            }
            if (name.charAt(dimension) == 'L') {
                String simpleTypeName = name.substring(dimension + 1, name.length() - 1);
                simpleType = this.loader.loadClass(simpleTypeName);
            } else {
                switch (name.charAt(dimension)) {
                    case 'B': {
                        simpleType = Byte.TYPE;
                        break;
                    }
                    case 'C': {
                        simpleType = Character.TYPE;
                        break;
                    }
                    case 'D': {
                        simpleType = Double.TYPE;
                        break;
                    }
                    case 'F': {
                        simpleType = Float.TYPE;
                        break;
                    }
                    case 'I': {
                        simpleType = Integer.TYPE;
                        break;
                    }
                    case 'J': {
                        simpleType = Long.TYPE;
                        break;
                    }
                    case 'S': {
                        simpleType = Short.TYPE;
                        break;
                    }
                    case 'Z': {
                        simpleType = Boolean.TYPE;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(classDesc + " is invalid");
                    }
                }
            }
            int[] sizeTemplate = new int[dimension];
            int i = 0;
            while (i < dimension) {
                sizeTemplate[i] = 0;
                ++i;
            }
            return Array.newInstance(simpleType, sizeTemplate).getClass();
        }
    }

    static class DefaultFieldSetter
    implements FieldSetter {
        DefaultFieldSetter() {
        }

        public void setField(Field field, Object instance, ResultSet source, int colIndex, int sqlType) throws SQLException, IllegalAccessException, PersistenceException {
            Object object = source.getObject(colIndex);
            field.set(instance, object);
        }

        public void setStatement(PreparedStatement pstmt, int colIndex, Field fromField, Object source) throws IllegalAccessException, SQLException, IllegalArgumentException, PersistenceException {
            pstmt.setObject(colIndex, fromField.get(source));
        }
    }

    static class BlobFieldSetter
    implements BySqlFieldSetter {
        BlobFieldSetter() {
        }

        public int forSqlType() {
            return 2004;
        }

        public void setField(Field field, Object instance, ResultSet source, int colIndex, int sqlType) throws SQLException, IllegalAccessException, PersistenceException {
            BINARY_FIELD_SETTER.setField(field, instance, source, colIndex, sqlType);
        }

        public void setStatement(PreparedStatement pstmt, int colIndex, Field fromField, Object source) throws IllegalAccessException, SQLException, IllegalArgumentException, PersistenceException {
            BINARY_FIELD_SETTER.setStatement(pstmt, colIndex, fromField, source);
        }
    }

    static class BinaryFieldSetter
    implements BySqlFieldSetter {
        BinaryFieldSetter() {
        }

        public int forSqlType() {
            return -2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setField(Field field, Object instance, ResultSet source, int colIndex, int sqlType) throws SQLException, IllegalAccessException, PersistenceException {
            try {
                InputStream is = null;
                try {
                    is = source.getBinaryStream(colIndex);
                    Object value = null;
                    if (is != null) {
                        ObjectInputStream ois = new ObjectInputStream(is);
                        value = ois.readObject();
                    }
                    field.set(instance, value);
                    Object var10_11 = null;
                    if (is == null) return;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                is.close();
                return;
            }
            catch (ClassNotFoundException cnfe) {
                throw new PersistenceException("Class to be deserialized from BINARY not found: " + cnfe.getMessage(), cnfe);
            }
            catch (IOException ioe) {
                throw new PersistenceException("Error reading BINARY column '" + field.getName() + "': " + ioe.getMessage(), ioe);
            }
        }

        public void setStatement(PreparedStatement pstmt, int colIndex, Field fromField, Object source) throws IllegalAccessException, SQLException, IllegalArgumentException, PersistenceException {
            Object obj = fromField.get(source);
            if (obj == null) {
                pstmt.setNull(colIndex, -2);
                return;
            }
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(obj);
                oos.close();
                pstmt.setBytes(colIndex, baos.toByteArray());
            }
            catch (IOException ioe) {
                throw new PersistenceException("Cannot serialize a static class: " + ioe.getMessage(), ioe);
            }
        }
    }

    static class StringFieldSetter
    implements ByJavaFieldSetter {
        static /* synthetic */ Class class$java$lang$String;

        StringFieldSetter() {
        }

        public Class forFieldType() {
            return class$java$lang$String == null ? (class$java$lang$String = StringFieldSetter.class$("java.lang.String")) : class$java$lang$String;
        }

        public void setField(Field field, Object instance, ResultSet source, int colIndex, int sqlType) throws SQLException, IllegalAccessException, PersistenceException {
            field.set(instance, source.getObject(colIndex));
        }

        public void setStatement(PreparedStatement pstmt, int colIndex, Field fromField, Object source) throws IllegalAccessException, SQLException, IllegalArgumentException, PersistenceException {
            String strValue = (String)fromField.get(source);
            if (strValue == null) {
                pstmt.setNull(colIndex, 12);
                return;
            }
            int stringLimit = DatabaseSchemaHelper.getInstance().getUsedStringLength();
            if (stringLimit < strValue.length()) {
                throw new PersistenceException("String value '" + strValue + "' is longer that " + stringLimit + " and does not fit into the database column");
            }
            pstmt.setString(colIndex, strValue);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    static class DateFieldSetter
    implements ByJavaFieldSetter {
        static /* synthetic */ Class class$java$util$Date;

        DateFieldSetter() {
        }

        public Class forFieldType() {
            return class$java$util$Date == null ? (class$java$util$Date = DateFieldSetter.class$("java.util.Date")) : class$java$util$Date;
        }

        public void setField(Field field, Object instance, ResultSet source, int colIndex, int sqlType) throws SQLException, IllegalAccessException {
            Timestamp timeStamp = source.getTimestamp(colIndex);
            if (timeStamp == null) {
                field.set(instance, null);
            } else {
                field.set(instance, new Date(((Date)timeStamp).getTime()));
            }
        }

        public void setStatement(PreparedStatement pstmt, int colIndex, Field fromField, Object source) throws IllegalAccessException, SQLException, IllegalArgumentException {
            Date dateObj = (Date)fromField.get(source);
            if (dateObj == null) {
                pstmt.setNull(colIndex, 93);
            } else {
                long time = dateObj.getTime();
                pstmt.setTimestamp(colIndex, new Timestamp(time));
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    static class DoubleFieldSetter
    implements ByJavaFieldSetter {
        static /* synthetic */ Class class$java$lang$Double;

        DoubleFieldSetter() {
        }

        public Class forFieldType() {
            return class$java$lang$Double == null ? (class$java$lang$Double = DoubleFieldSetter.class$("java.lang.Double")) : class$java$lang$Double;
        }

        public void setField(Field field, Object instance, ResultSet source, int colIndex, int sqlType) throws SQLException, IllegalAccessException {
            double doubleVal = source.getDouble(colIndex);
            if (source.wasNull()) {
                field.set(instance, null);
            } else {
                field.set(instance, new Double(doubleVal));
            }
        }

        public void setStatement(PreparedStatement pstmt, int colIndex, Field fromField, Object source) throws IllegalAccessException, SQLException, IllegalArgumentException {
            Double doubleObj = (Double)fromField.get(source);
            if (doubleObj == null) {
                pstmt.setNull(colIndex, 7);
            } else {
                pstmt.setDouble(colIndex, doubleObj);
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    static class PrimDoubleFieldSetter
    implements ByJavaFieldSetter {
        PrimDoubleFieldSetter() {
        }

        public Class forFieldType() {
            return Double.TYPE;
        }

        public void setField(Field field, Object instance, ResultSet source, int colIndex, int sqlType) throws SQLException, IllegalAccessException {
            double doubleVal = source.getDouble(colIndex);
            field.setDouble(instance, doubleVal);
        }

        public void setStatement(PreparedStatement pstmt, int colIndex, Field fromField, Object source) throws IllegalAccessException, SQLException, IllegalArgumentException {
            pstmt.setDouble(colIndex, fromField.getDouble(source));
        }
    }

    static class FloatFieldSetter
    implements ByJavaFieldSetter {
        static /* synthetic */ Class class$java$lang$Float;

        FloatFieldSetter() {
        }

        public Class forFieldType() {
            return class$java$lang$Float == null ? (class$java$lang$Float = FloatFieldSetter.class$("java.lang.Float")) : class$java$lang$Float;
        }

        public void setField(Field field, Object instance, ResultSet source, int colIndex, int sqlType) throws SQLException, IllegalAccessException {
            float floatVal = source.getFloat(colIndex);
            if (source.wasNull()) {
                field.set(instance, null);
            } else {
                field.set(instance, new Float(floatVal));
            }
        }

        public void setStatement(PreparedStatement pstmt, int colIndex, Field fromField, Object source) throws IllegalAccessException, SQLException, IllegalArgumentException {
            Float floatObj = (Float)fromField.get(source);
            if (floatObj == null) {
                pstmt.setNull(colIndex, 6);
            } else {
                pstmt.setFloat(colIndex, floatObj.floatValue());
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    static class PrimFloatFieldSetter
    implements ByJavaFieldSetter {
        PrimFloatFieldSetter() {
        }

        public Class forFieldType() {
            return Float.TYPE;
        }

        public void setField(Field field, Object instance, ResultSet source, int colIndex, int sqlType) throws SQLException, IllegalAccessException {
            float floatVal = source.getFloat(colIndex);
            field.setFloat(instance, floatVal);
        }

        public void setStatement(PreparedStatement pstmt, int colIndex, Field fromField, Object source) throws IllegalAccessException, SQLException, IllegalArgumentException {
            pstmt.setFloat(colIndex, fromField.getFloat(source));
        }
    }

    static class LongFieldSetter
    implements ByJavaFieldSetter {
        static /* synthetic */ Class class$java$lang$Long;

        LongFieldSetter() {
        }

        public Class forFieldType() {
            return class$java$lang$Long == null ? (class$java$lang$Long = LongFieldSetter.class$("java.lang.Long")) : class$java$lang$Long;
        }

        public void setField(Field field, Object instance, ResultSet source, int colIndex, int sqlType) throws SQLException, IllegalAccessException {
            long longVal = source.getLong(colIndex);
            if (source.wasNull()) {
                field.set(instance, null);
            } else {
                field.set(instance, new Long(longVal));
            }
        }

        public void setStatement(PreparedStatement pstmt, int colIndex, Field fromField, Object source) throws IllegalAccessException, SQLException, IllegalArgumentException {
            Long longObj = (Long)fromField.get(source);
            if (longObj == null) {
                pstmt.setNull(colIndex, -5);
            } else {
                pstmt.setLong(colIndex, longObj);
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    static class PrimLongFieldSetter
    implements ByJavaFieldSetter {
        PrimLongFieldSetter() {
        }

        public Class forFieldType() {
            return Long.TYPE;
        }

        public void setField(Field field, Object instance, ResultSet source, int colIndex, int sqlType) throws SQLException, IllegalAccessException {
            long longVal = source.getLong(colIndex);
            field.setLong(instance, longVal);
        }

        public void setStatement(PreparedStatement pstmt, int colIndex, Field fromField, Object source) throws IllegalAccessException, SQLException, IllegalArgumentException {
            pstmt.setLong(colIndex, fromField.getLong(source));
        }
    }

    static class IntegerFieldSetter
    implements ByJavaFieldSetter {
        static /* synthetic */ Class class$java$lang$Integer;

        IntegerFieldSetter() {
        }

        public Class forFieldType() {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = IntegerFieldSetter.class$("java.lang.Integer")) : class$java$lang$Integer;
        }

        public void setField(Field field, Object instance, ResultSet source, int colIndex, int sqlType) throws SQLException, IllegalAccessException {
            int intVal = source.getInt(colIndex);
            if (source.wasNull()) {
                field.set(instance, null);
            } else {
                field.set(instance, new Integer(intVal));
            }
        }

        public void setStatement(PreparedStatement pstmt, int colIndex, Field fromField, Object source) throws IllegalAccessException, SQLException, IllegalArgumentException {
            Integer integerObj = (Integer)fromField.get(source);
            if (integerObj == null) {
                pstmt.setNull(colIndex, 4);
            } else {
                pstmt.setInt(colIndex, integerObj);
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    static class PrimIntFieldSetter
    implements ByJavaFieldSetter {
        PrimIntFieldSetter() {
        }

        public Class forFieldType() {
            return Integer.TYPE;
        }

        public void setField(Field field, Object instance, ResultSet source, int colIndex, int sqlType) throws SQLException, IllegalAccessException {
            int intVal = source.getInt(colIndex);
            field.setInt(instance, intVal);
        }

        public void setStatement(PreparedStatement pstmt, int colIndex, Field fromField, Object source) throws IllegalAccessException, SQLException, IllegalArgumentException {
            pstmt.setInt(colIndex, fromField.getInt(source));
        }
    }

    static class ShortFieldSetter
    implements ByJavaFieldSetter {
        static /* synthetic */ Class class$java$lang$Short;

        ShortFieldSetter() {
        }

        public Class forFieldType() {
            return class$java$lang$Short == null ? (class$java$lang$Short = ShortFieldSetter.class$("java.lang.Short")) : class$java$lang$Short;
        }

        public void setField(Field field, Object instance, ResultSet source, int colIndex, int sqlType) throws SQLException, IllegalAccessException {
            short shortVal = source.getShort(colIndex);
            if (source.wasNull()) {
                field.set(instance, null);
            } else {
                field.set(instance, new Short(shortVal));
            }
        }

        public void setStatement(PreparedStatement pstmt, int colIndex, Field fromField, Object source) throws IllegalAccessException, SQLException, IllegalArgumentException {
            Short shortObj = (Short)fromField.get(source);
            if (shortObj == null) {
                pstmt.setNull(colIndex, 4);
            } else {
                pstmt.setShort(colIndex, shortObj);
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    static class PrimShortFieldSetter
    implements ByJavaFieldSetter {
        PrimShortFieldSetter() {
        }

        public Class forFieldType() {
            return Short.TYPE;
        }

        public void setField(Field field, Object instance, ResultSet source, int colIndex, int sqlType) throws SQLException, IllegalAccessException {
            short shortVal = source.getShort(colIndex);
            field.setShort(instance, shortVal);
        }

        public void setStatement(PreparedStatement pstmt, int colIndex, Field fromField, Object source) throws IllegalAccessException, SQLException, IllegalArgumentException {
            pstmt.setShort(colIndex, fromField.getShort(source));
        }
    }

    static class ByteFieldSetter
    implements ByJavaFieldSetter {
        static /* synthetic */ Class class$java$lang$Byte;

        ByteFieldSetter() {
        }

        public Class forFieldType() {
            return class$java$lang$Byte == null ? (class$java$lang$Byte = ByteFieldSetter.class$("java.lang.Byte")) : class$java$lang$Byte;
        }

        public void setField(Field field, Object instance, ResultSet source, int colIndex, int sqlType) throws SQLException, IllegalAccessException {
            byte byteVal = source.getByte(colIndex);
            if (source.wasNull()) {
                field.set(instance, null);
            } else {
                field.set(instance, new Byte(byteVal));
            }
        }

        public void setStatement(PreparedStatement pstmt, int colIndex, Field fromField, Object source) throws IllegalAccessException, SQLException, IllegalArgumentException {
            Byte byteObj = (Byte)fromField.get(source);
            if (byteObj == null) {
                pstmt.setNull(colIndex, 4);
            } else {
                pstmt.setByte(colIndex, byteObj);
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    static class PrimByteFieldSetter
    implements ByJavaFieldSetter {
        PrimByteFieldSetter() {
        }

        public Class forFieldType() {
            return Byte.TYPE;
        }

        public void setField(Field field, Object instance, ResultSet source, int colIndex, int sqlType) throws SQLException, IllegalAccessException {
            byte byteVal = source.getByte(colIndex);
            field.setByte(instance, byteVal);
        }

        public void setStatement(PreparedStatement pstmt, int colIndex, Field fromField, Object source) throws IllegalAccessException, SQLException, IllegalArgumentException {
            pstmt.setByte(colIndex, fromField.getByte(source));
        }
    }

    static class CharacterFieldSetter
    implements ByJavaFieldSetter {
        static /* synthetic */ Class class$java$lang$Character;

        CharacterFieldSetter() {
        }

        public Class forFieldType() {
            return class$java$lang$Character == null ? (class$java$lang$Character = CharacterFieldSetter.class$("java.lang.Character")) : class$java$lang$Character;
        }

        public void setField(Field field, Object instance, ResultSet source, int colIndex, int sqlType) throws SQLException, IllegalAccessException, PersistenceException {
            String strVal = source.getString(colIndex);
            if (source.wasNull()) {
                field.set(instance, null);
                return;
            }
            if (strVal.length() != 1) {
                throw new PersistenceException("Value to field " + field + " must be 1 char; was=" + strVal);
            }
            field.set(instance, new Character(strVal.charAt(0)));
        }

        public void setStatement(PreparedStatement pstmt, int colIndex, Field fromField, Object source) throws IllegalAccessException, SQLException {
            Character ch = (Character)fromField.get(source);
            if (ch == null) {
                pstmt.setNull(colIndex, 1);
            } else {
                pstmt.setString(colIndex, ch.toString());
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    static class PrimCharFieldSetter
    implements ByJavaFieldSetter {
        PrimCharFieldSetter() {
        }

        public Class forFieldType() {
            return Character.TYPE;
        }

        public void setField(Field field, Object instance, ResultSet source, int colIndex, int sqlType) throws SQLException, IllegalAccessException, PersistenceException {
            String strVal = source.getString(colIndex);
            if (strVal == null) {
                throw new PersistenceException("Value of primitive char field was null in DB");
            }
            if (strVal.length() != 1) {
                throw new PersistenceException("Value to field " + field + " must be 1 char; was=" + strVal);
            }
            field.setChar(instance, strVal.charAt(0));
        }

        public void setStatement(PreparedStatement pstmt, int colIndex, Field fromField, Object source) throws IllegalAccessException, SQLException {
            String charStr = String.valueOf(fromField.getChar(source));
            pstmt.setString(colIndex, charStr);
        }
    }

    static class BooleanFieldSetter
    implements ByJavaFieldSetter {
        static /* synthetic */ Class class$java$lang$Boolean;

        BooleanFieldSetter() {
        }

        public Class forFieldType() {
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = BooleanFieldSetter.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }

        public void setField(Field field, Object instance, ResultSet source, int colIndex, int sqlType) throws SQLException, IllegalAccessException {
            boolean boolVal = source.getBoolean(colIndex);
            if (source.wasNull()) {
                field.set(instance, null);
            } else {
                field.set(instance, boolVal ? Boolean.TRUE : Boolean.FALSE);
            }
        }

        public void setStatement(PreparedStatement pstmt, int colIndex, Field fromField, Object source) throws IllegalAccessException, SQLException, IllegalArgumentException {
            Boolean boolObj = (Boolean)fromField.get(source);
            if (boolObj == null) {
                pstmt.setNull(colIndex, -6);
            } else {
                pstmt.setBoolean(colIndex, boolObj);
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    static class PrimBooleanFieldSetter
    implements ByJavaFieldSetter {
        PrimBooleanFieldSetter() {
        }

        public Class forFieldType() {
            return Boolean.TYPE;
        }

        public void setField(Field field, Object instance, ResultSet source, int colIndex, int sqlType) throws SQLException, IllegalAccessException {
            field.setBoolean(instance, source.getBoolean(colIndex));
        }

        public void setStatement(PreparedStatement pstmt, int colIndex, Field fromField, Object source) throws SQLException, IllegalAccessException {
            pstmt.setBoolean(colIndex, fromField.getBoolean(source));
        }
    }

    public static interface ByJavaAndSqlFieldSetter
    extends ByJavaFieldSetter,
    BySqlFieldSetter {
    }

    public static interface BySqlFieldSetter
    extends FieldSetter {
        public int forSqlType();
    }

    public static interface ByJavaFieldSetter
    extends FieldSetter {
        public Class forFieldType();
    }

    public static interface FieldSetter {
        public void setField(Field var1, Object var2, ResultSet var3, int var4, int var5) throws SQLException, IllegalAccessException, PersistenceException;

        public void setStatement(PreparedStatement var1, int var2, Field var3, Object var4) throws IllegalAccessException, SQLException, IllegalArgumentException, PersistenceException;
    }

    private static class JavaAndSqlKey {
        Class javaType;
        int sqlType;

        JavaAndSqlKey(Class javaType, int sqlType) {
            this.javaType = javaType;
            this.sqlType = sqlType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof JavaAndSqlKey)) {
                return false;
            }
            JavaAndSqlKey javaAndSqlKey = (JavaAndSqlKey)o;
            if (this.sqlType != javaAndSqlKey.sqlType) {
                return false;
            }
            return !(this.javaType != null ? !this.javaType.equals(javaAndSqlKey.javaType) : javaAndSqlKey.javaType != null);
        }

        public int hashCode() {
            int result = this.javaType != null ? this.javaType.hashCode() : 0;
            result = 29 * result + this.sqlType;
            return result;
        }
    }
}

